/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.Constants;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contract.config.ForwardedExtensionConfig;
import org.wso2.transport.http.netty.contract.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contract.config.ProxyServerConfiguration;
import org.wso2.transport.http.netty.contract.config.SenderConfiguration;
import org.wso2.transport.http.netty.contract.exceptions.ConfigurationException;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.BackPressureHandler;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLHandlerFactory;
import org.wso2.transport.http.netty.contractimpl.listener.HttpTraceLoggingHandler;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.sender.CertificateValidationHandler;
import org.wso2.transport.http.netty.contractimpl.sender.ForwardedHeaderUpdater;
import org.wso2.transport.http.netty.contractimpl.sender.OCSPStaplingHandler;
import org.wso2.transport.http.netty.message.DefaultBackPressureListener;
import org.wso2.transport.http.netty.message.DefaultListener;
import org.wso2.transport.http.netty.message.Http2InboundContentListener;
import org.wso2.transport.http.netty.message.Http2PassthroughBackPressureListener;
import org.wso2.transport.http.netty.message.Http2Reset;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.PassthroughBackPressureListener;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;

public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^}]*)}");

    private Util() {
    }

    private static String getStringValue(HttpCarbonMessage msg, String key, String defaultValue) {
        String value = (String)msg.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static int getIntValue(HttpCarbonMessage msg) {
        Integer value = msg.getHttpStatusCode();
        if (value == null) {
            return 200;
        }
        return value;
    }

    public static HttpResponse createHttpResponse(HttpCarbonMessage outboundResponseMsg, String inboundReqHttpVersion, String serverName, boolean keepAlive) {
        HttpVersion httpVersion = new HttpVersion("HTTP/" + inboundReqHttpVersion, true);
        HttpResponseStatus httpResponseStatus = Util.getHttpResponseStatus(outboundResponseMsg);
        DefaultHttpResponse outboundNettyResponse = new DefaultHttpResponse(httpVersion, httpResponseStatus);
        Util.setOutboundRespHeaders(outboundResponseMsg, inboundReqHttpVersion, serverName, keepAlive, (HttpResponse)outboundNettyResponse);
        return outboundNettyResponse;
    }

    public static HttpResponse createFullHttpResponse(HttpCarbonMessage outboundResponseMsg, String inboundReqHttpVersion, String serverName, boolean keepAlive, ByteBuf fullContent) {
        HttpVersion httpVersion = new HttpVersion("HTTP/" + inboundReqHttpVersion, true);
        HttpResponseStatus httpResponseStatus = Util.getHttpResponseStatus(outboundResponseMsg);
        DefaultFullHttpResponse outboundNettyResponse = new DefaultFullHttpResponse(httpVersion, httpResponseStatus, fullContent);
        Util.setOutboundRespHeaders(outboundResponseMsg, inboundReqHttpVersion, serverName, keepAlive, (HttpResponse)outboundNettyResponse);
        return outboundNettyResponse;
    }

    private static void setOutboundRespHeaders(HttpCarbonMessage outboundResponseMsg, String inboundReqHttpVersion, String serverName, boolean keepAlive, HttpResponse outboundNettyResponse) {
        if (!keepAlive && Float.valueOf(inboundReqHttpVersion).floatValue() >= 1.1f) {
            outboundResponseMsg.setHeader(HttpHeaderNames.CONNECTION.toString(), "close");
        } else if (keepAlive && Float.valueOf(inboundReqHttpVersion).floatValue() < 1.1f) {
            outboundResponseMsg.setHeader(HttpHeaderNames.CONNECTION.toString(), "keep-alive");
        } else {
            outboundResponseMsg.removeHeader(HttpHeaderNames.CONNECTION.toString());
        }
        if (outboundResponseMsg.getHeader(HttpHeaderNames.SERVER.toString()) == null) {
            outboundResponseMsg.setHeader(HttpHeaderNames.SERVER.toString(), serverName);
        }
        if (outboundResponseMsg.getHeader(HttpHeaderNames.DATE.toString()) == null) {
            outboundResponseMsg.setHeader(HttpHeaderNames.DATE.toString(), ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
        }
        outboundNettyResponse.headers().add(outboundResponseMsg.getHeaders());
    }

    public static HttpResponseStatus getHttpResponseStatus(HttpCarbonMessage msg) {
        int statusCode = Util.getIntValue(msg);
        String reasonPhrase = Util.getStringValue(msg, "HTTP_REASON_PHRASE", HttpResponseStatus.valueOf((int)statusCode).reasonPhrase());
        return new HttpResponseStatus(statusCode, reasonPhrase);
    }

    public static HttpRequest createHttpRequest(HttpCarbonMessage outboundRequestMsg) {
        HttpMethod httpMethod = Util.getHttpMethod(outboundRequestMsg);
        HttpVersion httpVersion = Util.getHttpVersion(outboundRequestMsg);
        String requestPath = Util.getRequestPath(outboundRequestMsg);
        DefaultHttpRequest outboundNettyRequest = new DefaultHttpRequest(httpVersion, httpMethod, (String)outboundRequestMsg.getProperty("TO"));
        outboundNettyRequest.setMethod(httpMethod);
        outboundNettyRequest.setProtocolVersion(httpVersion);
        outboundNettyRequest.setUri(requestPath);
        outboundNettyRequest.headers().add(outboundRequestMsg.getHeaders());
        return outboundNettyRequest;
    }

    private static String getRequestPath(HttpCarbonMessage outboundRequestMsg) {
        if (outboundRequestMsg.getProperty("TO") == null) {
            outboundRequestMsg.setProperty("TO", "");
        }
        if (outboundRequestMsg.getProperty("IS_PROXY_ENABLED") != null && ((Boolean)outboundRequestMsg.getProperty("IS_PROXY_ENABLED")).booleanValue() && outboundRequestMsg.getProperty("PROTOCOL").equals("http")) {
            return outboundRequestMsg.getProperty("PROTOCOL") + "://" + outboundRequestMsg.getProperty("host") + ":" + outboundRequestMsg.getProperty("port") + outboundRequestMsg.getProperty("TO");
        }
        return (String)outboundRequestMsg.getProperty("TO");
    }

    private static HttpVersion getHttpVersion(HttpCarbonMessage outboundRequestMsg) {
        HttpVersion httpVersion = null != outboundRequestMsg.getHttpVersion() ? new HttpVersion("HTTP/" + outboundRequestMsg.getHttpVersion(), true) : new HttpVersion("HTTP/1.1", true);
        return httpVersion;
    }

    private static HttpMethod getHttpMethod(HttpCarbonMessage outboundRequestMsg) {
        HttpMethod httpMethod = null != outboundRequestMsg.getHttpMethod() ? new HttpMethod(outboundRequestMsg.getHttpMethod()) : new HttpMethod("POST");
        return httpMethod;
    }

    public static void setupChunkedRequest(HttpCarbonMessage httpOutboundRequest) {
        httpOutboundRequest.removeHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        if (httpOutboundRequest.getHeader(HttpHeaderNames.TRANSFER_ENCODING.toString()) == null) {
            httpOutboundRequest.setHeader(HttpHeaderNames.TRANSFER_ENCODING.toString(), "chunked");
        }
    }

    public static HttpRequest createHttpRequestFromHttp2Headers(Http2Headers http2Headers, int streamId) throws Http2Exception {
        String method = "GET";
        if (http2Headers.method() != null) {
            method = ((CharSequence)http2Headers.getAndRemove((Object)":method")).toString();
        }
        String path = "/";
        if (http2Headers.path() != null) {
            path = ((CharSequence)http2Headers.getAndRemove((Object)":path")).toString();
        }
        http2Headers.getAndRemove((Object)":authority");
        http2Headers.getAndRemove((Object)":scheme");
        HttpVersion version = new HttpVersion("HTTP/2.0", true);
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(version, HttpMethod.valueOf((String)method), path);
        HttpConversionUtil.addHttp2ToHttpHeaders((int)streamId, (Http2Headers)http2Headers, (HttpHeaders)httpRequest.headers(), (HttpVersion)version, (boolean)false, (boolean)true);
        CharSequence trailerHeaderValue = (CharSequence)http2Headers.get((Object)HttpHeaderNames.TRAILER.toString());
        if (trailerHeaderValue != null) {
            httpRequest.headers().add(HttpHeaderNames.TRAILER.toString(), (Object)trailerHeaderValue.toString());
        }
        return httpRequest;
    }

    public static void setupContentLengthRequest(HttpCarbonMessage httpOutboundRequest, long contentLength) {
        Util.removeContentLengthAndTransferEncodingHeaders(httpOutboundRequest);
        httpOutboundRequest.setHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(contentLength));
    }

    public static boolean checkContentLengthAndTransferEncodingHeaderAllowance(HttpCarbonMessage httpOutboundRequest) {
        HttpMethod method = Util.getHttpMethod(httpOutboundRequest);
        if (httpOutboundRequest.getProperty("NO_ENTITY_BODY") == null) {
            return true;
        }
        boolean nonEntityBodyRequest = (Boolean)httpOutboundRequest.getProperty("NO_ENTITY_BODY");
        if (nonEntityBodyRequest && (HttpMethod.GET.equals((Object)method) || HttpMethod.HEAD.equals((Object)method) || HttpMethod.OPTIONS.equals((Object)method))) {
            Util.removeContentLengthAndTransferEncodingHeaders(httpOutboundRequest);
            return false;
        }
        return true;
    }

    private static void removeContentLengthAndTransferEncodingHeaders(HttpCarbonMessage httpOutboundRequest) {
        httpOutboundRequest.removeHeader(HttpHeaderNames.TRANSFER_ENCODING.toString());
        httpOutboundRequest.removeHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
    }

    public static boolean isVersionCompatibleForChunking(String httpVersion) {
        return Float.valueOf(httpVersion).floatValue() >= 1.1f;
    }

    public static boolean shouldEnforceChunkingforHttpOneZero(ChunkConfig chunkConfig, String httpVersion) {
        return chunkConfig == ChunkConfig.ALWAYS && Float.valueOf(httpVersion).floatValue() >= 1.0f;
    }

    public static SSLEngine configureHttpPipelineForSSL(SocketChannel socketChannel, String host, int port, SSLConfig sslConfig) {
        LOG.debug("adding ssl handler");
        SSLEngine sslEngine = null;
        ChannelPipeline pipeline = socketChannel.pipeline();
        if (sslConfig.isOcspStaplingEnabled()) {
            ReferenceCountedOpenSslContext referenceCountedOpenSslContext = sslConfig.getReferenceCountedOpenSslContext();
            if (referenceCountedOpenSslContext != null) {
                SslHandler sslHandler = referenceCountedOpenSslContext.newHandler(socketChannel.alloc());
                sslEngine = sslHandler.engine();
                Util.setSslHandshakeTimeOut(sslConfig, sslHandler);
                socketChannel.pipeline().addLast(new ChannelHandler[]{sslHandler});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new OCSPStaplingHandler((ReferenceCountedOpenSslEngine)sslEngine)});
            }
        } else {
            sslEngine = sslConfig.isDisableSsl() ? Util.createInsecureSslEngine(socketChannel, host, port, sslConfig.getSslContext()) : (sslConfig.getTrustStore() != null ? Util.instantiateAndConfigSSL(sslConfig, host, port) : Util.getSslEngineForCerts(socketChannel, host, port, sslConfig));
            SslHandler sslHandler = new SslHandler(sslEngine);
            Util.setSslHandshakeTimeOut(sslConfig, sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
            if (sslConfig.isValidateCertEnabled()) {
                pipeline.addLast("certificateValidation", (ChannelHandler)new CertificateValidationHandler(sslEngine, sslConfig.getCacheValidityPeriod(), sslConfig.getCacheSize()));
            }
        }
        return sslEngine;
    }

    private static SSLEngine getSslEngineForCerts(SocketChannel socketChannel, String host, int port, SSLConfig sslConfig) {
        SSLHandlerFactory sslHandlerFactory = sslConfig.getSslHandlerFactory();
        SslContext sslContext = sslConfig.getSslContext();
        SslHandler sslHandler = sslContext.newHandler(socketChannel.alloc(), host, port);
        SSLEngine sslEngine = sslHandler.engine();
        sslHandlerFactory.addCommonConfigs(sslEngine);
        sslHandlerFactory.setSNIServerNames(sslEngine, host);
        if (sslConfig.isHostNameVerificationEnabled()) {
            Util.setHostNameVerfication(sslEngine);
        }
        return sslEngine;
    }

    private static SSLEngine createInsecureSslEngine(SocketChannel socketChannel, String host, int port, SslContext sslContext) {
        SslHandler sslHandler = sslContext.newHandler(socketChannel.alloc(), host, port);
        return sslHandler.engine();
    }

    public static SslContext createInsecureSslEngineForHttp2() throws SSLException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(InsecureTrustManagerFactory.INSTANCE);
        sslContextBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
        return sslContextBuilder.build();
    }

    private static SSLEngine instantiateAndConfigSSL(SSLConfig sslConfig, String host, int port) {
        SSLHandlerFactory sslHandlerFactory = sslConfig.getSslHandlerFactory();
        boolean hostNameVerificationEnabled = sslConfig.isHostNameVerificationEnabled();
        SSLEngine sslEngine = sslHandlerFactory.buildClientSSLEngine(host, port);
        sslEngine.setUseClientMode(true);
        sslHandlerFactory.setSNIServerNames(sslEngine, host);
        if (hostNameVerificationEnabled) {
            sslHandlerFactory.setHostNameVerfication(sslEngine);
        }
        return sslEngine;
    }

    public static int getIntProperty(Map<String, Object> properties, String key, int defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof Integer)) {
            throw new IllegalArgumentException("Property : " + key + " must be an integer");
        }
        return (Integer)propertyVal;
    }

    public static String getStringProperty(Map<String, Object> properties, String key, String defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof String)) {
            throw new IllegalArgumentException("Property : " + key + " must be a string");
        }
        return (String)propertyVal;
    }

    public static Boolean getBooleanProperty(Map<String, Object> properties, String key, boolean defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof Boolean)) {
            throw new IllegalArgumentException("Property : " + key + " must be a boolean");
        }
        return (Boolean)propertyVal;
    }

    public static Long getLongProperty(Map<String, Object> properties, String key, long defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        Object propertyVal = properties.get(key);
        if (propertyVal == null) {
            return defaultVal;
        }
        if (!(propertyVal instanceof Long)) {
            throw new IllegalArgumentException("Property : " + key + " must be a long");
        }
        return (Long)propertyVal;
    }

    public static String substituteVariables(String value) {
        Matcher matcher = varPattern.matcher(value);
        boolean found = matcher.find();
        if (!found) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String sysPropKey;
            String sysPropValue;
            if ((sysPropValue = Util.getSystemVariableValue(sysPropKey = matcher.group(1), null)) == null || sysPropValue.length() == 0) {
                throw new RuntimeException("System property " + sysPropKey + " is not specified");
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            matcher.appendReplacement(sb, sysPropValue);
        } while (matcher.find());
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getSystemVariableValue(String variableName, String defaultValue) {
        String value = System.getProperty(variableName) != null ? System.getProperty(variableName) : (System.getenv(variableName) != null ? System.getenv(variableName) : defaultValue);
        return value;
    }

    public static String createServerConnectorID(String host, int port) {
        return host + ":" + port;
    }

    public static void resetChannelAttributes(ChannelHandlerContext ctx) {
        ctx.channel().attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).set(null);
        ctx.channel().attr(Constants.ORIGINAL_REQUEST).set(null);
        ctx.channel().attr(Constants.REDIRECT_COUNT).set(null);
        ctx.channel().attr(Constants.RESOLVED_REQUESTED_URI_ATTR).set(null);
        ctx.channel().attr(Constants.ORIGINAL_CHANNEL_START_TIME).set(null);
        ctx.channel().attr(Constants.ORIGINAL_CHANNEL_TIMEOUT).set(null);
    }

    public static boolean isLastHttpContent(HttpContent httpContent) {
        return httpContent instanceof LastHttpContent;
    }

    public static void sendAndCloseNoEntityBodyResp(ChannelHandlerContext ctx, HttpResponseStatus status, HttpVersion httpVersion, String serverName) {
        DefaultHttpResponse outboundResponse = new DefaultHttpResponse(httpVersion, status);
        outboundResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        outboundResponse.headers().set(HttpHeaderNames.CONNECTION.toString(), (Object)"close");
        outboundResponse.headers().set(HttpHeaderNames.SERVER.toString(), (Object)serverName);
        ChannelFuture outboundRespFuture = ctx.channel().writeAndFlush((Object)outboundResponse);
        outboundRespFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> LOG.warn("Failed to send {}", (Object)status.reasonPhrase())));
        ctx.channel().close();
    }

    public static void checkForResponseWriteStatus(HttpCarbonMessage inboundRequestMsg, HttpResponseFuture outboundRespStatusFuture, ChannelFuture channelFuture) {
        channelFuture.addListener(writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Remote client closed the connection while writing outbound response headers");
                }
                outboundRespStatusFuture.notifyHttpListener(throwable);
            } else {
                outboundRespStatusFuture.notifyHttpListener(inboundRequestMsg);
            }
        });
    }

    public static void addResponseWriteFailureListener(HttpResponseFuture outboundRespStatusFuture, ChannelFuture channelFuture, Http2OutboundRespListener http2OutboundRespListener) {
        channelFuture.addListener(writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Remote client closed the connection while writing outbound response headers");
                }
                if (http2OutboundRespListener.getOutboundResponseMsg() != null) {
                    http2OutboundRespListener.getOutboundResponseMsg().setIoException(new IOException("Remote client closed the connection while writing outbound response headers"));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove response writer and backpressure listener in case of failure");
                }
                http2OutboundRespListener.removeBackPressureListener();
                http2OutboundRespListener.removeDefaultResponseWriter();
                outboundRespStatusFuture.notifyHttpListener(throwable);
            }
        });
    }

    public static HttpCarbonMessage createHTTPCarbonMessage(HttpMessage httpMessage, ChannelHandlerContext ctx) {
        DefaultListener contentListener = new DefaultListener(ctx);
        return new HttpCarbonMessage(httpMessage, contentListener);
    }

    public static void safelyRemoveHandlers(ChannelPipeline pipeline, String ... handlerNames) {
        for (String name : handlerNames) {
            if (pipeline.get(name) != null) {
                pipeline.remove(name);
                continue;
            }
            LOG.debug("Trying to remove not engaged {} handler from the pipeline", (Object)name);
        }
    }

    public static HttpCarbonMessage createInboundReqCarbonMsg(HttpRequest httpRequestHeaders, ChannelHandlerContext ctx, SourceHandler sourceHandler) {
        HttpCarbonRequest inboundRequestMsg = new HttpCarbonRequest(httpRequestHeaders, (Listener)new DefaultListener(ctx));
        inboundRequestMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", new PooledDataStreamerFactory(ctx.alloc()));
        inboundRequestMsg.setProperty("CHNL_HNDLR_CTX", ctx);
        inboundRequestMsg.setProperty("SRC_HANDLER", (Object)sourceHandler);
        HttpVersion protocolVersion = httpRequestHeaders.protocolVersion();
        inboundRequestMsg.setHttpVersion(protocolVersion.majorVersion() + "." + protocolVersion.minorVersion());
        inboundRequestMsg.setHttpMethod(httpRequestHeaders.method().name());
        InetSocketAddress localAddress = null;
        if (ctx.channel().localAddress() instanceof InetSocketAddress) {
            localAddress = (InetSocketAddress)ctx.channel().localAddress();
        }
        inboundRequestMsg.setProperty("LISTENER_PORT", localAddress != null ? Integer.valueOf(localAddress.getPort()) : null);
        inboundRequestMsg.setProperty("listener.interface.id", sourceHandler.getInterfaceId());
        inboundRequestMsg.setProperty("PROTOCOL", "http");
        boolean isSecuredConnection = false;
        if (ctx.channel().pipeline().get("ssl") != null) {
            isSecuredConnection = true;
        }
        inboundRequestMsg.setProperty("IS_SECURED_CONNECTION", isSecuredConnection);
        inboundRequestMsg.setProperty("LOCAL_ADDRESS", ctx.channel().localAddress());
        inboundRequestMsg.setProperty("REMOTE_ADDRESS", sourceHandler.getRemoteAddress());
        inboundRequestMsg.setRequestUrl(httpRequestHeaders.uri());
        inboundRequestMsg.setProperty("TO", httpRequestHeaders.uri());
        inboundRequestMsg.setProperty("MUTUAL_SSL_HANDSHAKE_RESULT", ctx.channel().attr(Constants.MUTUAL_SSL_RESULT_ATTRIBUTE).get());
        inboundRequestMsg.setProperty("BASE_64_ENCODED_CERT", ctx.channel().attr(Constants.BASE_64_ENCODED_CERT_ATTRIBUTE).get());
        return inboundRequestMsg;
    }

    public static HttpCarbonMessage createInboundRespCarbonMsg(ChannelHandlerContext ctx, HttpResponse httpResponseHeaders, HttpCarbonMessage outboundRequestMsg) {
        HttpCarbonResponse inboundResponseMsg = new HttpCarbonResponse(httpResponseHeaders, (Listener)new DefaultListener(ctx));
        inboundResponseMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", new PooledDataStreamerFactory(ctx.alloc()));
        inboundResponseMsg.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        inboundResponseMsg.setHttpStatusCode(httpResponseHeaders.status().code());
        inboundResponseMsg.setProperty("executor.workerpool", outboundRequestMsg.getProperty("executor.workerpool"));
        return inboundResponseMsg;
    }

    public static boolean isKeepAlive(KeepAliveConfig keepAliveConfig, HttpCarbonMessage outboundRequestMsg) throws ConfigurationException {
        switch (keepAliveConfig) {
            case AUTO: {
                return Float.valueOf(outboundRequestMsg.getHttpVersion()).floatValue() > 1.0f;
            }
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        throw new ConfigurationException("Invalid keep-alive configuration value : " + keepAliveConfig.toString());
    }

    public static boolean is100ContinueRequest(HttpCarbonMessage inboundRequestMsg) {
        return "100-continue".equalsIgnoreCase(inboundRequestMsg.getHeader(HttpHeaderNames.EXPECT.toString()));
    }

    public static boolean isKeepAliveConnection(KeepAliveConfig keepAliveConfig, String requestConnectionHeader, String httpVersion) {
        if (keepAliveConfig == null || keepAliveConfig == KeepAliveConfig.AUTO) {
            if (Float.valueOf(httpVersion).floatValue() <= 1.0f) {
                return requestConnectionHeader != null && requestConnectionHeader.equalsIgnoreCase("keep-alive");
            }
            return requestConnectionHeader == null || !requestConnectionHeader.equalsIgnoreCase("close");
        }
        return keepAliveConfig == KeepAliveConfig.ALWAYS;
    }

    public static void setHostNameVerfication(SSLEngine sslEngine) {
        SSLParameters sslParams = sslEngine.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("https");
        sslEngine.setSSLParameters(sslParams);
    }

    public static BackPressureHandler getBackPressureHandler(ChannelHandlerContext channelContext) {
        return (BackPressureHandler)channelContext.pipeline().get("BackPressureHandler");
    }

    public static void setBackPressureListener(HttpCarbonMessage outboundMessage, BackPressureHandler backpressureHandler, ChannelHandlerContext ctx) {
        if (backpressureHandler != null) {
            if (outboundMessage.isPassthrough()) {
                Util.setPassthroughBackOffListener(outboundMessage, backpressureHandler, ctx);
            } else {
                backpressureHandler.getBackPressureObservable().setListener(new DefaultBackPressureListener());
            }
        }
    }

    private static void setPassthroughBackOffListener(HttpCarbonMessage outboundMessage, BackPressureHandler backpressureHandler, ChannelHandlerContext ctx) {
        Listener inboundListener = outboundMessage.getListener();
        if (inboundListener instanceof Http2InboundContentListener) {
            backpressureHandler.getBackPressureObservable().setListener(new Http2PassthroughBackPressureListener((Http2InboundContentListener)inboundListener));
        } else if (inboundListener instanceof DefaultListener && ctx != null) {
            backpressureHandler.getBackPressureObservable().setListener(new PassthroughBackPressureListener(ctx));
        }
    }

    public static void checkUnWritabilityAndNotify(ChannelHandlerContext context, BackPressureHandler backpressureHandler) {
        Channel channel;
        if (backpressureHandler != null && !(channel = context.channel()).isWritable() && channel.isActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/1.1 channel is not writable in thread {} ", (Object)Thread.currentThread().getName());
            }
            backpressureHandler.getBackPressureObservable().notifyUnWritable();
        }
    }

    public static void setSslHandshakeTimeOut(SSLConfig sslConfig, SslHandler sslHandler) {
        long handshakeTimeout = sslConfig.getHandshakeTimeOut();
        if (handshakeTimeout > 0L) {
            sslHandler.setHandshakeTimeout(handshakeTimeout, TimeUnit.SECONDS);
        }
    }

    public static long ticksInNanos() {
        return System.nanoTime();
    }

    public static ScheduledFuture<?> schedule(ChannelHandlerContext ctx, Runnable task, long delay) {
        return ctx.executor().schedule(task, delay, TimeUnit.NANOSECONDS);
    }

    public static void setCorrelationIdForLogging(ChannelPipeline pipeline, ChannelInboundHandlerAdapter srcHandler) {
        if (srcHandler != null && pipeline.get("http-trace-logger") != null) {
            HttpTraceLoggingHandler loggingHandler = (HttpTraceLoggingHandler)pipeline.get("http-trace-logger");
            if (srcHandler instanceof SourceHandler) {
                SourceHandler h1SourceHandler = (SourceHandler)srcHandler;
                loggingHandler.setCorrelatedSourceId(h1SourceHandler.getInboundChannelContext().channel().id().asShortText());
            } else if (srcHandler instanceof Http2SourceHandler) {
                Http2SourceHandler h2SourceHandler = (Http2SourceHandler)srcHandler;
                loggingHandler.setCorrelatedSourceId(h2SourceHandler.getInboundChannelContext().channel().id().asShortText());
            }
        }
    }

    public static void handleOutboundConnectionHeader(SenderConfiguration senderConfiguration, HttpCarbonMessage httpOutboundRequest) {
        switch (senderConfiguration.getKeepAliveConfig()) {
            case AUTO: {
                if (Float.valueOf(senderConfiguration.getHttpVersion()).floatValue() >= 1.1f) {
                    httpOutboundRequest.setHeader(HttpHeaderNames.CONNECTION.toString(), "keep-alive");
                    break;
                }
                httpOutboundRequest.setHeader(HttpHeaderNames.CONNECTION.toString(), "close");
                break;
            }
            case ALWAYS: {
                httpOutboundRequest.setHeader(HttpHeaderNames.CONNECTION.toString(), "keep-alive");
                break;
            }
            case NEVER: {
                httpOutboundRequest.setHeader(HttpHeaderNames.CONNECTION.toString(), "close");
                break;
            }
        }
        ProxyServerConfiguration proxyConfig = senderConfiguration.getProxyServerConfiguration();
        if (senderConfiguration.getScheme().equals("http") && proxyConfig != null && proxyConfig.getProxyUsername() != null && proxyConfig.getProxyPassword() != null) {
            Util.setProxyAuthorizationHeader(proxyConfig, httpOutboundRequest);
        }
    }

    private static void setProxyAuthorizationHeader(ProxyServerConfiguration proxyConfig, HttpCarbonMessage httpOutboundRequest) {
        ByteBuf authz = Unpooled.copiedBuffer((CharSequence)(proxyConfig.getProxyUsername() + ":" + proxyConfig.getProxyPassword()), (Charset)CharsetUtil.UTF_8);
        ByteBuf authzBase64 = Base64.encode((ByteBuf)authz, (boolean)false);
        AsciiString authorization = new AsciiString((CharSequence)("Basic " + authzBase64.toString(CharsetUtil.US_ASCII)));
        httpOutboundRequest.setHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString(), authorization);
        authz.release();
        authzBase64.release();
    }

    public static void setForwardedExtension(ForwardedExtensionConfig forwardedConfig, String localAddress, HttpCarbonMessage httpOutboundRequest) {
        if (forwardedConfig == ForwardedExtensionConfig.DISABLE) {
            return;
        }
        ForwardedHeaderUpdater headerUpdater = new ForwardedHeaderUpdater(httpOutboundRequest, localAddress);
        if (headerUpdater.isForwardedHeaderRequired()) {
            headerUpdater.setForwardedHeader();
            return;
        }
        if (headerUpdater.isXForwardedHeaderRequired()) {
            if (forwardedConfig == ForwardedExtensionConfig.ENABLE) {
                headerUpdater.setDefactoForwardedHeaders();
                return;
            }
            headerUpdater.transformAndSetForwardedHeader();
            return;
        }
        LOG.warn("Both Forwarded and X-Forwarded-- headers are present. Hence updating only the forwarded header");
        headerUpdater.setForwardedHeader();
    }

    public static void setMutualSslStatus(ChannelHandlerContext ctx, SSLEngine sslEngine) {
        if (sslEngine.getWantClientAuth() || sslEngine.getNeedClientAuth()) {
            try {
                Certificate[] certs = sslEngine.getSession().getPeerCertificates();
                X509Certificate endUserCert = (X509Certificate)certs[0];
                endUserCert.checkValidity(new Date());
                String base64EncodedCert = java.util.Base64.getEncoder().encodeToString(endUserCert.getEncoded());
                ctx.channel().attr(Constants.MUTUAL_SSL_RESULT_ATTRIBUTE).set((Object)"passed");
                ctx.channel().attr(Constants.BASE_64_ENCODED_CERT_ATTRIBUTE).set((Object)base64EncodedCert);
            }
            catch (CertificateEncodingException | CertificateExpiredException | CertificateNotYetValidException | SSLPeerUnverifiedException e) {
                ctx.channel().attr(Constants.MUTUAL_SSL_RESULT_ATTRIBUTE).set((Object)"failed");
            }
        } else {
            ctx.channel().attr(Constants.MUTUAL_SSL_RESULT_ATTRIBUTE).set((Object)"disabled");
        }
    }

    public static void handleIncompleteMsgOnReset(Http2Reset http2Reset, int streamId, HttpCarbonMessage message) {
        if (message != null) {
            DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
            lastHttpContent.setDecoderResult(DecoderResult.failure((Throwable)new DecoderException("HTTP/2 stream " + streamId + " reset by the remote peer")));
            message.addHttpContent((HttpContent)lastHttpContent);
            message.setProperty("Http2Error", http2Reset.getError());
        }
    }
}

