/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.FunctionDeploymentContext;

public class FunctionsArtifact {
    private static final String HOST_JSON_NAME = "host.json";
    private static final String FUNCTION_JSON_NAME = "function.json";
    private Map<String, FunctionDeploymentContext> functions;
    private Path binaryPath;
    private JsonObject hostJson;
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public FunctionsArtifact(Map<String, FunctionDeploymentContext> functions, Path binaryPath) throws AzureFunctionsException {
        this.functions = functions;
        this.binaryPath = binaryPath;
        this.generateHostJson();
    }

    public Map<String, FunctionDeploymentContext> getFunctions() {
        return this.functions;
    }

    public Path getBinaryPath() {
        return this.binaryPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject readExistingHostJson() throws AzureFunctionsException {
        File file = new File(HOST_JSON_NAME);
        if (!file.exists()) return null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse((Reader)reader).getAsJsonObject();
            return jsonObject;
        }
        catch (JsonParseException | IOException e) {
            throw new AzureFunctionsException("Error in reading host.json: " + e.getMessage());
        }
    }

    private void generateHostJson() throws AzureFunctionsException {
        this.hostJson = this.readExistingHostJson();
        if (this.hostJson == null) {
            this.hostJson = new JsonObject();
        }
        this.hostJson.add("version", (JsonElement)new JsonPrimitive("2.0"));
        JsonObject httpWorker = new JsonObject();
        this.hostJson.add("customHandler", (JsonElement)httpWorker);
        JsonObject httpWorkerDesc = new JsonObject();
        httpWorker.add("description", (JsonElement)httpWorkerDesc);
        httpWorkerDesc.add("defaultExecutablePath", (JsonElement)new JsonPrimitive("java"));
        httpWorkerDesc.add("defaultWorkerPath", (JsonElement)new JsonPrimitive(this.binaryPath.getFileName().toString()));
        JsonArray workerArgs = new JsonArray();
        workerArgs.add("-jar");
        httpWorkerDesc.add("arguments", (JsonElement)workerArgs);
        httpWorker.add("enableForwardingHttpRequest", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        JsonObject extensionBundle = new JsonObject();
        this.hostJson.add("extensionBundle", (JsonElement)extensionBundle);
        extensionBundle.add("id", (JsonElement)new JsonPrimitive("Microsoft.Azure.Functions.ExtensionBundle"));
        extensionBundle.add("version", (JsonElement)new JsonPrimitive("[1.*, 2.0.0)"));
    }

    private InputStream jtos(JsonElement element) {
        try {
            return new ByteArrayInputStream(this.gson.toJson(element).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void generate(String outputFileName) throws IOException {
        Files.deleteIfExists(Paths.get(outputFileName, new String[0]));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:file:" + this.binaryPath.toAbsolutePath().getParent().resolve(outputFileName).toUri().getPath());
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            Files.copy(this.binaryPath, zipfs.getPath("/" + this.binaryPath.getFileName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(this.jtos((JsonElement)this.hostJson), zipfs.getPath("/host.json", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            for (Map.Entry<String, FunctionDeploymentContext> entry : this.functions.entrySet()) {
                Path functionDir = zipfs.getPath("/" + entry.getKey(), new String[0]);
                Files.createDirectory(functionDir, new FileAttribute[0]);
                Files.copy(this.jtos((JsonElement)entry.getValue().functionDefinition), functionDir.resolve(FUNCTION_JSON_NAME), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

