/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions;

import java.util.List;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.FunctionDeploymentContext;
import org.ballerinax.azurefunctions.ParameterHandler;
import org.ballerinax.azurefunctions.ReturnHandler;
import org.ballerinax.azurefunctions.Utils;
import org.ballerinax.azurefunctions.handlers.blob.BlobInputParameterHandler;
import org.ballerinax.azurefunctions.handlers.blob.BlobOutputParameterHandler;
import org.ballerinax.azurefunctions.handlers.blob.BlobTriggerParameterHandler;
import org.ballerinax.azurefunctions.handlers.context.ContextParameterHandler;
import org.ballerinax.azurefunctions.handlers.cosmosdb.CosmosDBInputParameterHandler;
import org.ballerinax.azurefunctions.handlers.cosmosdb.CosmosDBReturnHandler;
import org.ballerinax.azurefunctions.handlers.cosmosdb.CosmosDBTriggerHandler;
import org.ballerinax.azurefunctions.handlers.http.HTTPOutputParameterHandler;
import org.ballerinax.azurefunctions.handlers.http.HTTPReturnHandler;
import org.ballerinax.azurefunctions.handlers.http.HTTPTriggerParameterHandler;
import org.ballerinax.azurefunctions.handlers.metadata.MetadataBindingParameterHandler;
import org.ballerinax.azurefunctions.handlers.queue.QueueOutputParameterHandler;
import org.ballerinax.azurefunctions.handlers.queue.QueueTriggerHandler;
import org.ballerinax.azurefunctions.handlers.timer.TimerTriggerHandler;
import org.ballerinax.azurefunctions.handlers.twilio.TwilioSmsOutputParameterHandler;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

public class HandlerFactory {
    public static ParameterHandler createParameterHandler(FunctionDeploymentContext ctx, BLangSimpleVariable param) throws AzureFunctionsException {
        if (Utils.isContextType(param.type)) {
            return new ContextParameterHandler(param);
        }
        BLangAnnotationAttachment ann = Utils.extractAzureFunctionAnnotation(param.getAnnotationAttachments());
        if (ann == null) {
            throw HandlerFactory.createParamError(ctx, param, "Invalid annotation or type");
        }
        String name = ann.getAnnotationName().getValue();
        if ("HTTPOutput".equals(name)) {
            return new HTTPOutputParameterHandler(param, ann);
        }
        if ("HTTPTrigger".equals(name)) {
            return new HTTPTriggerParameterHandler(param, ann);
        }
        if ("QueueOutput".equals(name)) {
            return new QueueOutputParameterHandler(param, ann);
        }
        if ("QueueTrigger".equals(name)) {
            return new QueueTriggerHandler(param, ann);
        }
        if ("TimerTrigger".equals(name)) {
            return new TimerTriggerHandler(param, ann);
        }
        if ("BlobTrigger".equals(name)) {
            return new BlobTriggerParameterHandler(param, ann);
        }
        if ("BlobInput".equals(name)) {
            return new BlobInputParameterHandler(param, ann);
        }
        if ("BlobOutput".equals(name)) {
            return new BlobOutputParameterHandler(param, ann);
        }
        if ("TwilioSmsOutput".equals(name)) {
            return new TwilioSmsOutputParameterHandler(param, ann);
        }
        if ("BindingName".equals(name)) {
            return new MetadataBindingParameterHandler(param, ann);
        }
        if ("CosmosDBTrigger".equals(name)) {
            return new CosmosDBTriggerHandler(param, ann);
        }
        if ("CosmosDBInput".equals(name)) {
            return new CosmosDBInputParameterHandler(param, ann);
        }
        throw HandlerFactory.createParamError(ctx, param, "Parameter handler not found");
    }

    public static ReturnHandler createReturnHandler(FunctionDeploymentContext ctx, BType retType, List<BLangAnnotationAttachment> annons) throws AzureFunctionsException {
        SymbolTable symTable = ctx.globalCtx.symTable;
        if (symTable.nilType.equals(retType) || symTable.noType.equals(retType)) {
            return null;
        }
        BLangAnnotationAttachment ann = Utils.extractAzureFunctionAnnotation(annons);
        if (ann == null) {
            throw HandlerFactory.createReturnError(ctx, "Invalid annotation");
        }
        String name = ann.getAnnotationName().getValue();
        if ("HTTPOutput".equals(name)) {
            return new HTTPReturnHandler(retType, ann);
        }
        if ("CosmosDBOutput".equals(name)) {
            return new CosmosDBReturnHandler(retType, ann);
        }
        throw HandlerFactory.createReturnError(ctx, "Return handler not found for the type: " + retType);
    }

    private static AzureFunctionsException createParamError(FunctionDeploymentContext ctx, BLangSimpleVariable param, String msg) {
        return new AzureFunctionsException("Error at function: '" + ctx.sourceFunction.name.value + "' parameter: '" + param.name.value + "' - " + msg);
    }

    private static AzureFunctionsException createReturnError(FunctionDeploymentContext ctx, String msg) {
        return new AzureFunctionsException("Error at function: '" + ctx.sourceFunction.name.value + " return - " + msg);
    }
}

