/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.TypeDefinition;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.ballerinax.azurefunctions.BindingType;
import org.ballerinax.azurefunctions.FunctionDeploymentContext;
import org.ballerinax.azurefunctions.GlobalContext;
import org.ballerinax.azurefunctions.ParameterHandler;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.Flags;

public class Utils {
    public static BLangFunction extractMainFunction(BLangPackage myPkg) {
        for (BLangFunction func : myPkg.getFunctions()) {
            if (!"main".equals(func.getName().value)) continue;
            return func;
        }
        return null;
    }

    public static boolean isAzureFuncsModule(PackageID pkgId) {
        return "ballerinax".equals(pkgId.orgName.value) && "azure.functions".equals(pkgId.name.value);
    }

    public static BPackageSymbol extractAzureFuncsPackageSymbol(BLangPackage myPkg) {
        for (BLangImportPackage pi : myPkg.imports) {
            if (!Utils.isAzureFuncsModule(pi.symbol.pkgID)) continue;
            return pi.symbol;
        }
        return null;
    }

    public static void addRegisterCall(GlobalContext ctx, DiagnosticPos pos, BPackageSymbol pkgSymbol, BLangBlockFunctionBody blockStmt, String name, BLangFunction func) {
        BLangInvocation inv = Utils.createInvocationNode(pkgSymbol, "__register", new BLangExpression[]{Utils.createStringLiteral(ctx, name), Utils.createVariableRef(ctx, (BVarSymbol)func.symbol)});
        BLangExpressionStmt stmt = new BLangExpressionStmt((BLangExpression)inv);
        stmt.pos = pos;
        blockStmt.addStatement((StatementNode)stmt);
    }

    public static BLangSimpleVariable addAzurePkgFunctionCall(FunctionDeploymentContext ctx, String name, boolean checked, BLangExpression ... exprs) {
        return Utils.addFunctionCall(ctx, Utils.createAzurePkgInvocationNode(ctx, name, exprs), checked);
    }

    public static BLangSimpleVariable addFunctionCall(FunctionDeploymentContext ctx, BSymbol funcSymbol, boolean checked, BLangExpression ... exprs) {
        return Utils.addFunctionCall(ctx, Utils.createInvocationNode(funcSymbol, exprs), checked);
    }

    public static BLangSimpleVariable addFunctionCall(FunctionDeploymentContext ctx, BPackageSymbol pkgSymbol, String name, boolean checked, BLangExpression ... exprs) {
        return Utils.addFunctionCall(ctx, Utils.createInvocationNode(pkgSymbol, name, exprs), checked);
    }

    public static BLangSimpleVariable addFunctionCall(FunctionDeploymentContext ctx, BLangInvocation inv, boolean checked) {
        Object expr = checked ? Utils.createCheckedExpr(ctx.globalCtx, (BLangExpression)inv) : inv;
        BLangSimpleVariableDef varDef = (BLangSimpleVariableDef)TreeBuilder.createSimpleVariableDefinitionNode();
        varDef.type = expr.type;
        varDef.var = Utils.createVariable(ctx.globalCtx, expr.type, ctx.getNextVarName(), (BSymbol)ctx.function.symbol);
        varDef.var.expr = expr;
        ((BLangBlockFunctionBody)ctx.function.body).addStatement((StatementNode)varDef);
        return varDef.var;
    }

    public static BLangExpressionStmt createExpressionStmt(GlobalContext ctx, BLangExpression expr) {
        BLangExpressionStmt stmt = new BLangExpressionStmt(expr);
        stmt.pos = ctx.pos;
        return stmt;
    }

    public static BLangLiteral createStringLiteral(GlobalContext ctx, String value) {
        BLangLiteral stringLit = new BLangLiteral();
        stringLit.pos = ctx.pos;
        stringLit.value = value;
        stringLit.type = ctx.symTable.stringType;
        return stringLit;
    }

    public static BLangLiteral createBooleanLiteral(GlobalContext ctx, boolean value) {
        BLangLiteral stringLit = new BLangLiteral();
        stringLit.pos = ctx.pos;
        stringLit.value = value;
        stringLit.type = ctx.symTable.booleanType;
        return stringLit;
    }

    public static BLangExpression createEmptyRecordLiteral(BType type) {
        BLangRecordLiteral recordLit = new BLangRecordLiteral();
        recordLit.type = type;
        return recordLit;
    }

    public static BLangSimpleVarRef createVariableRef(GlobalContext ctx, BVarSymbol varSymbol) {
        BLangSimpleVarRef varRef = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        varRef.pos = ctx.pos;
        varRef.variableName = ASTBuilderUtil.createIdentifier((DiagnosticPos)ctx.pos, (String)varSymbol.name.value);
        varRef.symbol = varSymbol;
        varRef.type = varSymbol.type;
        return varRef;
    }

    public static BLangTypedescExpr createTypeDescExpr(GlobalContext ctx, BType type) {
        BLangTypedescExpr typeDescExpr = new BLangTypedescExpr();
        typeDescExpr.pos = ctx.pos;
        typeDescExpr.type = ctx.symTable.typeDesc;
        typeDescExpr.resolvedType = type;
        typeDescExpr.expectedType = ctx.symTable.typeDesc;
        return typeDescExpr;
    }

    public static BLangSimpleVariable createVariable(GlobalContext ctx, BType type, String name, BSymbol owner) {
        BLangSimpleVariable var = (BLangSimpleVariable)TreeBuilder.createSimpleVariableNode();
        var.pos = ctx.pos;
        var.name = ASTBuilderUtil.createIdentifier((DiagnosticPos)ctx.pos, (String)name);
        var.type = type;
        var.symbol = new BVarSymbol(0, new Name(name), type.tsymbol.pkgID, type, owner);
        return var;
    }

    public static BLangSimpleVariable addJSONVarDef(FunctionDeploymentContext ctx, String name, BSymbol owner, BLangBlockFunctionBody body) {
        BLangSimpleVariableDef varDef = (BLangSimpleVariableDef)TreeBuilder.createSimpleVariableDefinitionNode();
        varDef.type = ctx.globalCtx.symTable.jsonType;
        varDef.var = Utils.createVariable(ctx.globalCtx, varDef.type, name, owner);
        varDef.var.expr = Utils.createEmptyRecordLiteral(ctx.globalCtx.symTable.mapJsonType);
        varDef.pos = ctx.globalCtx.pos;
        body.addStatement((StatementNode)varDef);
        return varDef.var;
    }

    public static boolean isAzurePkgType(FunctionDeploymentContext ctx, String azTypeName, BType targetType) {
        BType sourceType = Utils.lookupAzurePkgType(ctx, azTypeName);
        return sourceType.equals(targetType);
    }

    public static BType lookupAzurePkgType(FunctionDeploymentContext ctx, String type) {
        GlobalContext globalCtx = ctx.globalCtx;
        return globalCtx.azureFuncsPkgSymbol.scope.lookup((Name)new Name((String)type)).symbol.type;
    }

    public static BVarSymbol addAzurePkgRecordVarDef(FunctionDeploymentContext ctx, String type, String name) {
        GlobalContext globalCtx = ctx.globalCtx;
        BLangFunction func = ctx.function;
        BLangSimpleVariableDef varDef = (BLangSimpleVariableDef)TreeBuilder.createSimpleVariableDefinitionNode();
        varDef.type = Utils.lookupAzurePkgType(ctx, type);
        varDef.var = Utils.createVariable(globalCtx, varDef.type, name, (BSymbol)func.symbol);
        varDef.var.expr = Utils.createEmptyRecordLiteral(varDef.type);
        varDef.pos = globalCtx.pos;
        ((BLangBlockFunctionBody)func.getBody()).addStatement((StatementNode)varDef);
        return varDef.var.symbol;
    }

    public static BLangType createJsonTypeNode(GlobalContext ctx) {
        BLangValueType nillType = new BLangValueType(TypeKind.JSON);
        nillType.type = ctx.symTable.jsonType;
        return nillType;
    }

    public static BLangType createNillTypeNode(GlobalContext ctx) {
        BLangValueType nillType = new BLangValueType(TypeKind.NIL);
        nillType.type = ctx.symTable.nilType;
        return nillType;
    }

    public static BLangType createErrorNillTypeNode(GlobalContext ctx) {
        BLangValueType errorNillType = new BLangValueType(TypeKind.UNION);
        errorNillType.type = ctx.symTable.errorOrNilType;
        return errorNillType;
    }

    public static BLangInvocation createAzurePkgInvocationNode(FunctionDeploymentContext ctx, String functionName, BLangExpression ... args) {
        return Utils.createInvocationNode(ctx.globalCtx.azureFuncsPkgSymbol.scope.lookup((Name)new Name((String)functionName)).symbol, args);
    }

    public static BLangInvocation createInvocationNode(BPackageSymbol pkgSymbol, String functionName, BLangExpression ... args) {
        return Utils.createInvocationNode(pkgSymbol.scope.lookup((Name)new Name((String)functionName)).symbol, args);
    }

    public static BLangInvocation createInvocationNode(BSymbol funcSymbol, BLangExpression ... args) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(funcSymbol.name.value);
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.symbol = funcSymbol;
        invocationNode.type = funcSymbol.getType().getReturnType();
        invocationNode.requiredArgs = Arrays.asList(args);
        return invocationNode;
    }

    private static String generateHandlerFuncName(String baseName) {
        return baseName + "_" + "0dadec8e-7c9c-44c3-88ea-f947acc3add7";
    }

    public static BType extractRequestParamsType(GlobalContext ctx) {
        return ctx.azureFuncsPkgSymbol.scope.lookup((Name)new Name((String)"HandlerParams")).symbol.type;
    }

    public static BLangFunction createHandlerFunction(GlobalContext ctx, DiagnosticPos pos, String baseName, BLangPackage packageNode) {
        List<String> paramNames = Arrays.asList("params");
        List<BType> paramTypes = Arrays.asList(Utils.extractRequestParamsType(ctx));
        BLangType retType = Utils.createErrorNillTypeNode(ctx);
        BLangFunction handlerFunc = Utils.createFunction(ctx, Utils.generateHandlerFuncName(baseName), paramNames, paramTypes, retType, packageNode);
        return handlerFunc;
    }

    public static void addReturnStatement(GlobalContext ctx, DiagnosticPos pos, BVarSymbol var, BLangBlockFunctionBody body) {
        BLangReturn ret = new BLangReturn();
        ret.pos = pos;
        ret.type = var.type;
        ret.expr = Utils.createVariableRef(ctx, var);
        body.addStatement((StatementNode)ret);
    }

    public static BLangFunction createFunction(GlobalContext ctx, String name, BLangPackage packageNode) {
        return Utils.createFunction(ctx, name, new ArrayList<String>(), new ArrayList<BType>(), Utils.createNillTypeNode(ctx), packageNode);
    }

    public static BLangFunction createFunction(GlobalContext ctx, String name, List<String> paramNames, List<BType> paramTypes, BLangType retType, BLangPackage packageNode) {
        BLangFunction bLangFunction = (BLangFunction)TreeBuilder.createFunctionNode();
        BLangIdentifier funcName = ASTBuilderUtil.createIdentifier((DiagnosticPos)ctx.pos, (String)name);
        bLangFunction.setName((IdentifierNode)funcName);
        bLangFunction.flagSet = EnumSet.of(Flag.PUBLIC);
        bLangFunction.pos = ctx.pos;
        bLangFunction.type = new BInvokableType(paramTypes, retType.type, null);
        bLangFunction.body = Utils.createBlockStmt(ctx.pos);
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol((int)Flags.asMask((Set)bLangFunction.flagSet), (Name)new Name(bLangFunction.name.value), (PackageID)packageNode.packageID, (BType)bLangFunction.type, (BSymbol)packageNode.symbol, (boolean)true);
        functionSymbol.type = bLangFunction.type;
        functionSymbol.retType = retType.type;
        functionSymbol.scope = new Scope((BSymbol)functionSymbol);
        bLangFunction.symbol = functionSymbol;
        for (int i = 0; i < paramNames.size(); ++i) {
            BLangSimpleVariable var = Utils.createVariable(ctx, paramTypes.get(i), paramNames.get(i), (BSymbol)bLangFunction.symbol);
            bLangFunction.addParameter((SimpleVariableNode)var);
            functionSymbol.params.add(var.symbol);
        }
        bLangFunction.setReturnTypeNode((TypeNode)retType);
        return bLangFunction;
    }

    public static BLangFunctionBody createBlockStmt(DiagnosticPos pos) {
        BLangFunctionBody blockNode = (BLangFunctionBody)TreeBuilder.createBlockFunctionBodyNode();
        blockNode.pos = pos;
        return blockNode;
    }

    public static boolean hasAzureFunctionsAnnotation(AnnotationAttachmentNode attachmentNode) {
        BAnnotationSymbol symbol = ((BLangAnnotationAttachment)attachmentNode).annotationSymbol;
        return "ballerinax".equals(symbol.pkgID.orgName.value) && "azure.functions".equals(symbol.pkgID.name.value) && "Function".equals(symbol.name.value);
    }

    public static boolean isAzureFunction(BLangFunction fn, DiagnosticLog dlog) {
        AnnotationAttachmentNode attachmentNode;
        List annotations = fn.annAttachments;
        boolean hasAzureFuncsAnnon = false;
        Iterator iterator = annotations.iterator();
        while (iterator.hasNext() && !(hasAzureFuncsAnnon = Utils.hasAzureFunctionsAnnotation(attachmentNode = (AnnotationAttachmentNode)iterator.next()))) {
        }
        return hasAzureFuncsAnnon;
    }

    public static BLangAnnotationAttachment extractAzureFunctionAnnotation(List<BLangAnnotationAttachment> annons) {
        for (AnnotationAttachmentNode annotationAttachmentNode : annons) {
            BLangAnnotationAttachment ban = (BLangAnnotationAttachment)annotationAttachmentNode;
            if (!Utils.isAzureFuncsModule(ban.annotationSymbol.pkgID)) continue;
            return ban;
        }
        return null;
    }

    public static boolean isErrorType(GlobalContext ctx, BType type) {
        return ctx.symTable.errorType.tsymbol.name.getValue().equals(type.tsymbol.name.getValue());
    }

    public static BType extractNonErrorType(GlobalContext ctx, BType type) {
        if (type instanceof BUnionType) {
            BUnionType uType = (BUnionType)type;
            LinkedHashSet<BType> newTypes = new LinkedHashSet<BType>();
            for (BType mt : uType.getMemberTypes()) {
                if (Utils.isErrorType(ctx, mt)) continue;
                newTypes.add(mt);
            }
            type = newTypes.size() == 1 ? (BType)newTypes.iterator().next() : BUnionType.create((BTypeSymbol)uType.tsymbol, newTypes);
        }
        return type;
    }

    public static BLangExpression createCheckedExpr(GlobalContext ctx, BLangExpression subexpr) {
        BLangCheckedExpr expr = new BLangCheckedExpr();
        expr.expr = subexpr;
        expr.type = Utils.extractNonErrorType(ctx, subexpr.type);
        expr.equivalentErrorTypeList = new ArrayList();
        return expr;
    }

    public static boolean isSingleOutputBinding(FunctionDeploymentContext ctx) {
        return Utils.getOutputBindingCount(ctx) == 1;
    }

    public static int getOutputBindingCount(FunctionDeploymentContext ctx) {
        int count = 0;
        for (ParameterHandler ph : ctx.parameterHandlers) {
            if (ph.getBindingType() != BindingType.OUTPUT) continue;
            ++count;
        }
        return count;
    }

    public static int getFunctionTriggerCount(FunctionDeploymentContext ctx) {
        int count = 0;
        for (ParameterHandler ph : ctx.parameterHandlers) {
            if (ph.getBindingType() != BindingType.TRIGGER) continue;
            ++count;
        }
        return count;
    }

    public static boolean isContextType(BType type) {
        String name = type.tsymbol.name.value;
        PackageID pkgId = type.tsymbol.pkgID;
        return "Context".equals(name) && Utils.isAzureFuncsModule(pkgId);
    }

    public static boolean isStringType(GlobalContext ctx, BType type) {
        return ctx.symTable.stringType.equals(type);
    }

    public static boolean isJsonType(GlobalContext ctx, BType type) {
        return ctx.symTable.jsonType.equals(type);
    }

    public static boolean isRecordType(GlobalContext ctx, BType type) {
        return type.tag == ctx.symTable.recordType.tag;
    }

    public static boolean isOptionalRecordType(GlobalContext ctx, BType type) {
        if (!(type instanceof BUnionType)) {
            return false;
        }
        BUnionType unionType = (BUnionType)type;
        ArrayList memberTypes = new ArrayList(unionType.getMemberTypes());
        if (memberTypes.size() != 2) {
            return false;
        }
        return Utils.isRecordType(ctx, (BType)memberTypes.get(0)) && ctx.symTable.nilType.equals(memberTypes.get(1)) || Utils.isRecordType(ctx, (BType)memberTypes.get(1)) && ctx.symTable.nilType.equals(memberTypes.get(0));
    }

    public static boolean isRecordArrayType(GlobalContext ctx, BType type) {
        if (!(type instanceof BArrayType)) {
            return false;
        }
        BArrayType arrayType = (BArrayType)type;
        return Utils.isRecordType(ctx, arrayType.eType);
    }

    public static boolean isByteArray(GlobalContext ctx, BType type) {
        if (type instanceof BArrayType) {
            BArrayType baType = (BArrayType)type;
            return ctx.symTable.byteType.equals(baType.eType);
        }
        return false;
    }

    public static boolean isOptionalByteArray(GlobalContext ctx, BType type) {
        if (!(type instanceof BUnionType)) {
            return false;
        }
        BUnionType unionType = (BUnionType)type;
        ArrayList memberTypes = new ArrayList(unionType.getMemberTypes());
        if (memberTypes.size() != 2) {
            return false;
        }
        return Utils.isByteArray(ctx, (BType)memberTypes.get(0)) && ctx.symTable.nilType.equals(memberTypes.get(1)) || Utils.isByteArray(ctx, (BType)memberTypes.get(1)) && ctx.symTable.nilType.equals(memberTypes.get(0));
    }

    public static boolean isOptionalString(GlobalContext ctx, BType type) {
        if (!(type instanceof BUnionType)) {
            return false;
        }
        BUnionType unionType = (BUnionType)type;
        ArrayList memberTypes = new ArrayList(unionType.getMemberTypes());
        if (memberTypes.size() != 2) {
            return false;
        }
        return Utils.isStringType(ctx, (BType)memberTypes.get(0)) && ctx.symTable.nilType.equals(memberTypes.get(1)) || Utils.isStringType(ctx, (BType)memberTypes.get(1)) && ctx.symTable.nilType.equals(memberTypes.get(0));
    }

    public static JsonElement objectToJson(Object obj) {
        if (obj instanceof String) {
            return new JsonPrimitive((String)obj);
        }
        if (obj instanceof Number) {
            return new JsonPrimitive((Number)obj);
        }
        if (obj instanceof Boolean) {
            return new JsonPrimitive((Boolean)obj);
        }
        if (obj instanceof String[]) {
            JsonArray array = new JsonArray();
            for (String item : (String[])obj) {
                array.add(item);
            }
            return array;
        }
        if (obj == null) {
            return JsonNull.INSTANCE;
        }
        throw new IllegalStateException("Unsupported type to convert to JSON: " + obj.getClass());
    }

    public static JsonObject createBindingObject(Map<String, Object> binding) {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, Object> entry : binding.entrySet()) {
            obj.add(entry.getKey(), Utils.objectToJson(entry.getValue()));
        }
        return obj;
    }

    public static void addFunctionBinding(FunctionDeploymentContext ctx, Map<String, Object> binding) {
        if (binding == null) {
            return;
        }
        JsonArray bindings = (JsonArray)ctx.functionDefinition.get("bindings");
        bindings.add((JsonElement)Utils.createBindingObject(binding));
    }

    public static Map<String, Object> extractAnnotationKeyValues(BLangAnnotationAttachment annotation) {
        BLangRecordLiteral record = (BLangRecordLiteral)annotation.expr;
        List fields = record.getFields().stream().map(x -> (BLangRecordLiteral.BLangRecordKeyValueField)x).collect(Collectors.toList());
        HashMap<String, Object> annonMap = new HashMap<String, Object>();
        for (BLangRecordLiteral.BLangRecordKeyValueField field : fields) {
            annonMap.put(field.key.toString(), ((BLangLiteral)field.getValue()).getValue());
        }
        return annonMap;
    }

    public static void addDummyService(GlobalContext ctx, BLangPackage packageNode) {
        String name = "249b70ab-c5b5-4758-9d50-193f9dbb6eb6";
        BLangTypeDefinition typeDef = (BLangTypeDefinition)TreeBuilder.createTypeDefinition();
        BLangIdentifier serviceTypeID = ASTBuilderUtil.createIdentifier((DiagnosticPos)ctx.pos, (String)name);
        typeDef.setName((IdentifierNode)serviceTypeID);
        typeDef.flagSet.add(Flag.SERVICE);
        typeDef.pos = ctx.pos;
        BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)TreeBuilder.createObjectTypeNode();
        objectTypeNode.generatedInitFunction = (BLangFunction)TreeBuilder.createFunctionNode();
        objectTypeNode.generatedInitFunction.symbol = new BInvokableSymbol(820, 0, new Name(name), packageNode.symbol.pkgID, (BType)new BInvokableType(new ArrayList(), ctx.symTable.noType, ctx.symTable.noType, null), (BSymbol)packageNode.symbol);
        typeDef.setTypeNode((TypeNode)objectTypeNode);
        BObjectTypeSymbol ts = new BObjectTypeSymbol(132, 0, new Name(name), packageNode.symbol.pkgID, null, (BSymbol)packageNode.symbol);
        BServiceType objectType = new BServiceType((BTypeSymbol)ts);
        ts.type = objectType;
        objectTypeNode.symbol = ts;
        objectTypeNode.type = objectType;
        objectTypeNode.pos = ctx.pos;
        typeDef.symbol = ts;
        packageNode.addTypeDefinition((TypeDefinition)typeDef);
    }
}

