/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions.handlers.cosmosdb;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.BindingType;
import org.ballerinax.azurefunctions.Utils;
import org.ballerinax.azurefunctions.handlers.AbstractParameterHandler;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class CosmosDBTriggerHandler
extends AbstractParameterHandler {
    public CosmosDBTriggerHandler(BLangSimpleVariable param, BLangAnnotationAttachment annotation) {
        super(param, annotation, BindingType.TRIGGER);
    }

    @Override
    public BLangExpression invocationProcess() throws AzureFunctionsException {
        if (Utils.isJsonType(this.ctx.globalCtx, this.param.type)) {
            return Utils.createAzurePkgInvocationNode(this.ctx, "getJsonFromInputData", new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name)});
        }
        if (Utils.isRecordArrayType(this.ctx.globalCtx, this.param.type)) {
            return Utils.createAzurePkgInvocationNode(this.ctx, "getBallerinaValueFromInputData", new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name), Utils.createTypeDescExpr(this.ctx.globalCtx, this.param.type)});
        }
        throw this.createError("Type must be 'json' or a record array type");
    }

    @Override
    public void postInvocationProcess() throws AzureFunctionsException {
    }

    @Override
    public Map<String, Object> generateBinding() {
        LinkedHashMap<String, Object> binding = new LinkedHashMap<String, Object>();
        Map<String, Object> annonMap = Utils.extractAnnotationKeyValues(this.annotation);
        binding.put("type", "cosmosDBTrigger");
        binding.put("connectionStringSetting", annonMap.get("connectionStringSetting"));
        binding.put("databaseName", annonMap.get("databaseName"));
        binding.put("collectionName", annonMap.get("collectionName"));
        binding.put("leaseConnectionStringSetting", annonMap.get("leaseConnectionStringSetting"));
        binding.put("leaseDatabaseName", annonMap.get("leaseDatabaseName"));
        binding.put("leaseCollectionName", annonMap.get("leaseCollectionName"));
        Boolean createLeaseCollectionIfNotExists = (Boolean)annonMap.get("createLeaseCollectionIfNotExists");
        if (createLeaseCollectionIfNotExists == null) {
            createLeaseCollectionIfNotExists = true;
        }
        binding.put("createLeaseCollectionIfNotExists", createLeaseCollectionIfNotExists);
        binding.put("leasesCollectionThroughput", annonMap.get("leasesCollectionThroughput"));
        binding.put("leaseCollectionPrefix", annonMap.get("leaseCollectionPrefix"));
        binding.put("feedPollDelay", annonMap.get("feedPollDelay"));
        binding.put("leaseAcquireInterval", annonMap.get("leaseAcquireInterval"));
        binding.put("leaseExpirationInterval", annonMap.get("leaseExpirationInterval"));
        binding.put("leaseRenewInterval", annonMap.get("leaseRenewInterval"));
        binding.put("checkpointFrequency", annonMap.get("checkpointFrequency"));
        binding.put("maxItemsPerInvocation", annonMap.get("maxItemsPerInvocation"));
        binding.put("startFromBeginning", annonMap.get("startFromBeginning"));
        binding.put("preferredLocations", annonMap.get("preferredLocations"));
        return binding;
    }
}

