/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions.handlers.http;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.Utils;
import org.ballerinax.azurefunctions.handlers.AbstractReturnHandler;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class HTTPReturnHandler
extends AbstractReturnHandler {
    public HTTPReturnHandler(BType retType, BLangAnnotationAttachment annotation) {
        super(retType, annotation);
    }

    @Override
    public void postInvocationProcess(BLangExpression returnValueExpr) throws AzureFunctionsException {
        if (Utils.isStringType(this.ctx.globalCtx, this.retType)) {
            Utils.addAzurePkgFunctionCall(this.ctx, "setStringReturn", true, new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), returnValueExpr});
        } else if (Utils.isJsonType(this.ctx.globalCtx, this.retType)) {
            Utils.addAzurePkgFunctionCall(this.ctx, "setJsonReturn", true, new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), returnValueExpr});
        } else if (Utils.isAzurePkgType(this.ctx, "HTTPBinding", this.retType)) {
            Utils.addAzurePkgFunctionCall(this.ctx, "setHTTPReturn", true, new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), returnValueExpr});
        } else {
            throw this.createError("Type '" + this.retType.tsymbol.name.value + "' is not supported");
        }
    }

    @Override
    public Map<String, Object> generateBinding() {
        LinkedHashMap<String, Object> binding = new LinkedHashMap<String, Object>();
        binding.put("type", "http");
        return binding;
    }
}

