/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions.handlers.queue;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.BindingType;
import org.ballerinax.azurefunctions.Utils;
import org.ballerinax.azurefunctions.handlers.AbstractParameterHandler;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class QueueOutputParameterHandler
extends AbstractParameterHandler {
    private BVarSymbol var;

    public QueueOutputParameterHandler(BLangSimpleVariable param, BLangAnnotationAttachment annotation) {
        super(param, annotation, BindingType.OUTPUT);
    }

    @Override
    public BLangExpression invocationProcess() throws AzureFunctionsException {
        if (!Utils.isAzurePkgType(this.ctx, "StringOutputBinding", this.param.type)) {
            throw this.createError("Type must be 'StringOutputBinding'");
        }
        this.var = Utils.addAzurePkgRecordVarDef(this.ctx, "StringOutputBinding", this.ctx.getNextVarName());
        return Utils.createVariableRef(this.ctx.globalCtx, this.var);
    }

    @Override
    public void postInvocationProcess() throws AzureFunctionsException {
        Utils.addAzurePkgFunctionCall(this.ctx, "setStringOutput", true, new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name), Utils.createVariableRef(this.ctx.globalCtx, this.var)});
    }

    @Override
    public Map<String, Object> generateBinding() {
        LinkedHashMap<String, Object> binding = new LinkedHashMap<String, Object>();
        Map<String, Object> annonMap = Utils.extractAnnotationKeyValues(this.annotation);
        binding.put("type", "queue");
        binding.put("queueName", annonMap.get("queueName"));
        String connection = (String)annonMap.get("connection");
        if (connection == null) {
            connection = "AzureWebJobsStorage";
        }
        binding.put("connection", connection);
        return binding;
    }
}

