/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions.handlers.queue;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.BindingType;
import org.ballerinax.azurefunctions.Utils;
import org.ballerinax.azurefunctions.handlers.AbstractParameterHandler;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class QueueTriggerHandler
extends AbstractParameterHandler {
    public QueueTriggerHandler(BLangSimpleVariable param, BLangAnnotationAttachment annotation) {
        super(param, annotation, BindingType.TRIGGER);
    }

    @Override
    public BLangExpression invocationProcess() throws AzureFunctionsException {
        if (Utils.isStringType(this.ctx.globalCtx, this.param.type)) {
            return Utils.createAzurePkgInvocationNode(this.ctx, "getStringFromInputData", new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name)});
        }
        if (Utils.isJsonType(this.ctx.globalCtx, this.param.type)) {
            return Utils.createAzurePkgInvocationNode(this.ctx, "getJsonFromInputDataDoubleEscaped", new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name)});
        }
        throw this.createError("Type must be 'string' or 'json'");
    }

    @Override
    public void postInvocationProcess() throws AzureFunctionsException {
    }

    @Override
    public Map<String, Object> generateBinding() {
        LinkedHashMap<String, Object> binding = new LinkedHashMap<String, Object>();
        Map<String, Object> annonMap = Utils.extractAnnotationKeyValues(this.annotation);
        binding.put("type", "queueTrigger");
        binding.put("queueName", annonMap.get("queueName"));
        String connection = (String)annonMap.get("connection");
        if (connection == null) {
            connection = "AzureWebJobsStorage";
        }
        binding.put("connection", connection);
        return binding;
    }
}

