/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.azurefunctions.handlers.twilio;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.azurefunctions.AzureFunctionsException;
import org.ballerinax.azurefunctions.BindingType;
import org.ballerinax.azurefunctions.Utils;
import org.ballerinax.azurefunctions.handlers.AbstractParameterHandler;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class TwilioSmsOutputParameterHandler
extends AbstractParameterHandler {
    private BVarSymbol var;

    public TwilioSmsOutputParameterHandler(BLangSimpleVariable param, BLangAnnotationAttachment annotation) {
        super(param, annotation, BindingType.OUTPUT);
    }

    @Override
    public BLangExpression invocationProcess() throws AzureFunctionsException {
        if (!Utils.isAzurePkgType(this.ctx, "TwilioSmsOutputBinding", this.param.type)) {
            throw this.createError("Type must be 'TwilioSmsOutputBinding'");
        }
        this.var = Utils.addAzurePkgRecordVarDef(this.ctx, "TwilioSmsOutputBinding", this.ctx.getNextVarName());
        return Utils.createVariableRef(this.ctx.globalCtx, this.var);
    }

    @Override
    public void postInvocationProcess() throws AzureFunctionsException {
        Utils.addAzurePkgFunctionCall(this.ctx, "setTwilioSmsOutput", true, new BLangExpression[]{Utils.createVariableRef(this.ctx.globalCtx, this.ctx.handlerParams), Utils.createStringLiteral(this.ctx.globalCtx, this.name), Utils.createVariableRef(this.ctx.globalCtx, this.var)});
    }

    @Override
    public Map<String, Object> generateBinding() {
        LinkedHashMap<String, Object> binding = new LinkedHashMap<String, Object>();
        Map<String, Object> annonMap = Utils.extractAnnotationKeyValues(this.annotation);
        binding.put("type", "twilioSms");
        binding.put("from", annonMap.get("fromNumber"));
        String accountSidSetting = (String)annonMap.get("accountSidSetting");
        if (accountSidSetting == null) {
            accountSidSetting = "AzureWebJobsTwilioAccountSid";
        }
        binding.put("accountSidSetting", accountSidSetting);
        String authTokenSetting = (String)annonMap.get("authTokenSetting");
        if (authTokenSetting == null) {
            authTokenSetting = "AzureWebJobsTwilioAuthToken";
        }
        binding.put("authTokenSetting", authTokenSetting);
        return binding;
    }
}

