/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.rest;

import com.google.common.base.Strings;
import io.ballerina.messaging.broker.auth.AuthManager;
import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.common.config.BrokerConfigProvider;
import io.ballerina.messaging.broker.coordination.BasicHaListener;
import io.ballerina.messaging.broker.coordination.HaListener;
import io.ballerina.messaging.broker.coordination.HaStrategy;
import io.ballerina.messaging.broker.rest.BrokerServiceRunner;
import io.ballerina.messaging.broker.rest.config.RestServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.MicroservicesRunner;

public class BrokerRestServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerRestServer.class);
    private final MicroservicesRunner microservicesRunner;
    private HaStrategy haStrategy;
    private BrokerRestRunnerHelper brokerRestRunnerHelper;

    public BrokerRestServer(StartupContext startupContext) throws Exception {
        String transportConfig = System.getProperty("transports.netty.conf");
        AuthManager authManager = (AuthManager)startupContext.getService(AuthManager.class);
        if (Strings.isNullOrEmpty((String)transportConfig)) {
            BrokerConfigProvider configProvider = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
            RestServerConfiguration configuration = (RestServerConfiguration)configProvider.getConfigurationObject("wso2.broker.admin.service", RestServerConfiguration.class);
            int port = Integer.parseInt(configuration.getPlain().getPort());
            this.microservicesRunner = new MicroservicesRunner(new int[]{port});
        } else {
            this.microservicesRunner = new MicroservicesRunner();
        }
        startupContext.registerService(BrokerServiceRunner.class, (Object)new BrokerServiceRunner(this.microservicesRunner, authManager));
        this.haStrategy = (HaStrategy)startupContext.getService(HaStrategy.class);
        if (this.haStrategy == null) {
            this.brokerRestRunnerHelper = new BrokerRestRunnerHelper();
        } else {
            LOGGER.info("Broker Rest Runner is in PASSIVE mode");
            this.brokerRestRunnerHelper = new HaEnabledBrokerRestRunnerHelper();
        }
    }

    public void start() {
        this.brokerRestRunnerHelper.start();
    }

    public void stop() {
        this.microservicesRunner.stop();
        LOGGER.info("Broker admin service stopped.");
    }

    public void shutdown() {
        this.brokerRestRunnerHelper.shutdown();
    }

    private class HaEnabledBrokerRestRunnerHelper
    extends BrokerRestRunnerHelper
    implements HaListener {
        private BasicHaListener basicHaListener;

        HaEnabledBrokerRestRunnerHelper() {
            this.basicHaListener = new BasicHaListener((HaListener)this);
            BrokerRestServer.this.haStrategy.registerListener((HaListener)this.basicHaListener, 3);
        }

        @Override
        public synchronized void start() {
            this.basicHaListener.setStartCalled();
            if (!this.basicHaListener.isActive()) {
                return;
            }
            super.start();
        }

        @Override
        public void shutdown() {
            BrokerRestServer.this.haStrategy.unregisterListener((HaListener)this.basicHaListener);
            super.shutdown();
        }

        public void activate() {
            this.startOnBecomingActive();
            LOGGER.info("Broker Rest Server mode changed from PASSIVE to ACTIVE");
        }

        public void deactivate() {
            BrokerRestServer.this.stop();
            LOGGER.info("Broker Rest Server mode changed from ACTIVE to PASSIVE");
        }

        private synchronized void startOnBecomingActive() {
            if (this.basicHaListener.isStartCalled()) {
                this.start();
            }
        }
    }

    private class BrokerRestRunnerHelper {
        private BrokerRestRunnerHelper() {
        }

        public void start() {
            BrokerRestServer.this.microservicesRunner.start();
            LOGGER.info("Broker admin service started");
        }

        public void shutdown() {
            BrokerRestServer.this.stop();
        }
    }
}

