/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.rest;

import io.ballerina.messaging.broker.auth.AuthManager;
import io.ballerina.messaging.broker.auth.authentication.Authenticator;
import io.ballerina.messaging.broker.rest.BadRequestMapper;
import io.ballerina.messaging.broker.rest.ForbiddenExceptionMapper;
import io.ballerina.messaging.broker.rest.InternalServerErrorExceptionMapper;
import io.ballerina.messaging.broker.rest.NotAuthorizedExceptionMapper;
import io.ballerina.messaging.broker.rest.ResourceNotFoundMapper;
import io.ballerina.messaging.broker.rest.auth.BasicAuthSecurityInterceptor;
import javax.ws.rs.ext.ExceptionMapper;
import org.wso2.msf4j.MicroservicesRunner;
import org.wso2.msf4j.interceptor.RequestInterceptor;

public class BrokerServiceRunner {
    private MicroservicesRunner runner;

    BrokerServiceRunner(MicroservicesRunner runner, AuthManager authManager) {
        if (authManager.isAuthenticationEnabled()) {
            RequestInterceptor[] requestInterceptorArray = new RequestInterceptor[1];
            requestInterceptorArray[0] = new BasicAuthSecurityInterceptor((arg_0, arg_1) -> ((Authenticator)authManager.getAuthenticator()).authenticate(arg_0, arg_1));
            runner.addGlobalRequestInterceptor(requestInterceptorArray);
        }
        runner.addExceptionMapper(new ExceptionMapper[]{new ResourceNotFoundMapper(), new BadRequestMapper(), new InternalServerErrorExceptionMapper(), new ForbiddenExceptionMapper(), new NotAuthorizedExceptionMapper()});
        this.runner = runner;
    }

    public void deploy(Object ... service) {
        this.runner.deploy(service);
    }
}

