/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.docker;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinax.docker.exceptions.DockerPluginException;
import org.ballerinax.docker.generator.DockerArtifactHandler;
import org.ballerinax.docker.generator.exceptions.DockerGenException;
import org.ballerinax.docker.generator.models.CopyFileModel;
import org.ballerinax.docker.generator.models.DockerModel;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.docker.models.DockerDataHolder;
import org.ballerinax.docker.utils.DockerPluginUtils;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;

class DockerAnnotationProcessor {
    private PrintStream out = System.out;

    DockerAnnotationProcessor() {
    }

    void processDockerModel(DockerDataHolder dockerDataHolder, Path uberJarFilePath, Path outputDir) throws DockerPluginException {
        try {
            Path uberJarFileName;
            DockerModel dockerModel = dockerDataHolder.getDockerModel();
            dockerModel.setPorts(dockerDataHolder.getPorts());
            dockerModel.setCopyFiles(dockerDataHolder.getExternalFiles());
            if (dockerModel.getName() == null) {
                String defaultImageName = DockerGenUtils.extractUberJarName(uberJarFilePath);
                dockerModel.setName(defaultImageName);
            }
            if (null != (uberJarFileName = uberJarFilePath.getFileName())) {
                dockerModel.setUberJarFileName(uberJarFileName.toString());
            }
            Set<Integer> ports = dockerModel.getPorts();
            if (dockerModel.isEnableDebug()) {
                ports.add(dockerModel.getDebugPort());
            }
            dockerModel.setPorts(ports);
            DockerPluginUtils.printDebug(dockerModel.toString());
            this.out.println("\nGenerating docker artifacts...");
            DockerArtifactHandler dockerHandler = new DockerArtifactHandler(dockerModel);
            dockerHandler.createArtifacts(this.out, "\t@docker \t\t", uberJarFilePath, outputDir);
            this.printDockerInstructions(dockerModel, outputDir);
        }
        catch (DockerGenException e) {
            throw new DockerPluginException(e.getMessage(), e);
        }
    }

    DockerModel processConfigAnnotation(AnnotationAttachmentNode attachmentNode) throws DockerPluginException {
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = DockerPluginUtils.getKeyValuePairs((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr);
        DockerModel dockerModel = new DockerModel();
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            DockerConfiguration dockerConfiguration = DockerConfiguration.valueOf(keyValue.getKey().toString());
            String annotationValue = DockerPluginUtils.resolveValue(keyValue.getValue().toString());
            switch (dockerConfiguration) {
                case name: {
                    dockerModel.setName(annotationValue);
                    break;
                }
                case registry: {
                    dockerModel.setRegistry(annotationValue);
                    break;
                }
                case tag: {
                    dockerModel.setTag(annotationValue);
                    break;
                }
                case username: {
                    dockerModel.setUsername(annotationValue);
                    break;
                }
                case password: {
                    dockerModel.setPassword(annotationValue);
                    break;
                }
                case baseImage: {
                    dockerModel.setBaseImage(annotationValue);
                    break;
                }
                case buildImage: {
                    dockerModel.setBuildImage(Boolean.parseBoolean(annotationValue));
                    break;
                }
                case push: {
                    dockerModel.setPush(Boolean.parseBoolean(annotationValue));
                    break;
                }
                case cmd: {
                    dockerModel.setCmd(annotationValue.trim());
                    break;
                }
                case enableDebug: {
                    dockerModel.setEnableDebug(Boolean.parseBoolean(annotationValue));
                    break;
                }
                case debugPort: {
                    dockerModel.setDebugPort(Integer.parseInt(annotationValue));
                    break;
                }
                case dockerAPIVersion: {
                    dockerModel.setDockerAPIVersion(annotationValue);
                    break;
                }
                case dockerHost: {
                    dockerModel.setDockerHost(annotationValue);
                    break;
                }
                case dockerCertPath: {
                    dockerModel.setDockerCertPath(annotationValue);
                    break;
                }
                case env: {
                    dockerModel.setEnv(this.getMap(keyValue.getValue()));
                    break;
                }
                case dockerConfigPath: {
                    dockerModel.setDockerConfig(annotationValue);
                    break;
                }
            }
        }
        dockerModel.setService(true);
        return dockerModel;
    }

    Set<CopyFileModel> processCopyFileAnnotation(AnnotationAttachmentNode attachmentNode) throws DockerPluginException {
        HashSet<CopyFileModel> copyFileModels = new HashSet<CopyFileModel>();
        boolean confFileDefined = false;
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = DockerPluginUtils.getKeyValuePairs((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr);
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            List configAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
            for (BLangExpression bLangExpression : configAnnotation) {
                CopyFileModel fileModel = new CopyFileModel();
                List<BLangRecordLiteral.BLangRecordKeyValueField> annotationValues = DockerPluginUtils.getKeyValuePairs((BLangRecordLiteral)bLangExpression);
                for (BLangRecordLiteral.BLangRecordKeyValueField annotation : annotationValues) {
                    CopyFileConfiguration copyFileConfiguration = CopyFileConfiguration.valueOf(annotation.getKey().toString());
                    String annotationValue = DockerPluginUtils.resolveValue(annotation.getValue().toString());
                    switch (copyFileConfiguration) {
                        case sourceFile: {
                            fileModel.setSource(annotationValue);
                            break;
                        }
                        case target: {
                            fileModel.setTarget(annotationValue);
                            break;
                        }
                        case isBallerinaConf: {
                            boolean value = Boolean.parseBoolean(annotationValue);
                            if (confFileDefined && value) {
                                throw new DockerPluginException("@docker:CopyFiles{} annotation has more than one conf files defined.");
                            }
                            fileModel.setBallerinaConf(value);
                            confFileDefined = Boolean.parseBoolean(annotationValue);
                            break;
                        }
                    }
                }
                copyFileModels.add(fileModel);
            }
        }
        return copyFileModels;
    }

    private void printDockerInstructions(DockerModel dockerModel, Path outputDir) {
        CharSequence command;
        this.out.println();
        if (!dockerModel.isBuildImage()) {
            this.out.println();
            this.out.println("\tRun the following command to build the docker image:");
            command = "docker build --force-rm --no-cache -t " + dockerModel.getName();
            Path currentDir = Paths.get(System.getProperty("user.dir"), new String[0]);
            command = (String)command + " " + currentDir.relativize(outputDir);
            this.out.println("\t" + (String)command);
        }
        this.out.println();
        this.out.println("\tRun the following command to start a Docker container:");
        command = new StringBuilder("docker run -d ");
        dockerModel.getPorts().forEach(arg_0 -> DockerAnnotationProcessor.lambda$printDockerInstructions$0((StringBuilder)command, arg_0));
        ((StringBuilder)command).append(dockerModel.getName());
        this.out.println("\t" + ((StringBuilder)command).toString());
        this.out.println();
    }

    private Map<String, String> getMap(BLangExpression expr) throws DockerPluginException {
        if (expr.getKind() != NodeKind.RECORD_LITERAL_EXPR) {
            throw new DockerPluginException("unable to parse value: " + expr.toString());
        }
        BLangRecordLiteral fields = (BLangRecordLiteral)expr;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : this.convertRecordFields(fields.getFields())) {
            map.put(keyValue.getKey().toString(), this.getStringValue(keyValue.getValue()));
        }
        return map;
    }

    private List<BLangRecordLiteral.BLangRecordKeyValueField> convertRecordFields(List<RecordLiteralNode.RecordField> fields) {
        return fields.stream().map(f -> (BLangRecordLiteral.BLangRecordKeyValueField)f).collect(Collectors.toList());
    }

    private String getStringValue(BLangExpression expr) throws DockerPluginException {
        if (expr instanceof BLangSimpleVarRef) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)expr;
            if (varRef.symbol instanceof BConstantSymbol) {
                BFiniteType compileConst;
                BConstantSymbol constantSymbol = (BConstantSymbol)varRef.symbol;
                if (constantSymbol.type instanceof BFiniteType && (compileConst = (BFiniteType)constantSymbol.type).getValueSpace().size() > 0) {
                    return DockerPluginUtils.resolveValue(((BLangExpression)compileConst.getValueSpace().iterator().next()).toString());
                }
            }
        } else if (expr instanceof BLangLiteral) {
            return DockerPluginUtils.resolveValue(expr.toString());
        }
        throw new DockerPluginException("unable to parse value: " + expr.toString());
    }

    private static /* synthetic */ void lambda$printDockerInstructions$0(StringBuilder command, Integer port) {
        command.append("-p ").append(port).append(":").append(port).append(" ");
    }

    private static enum CopyFileConfiguration {
        sourceFile,
        target,
        isBallerinaConf;

    }

    private static enum DockerConfiguration {
        name,
        registry,
        tag,
        username,
        password,
        baseImage,
        buildImage,
        push,
        cmd,
        enableDebug,
        debugPort,
        dockerAPIVersion,
        dockerHost,
        dockerCertPath,
        env,
        dockerConfigPath;

    }
}

