/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.docker;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.ballerinax.docker.DockerAnnotationProcessor;
import org.ballerinax.docker.exceptions.DockerPluginException;
import org.ballerinax.docker.generator.models.CopyFileModel;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.docker.models.DockerContext;
import org.ballerinax.docker.models.DockerDataHolder;
import org.ballerinax.docker.utils.DockerPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

@SupportedAnnotationPackages(value={"ballerina/docker"})
public class DockerPlugin
extends AbstractCompilerPlugin {
    private static final Logger pluginLog = LoggerFactory.getLogger(DockerPlugin.class);
    private DockerAnnotationProcessor dockerAnnotationProcessor;
    private DiagnosticLog dlog;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
        this.dockerAnnotationProcessor = new DockerAnnotationProcessor();
    }

    public void process(PackageNode packageNode) {
        BLangPackage bPackage = (BLangPackage)packageNode;
        String pkgID = bPackage.packageID.toString();
        DockerContext.getInstance().addDataHolder(pkgID);
        List dockerImports = bPackage.getImports().stream().filter(i -> i.symbol.toString().equals("ballerina/docker") && i.getAlias().toString().equals("_")).collect(Collectors.toList());
        if (dockerImports.size() > 0) {
            for (BLangImportPackage dockerImport : dockerImports) {
                List topLevelNodes = bPackage.getCompilationUnits().stream().filter(cu -> cu.getName().equals(dockerImport.compUnit.getValue())).flatMap(cu -> cu.getTopLevelNodes().stream()).collect(Collectors.toList());
                List<ServiceNode> serviceNodes = topLevelNodes.stream().filter(tln -> tln instanceof ServiceNode).map(tln -> (ServiceNode)tln).collect(Collectors.toList());
                serviceNodes.forEach(sn -> this.process((ServiceNode)sn, Collections.singletonList(DockerPluginUtils.createAnnotation("Config"))));
                List listenerNamesToExpose = serviceNodes.stream().map(ServiceNode::getAttachedExprs).flatMap(Collection::stream).filter(aex -> aex instanceof BLangSimpleVarRef).map(aex -> (BLangSimpleVarRef)aex).map(BLangSimpleVarRef::toString).collect(Collectors.toList());
                topLevelNodes.stream().filter(tln -> tln instanceof SimpleVariableNode).map(tln -> (SimpleVariableNode)tln).filter(listener -> listenerNamesToExpose.contains(listener.getName().getValue())).forEach(listener -> this.process((SimpleVariableNode)listener, Collections.singletonList(DockerPluginUtils.createAnnotation("Expose"))));
                topLevelNodes.stream().filter(tln -> tln instanceof FunctionNode).map(tln -> (FunctionNode)tln).filter(fn -> "main".equals(fn.getName().getValue())).forEach(fn -> this.process((FunctionNode)fn, Collections.singletonList(DockerPluginUtils.createAnnotation("Config"))));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        DockerDataHolder dataHolder = DockerContext.getInstance().getDataHolder();
        dataHolder.setCanProcess(true);
        try {
            this.processCommonAnnotations(annotations, dataHolder);
            BLangService bService = (BLangService)serviceNode;
            for (BLangExpression attachedExpr : bService.getAttachedExprs()) {
                if (!(attachedExpr instanceof BLangTypeInit)) continue;
                BLangTypeInit bListener = (BLangTypeInit)attachedExpr;
                try {
                    dataHolder.addPort(Integer.parseInt(((BLangExpression)bListener.argsExpr.get(0)).toString()));
                }
                catch (NumberFormatException e) {
                    throw new DockerPluginException("Unable to parse port of the listener: " + ((BLangExpression)bListener.argsExpr.get(0)).toString());
                    return;
                }
            }
        }
        catch (DockerPluginException e) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)e.getMessage());
        }
    }

    public void process(SimpleVariableNode variableNode, List<AnnotationAttachmentNode> annotations) {
        DockerDataHolder dataHolder = DockerContext.getInstance().getDataHolder();
        dataHolder.setCanProcess(true);
        try {
            for (AnnotationAttachmentNode attachmentNode : annotations) {
                DockerAnnotation dockerAnnotation = DockerAnnotation.valueOf(attachmentNode.getAnnotationName().getValue());
                switch (dockerAnnotation) {
                    case Config: {
                        dataHolder.setDockerModel(this.dockerAnnotationProcessor.processConfigAnnotation(attachmentNode));
                        break;
                    }
                    case CopyFiles: {
                        dataHolder.addExternalFiles(this.dockerAnnotationProcessor.processCopyFileAnnotation(attachmentNode));
                        break;
                    }
                    case Expose: {
                        BLangTypeInit bListener = (BLangTypeInit)((BLangSimpleVariable)variableNode).expr;
                        try {
                            dataHolder.addPort(Integer.parseInt(((BLangExpression)bListener.argsExpr.get(0)).toString()));
                            this.processListener(bListener, dataHolder);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new DockerPluginException("unable to parse port of the service: " + ((BLangExpression)bListener.argsExpr.get(0)).toString());
                        }
                    }
                }
            }
        }
        catch (DockerPluginException e) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, variableNode.getPosition(), (CharSequence)e.getMessage());
        }
    }

    public void process(FunctionNode functionNode, List<AnnotationAttachmentNode> annotations) {
        if (!"main".equals(functionNode.getName().getValue())) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, functionNode.getPosition(), (CharSequence)"@docker annotations are only supported with main function. ");
            return;
        }
        DockerDataHolder dataHolder = DockerContext.getInstance().getDataHolder();
        dataHolder.setCanProcess(true);
        try {
            this.processCommonAnnotations(annotations, dataHolder);
        }
        catch (DockerPluginException e) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, functionNode.getPosition(), (CharSequence)e.getMessage());
        }
    }

    private void processCommonAnnotations(List<AnnotationAttachmentNode> annotations, DockerDataHolder dataHolder) throws DockerPluginException {
        for (AnnotationAttachmentNode attachmentNode : annotations) {
            DockerAnnotation dockerAnnotation = DockerAnnotation.valueOf(attachmentNode.getAnnotationName().getValue());
            switch (dockerAnnotation) {
                case Config: {
                    dataHolder.setDockerModel(this.dockerAnnotationProcessor.processConfigAnnotation(attachmentNode));
                    break;
                }
                case CopyFiles: {
                    dataHolder.addExternalFiles(this.dockerAnnotationProcessor.processCopyFileAnnotation(attachmentNode));
                    break;
                }
            }
        }
    }

    private void processListener(BLangTypeInit bListener, DockerDataHolder dataHolder) {
        if (bListener.argsExpr.size() == 2) {
            List<Object> listenerConfig;
            if (bListener.argsExpr.get(1) instanceof BLangRecordLiteral) {
                BLangRecordLiteral bConfigRecordLiteral = (BLangRecordLiteral)bListener.argsExpr.get(1);
                listenerConfig = bConfigRecordLiteral.getFields().stream().map(x -> (BLangRecordLiteral.BLangRecordKeyValueField)x).collect(Collectors.toList());
            } else {
                listenerConfig = DockerPluginUtils.getKeyValuePairs((BLangRecordLiteral)((BLangNamedArgsExpression)bListener.argsExpr.get((int)1)).expr);
            }
            for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : listenerConfig) {
                String key = keyValue.getKey().toString();
                if (!"secureSocket".equals(key)) continue;
                List<BLangRecordLiteral.BLangRecordKeyValueField> sslKeyValues = DockerPluginUtils.getKeyValuePairs((BLangRecordLiteral)keyValue.valueExpr);
                dataHolder.addExternalFiles(this.processSecureSocket(sslKeyValues));
            }
        }
    }

    private Set<CopyFileModel> processSecureSocket(List<BLangRecordLiteral.BLangRecordKeyValueField> secureSocketKeyValues) {
        HashSet<CopyFileModel> copyFileModels = new HashSet<CopyFileModel>();
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : secureSocketKeyValues) {
            String trustStoreFile;
            CopyFileModel copyFileModel;
            String key = keyValue.getKey().toString();
            if ("keyStore".equals(key)) {
                String keyStoreFile = this.extractFilePath(keyValue);
                if (keyStoreFile == null) continue;
                copyFileModel = new CopyFileModel();
                copyFileModel.setSource(keyStoreFile);
                copyFileModel.setTarget(keyStoreFile);
                copyFileModels.add(copyFileModel);
                continue;
            }
            if (!"trustStore".equals(key) || (trustStoreFile = this.extractFilePath(keyValue)) == null) continue;
            copyFileModel = new CopyFileModel();
            copyFileModel.setSource(trustStoreFile);
            copyFileModel.setTarget(trustStoreFile);
            copyFileModels.add(copyFileModel);
        }
        return copyFileModels;
    }

    private String extractFilePath(BLangRecordLiteral.BLangRecordKeyValueField keyValue) {
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyStoreConfigs = DockerPluginUtils.getKeyValuePairs((BLangRecordLiteral)keyValue.valueExpr);
        for (BLangRecordLiteral.BLangRecordKeyValueField keyStoreConfig : keyStoreConfigs) {
            String configKey = keyStoreConfig.getKey().toString();
            if (!"path".equals(configKey)) continue;
            return keyStoreConfig.getValue().toString();
        }
        return null;
    }

    public void codeGenerated(PackageID moduleID, Path executableJarFile) {
        DockerContext.getInstance().setCurrentPackage(moduleID.toString());
        if (DockerContext.getInstance().getDataHolder().isCanProcess()) {
            if (null != (executableJarFile = executableJarFile.toAbsolutePath()).getParent() && Files.exists(executableJarFile.getParent(), new LinkOption[0])) {
                Path projectRoot;
                DockerAnnotationProcessor dockerAnnotationProcessor = new DockerAnnotationProcessor();
                Path dockerOutputPath = executableJarFile.getParent().resolve("docker");
                if (null != executableJarFile.getParent().getParent().getParent() && Files.exists(executableJarFile.getParent().getParent().getParent(), new LinkOption[0]) && Files.exists((projectRoot = executableJarFile.getParent().getParent().getParent()).resolve("Ballerina.toml"), new LinkOption[0])) {
                    dockerOutputPath = projectRoot.resolve("target").resolve("docker").resolve(DockerGenUtils.extractUberJarName(executableJarFile));
                }
                try {
                    DockerPluginUtils.deleteDirectory(dockerOutputPath);
                    dockerAnnotationProcessor.processDockerModel(DockerContext.getInstance().getDataHolder(), executableJarFile, dockerOutputPath);
                }
                catch (DockerPluginException e) {
                    String errorMessage = "module [" + moduleID + "] " + e.getMessage();
                    DockerPluginUtils.printError(errorMessage);
                    pluginLog.error(errorMessage, (Throwable)e);
                    try {
                        DockerPluginUtils.deleteDirectory(dockerOutputPath);
                    }
                    catch (DockerPluginException dockerPluginException) {}
                }
            } else {
                DockerPluginUtils.printError("error in resolving docker generation location.");
                pluginLog.error("error in resolving docker generation location.");
            }
        }
    }

    private static enum DockerAnnotation {
        Config,
        CopyFiles,
        Expose;

    }
}

