/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.docker.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinax.docker.exceptions.DockerPluginException;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class DockerPluginUtils {
    private static final boolean debugEnabled = "true".equals(System.getenv("BAL_DOCKER_DEBUG"));
    private static final PrintStream error = System.err;
    private static final PrintStream out = System.out;

    public static void printError(String msg) {
        error.println("error [docker plugin]: " + msg);
    }

    public static List<BLangRecordLiteral.BLangRecordKeyValueField> getKeyValuePairs(BLangRecordLiteral bLangRecordLiteral) {
        return bLangRecordLiteral.getFields().stream().map(field -> (BLangRecordLiteral.BLangRecordKeyValueField)field).collect(Collectors.toList());
    }

    public static void printDebug(String msg) {
        if (debugEnabled) {
            out.println("debug [docker plugin]: " + msg);
        }
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static void deleteDirectory(Path pathToBeDeleted) throws DockerPluginException {
        if (!Files.exists(pathToBeDeleted, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(pathToBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new DockerPluginException("Unable to delete directory: " + pathToBeDeleted.toString(), e);
        }
    }

    public static String resolveValue(String value) throws DockerPluginException {
        int endIndex;
        int startIndex = value.indexOf("$env{");
        if (startIndex >= 0 && (endIndex = value.indexOf("}", startIndex)) > 0) {
            String varName = value.substring(startIndex + 5, endIndex).trim();
            String resolvedVar = Optional.ofNullable(System.getenv(varName)).orElseThrow(() -> new DockerPluginException("error resolving value: " + varName + " is not set in the environment."));
            String rest = value.length() > endIndex + 1 ? DockerPluginUtils.resolveValue(value.substring(endIndex + 1)) : "";
            return value.substring(0, startIndex) + resolvedVar + rest;
        }
        return value;
    }

    public static AnnotationAttachmentNode createAnnotation(String annotationName) {
        BLangAnnotationAttachment configAnnotation = new BLangAnnotationAttachment();
        BLangIdentifier configIdentifier = new BLangIdentifier();
        configIdentifier.setValue(annotationName);
        configAnnotation.setAnnotationName((IdentifierNode)configIdentifier);
        configAnnotation.setExpression((ExpressionNode)new BLangRecordLiteral());
        return configAnnotation;
    }
}

