/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.command.GraphDriver;
import com.github.dockerjava.api.command.HealthState;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumeBind;
import com.github.dockerjava.api.model.VolumeBinds;
import com.github.dockerjava.api.model.VolumeRW;
import com.github.dockerjava.api.model.VolumesRW;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InspectContainerResponse {
    @JsonProperty(value="Args")
    private String[] args;
    @JsonProperty(value="Config")
    private ContainerConfig config;
    @JsonProperty(value="Created")
    private String created;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="ExecDriver")
    private String execDriver;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig;
    @JsonProperty(value="HostnamePath")
    private String hostnamePath;
    @JsonProperty(value="HostsPath")
    private String hostsPath;
    @JsonProperty(value="LogPath")
    private String logPath;
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="SizeRootFs")
    private Integer sizeRootFs;
    @JsonProperty(value="Image")
    private String imageId;
    @JsonProperty(value="MountLabel")
    private String mountLabel;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="RestartCount")
    private Integer restartCount;
    @JsonProperty(value="NetworkSettings")
    private NetworkSettings networkSettings;
    @JsonProperty(value="Path")
    private String path;
    @JsonProperty(value="ProcessLabel")
    private String processLabel;
    @JsonProperty(value="ResolvConfPath")
    private String resolvConfPath;
    @JsonProperty(value="ExecIDs")
    private List<String> execIds;
    @JsonProperty(value="State")
    private ContainerState state;
    @JsonProperty(value="Volumes")
    private VolumeBinds volumes;
    @JsonProperty(value="VolumesRW")
    private VolumesRW volumesRW;
    @JsonProperty(value="Node")
    private Node node;
    @JsonProperty(value="Mounts")
    private List<Mount> mounts;
    @JsonProperty(value="GraphDriver")
    private GraphDriver graphDriver;
    @JsonProperty(value="Platform")
    private String platform;

    public String getId() {
        return this.id;
    }

    public Integer getSizeRootFs() {
        return this.sizeRootFs;
    }

    public String getCreated() {
        return this.created;
    }

    public String getPath() {
        return this.path;
    }

    public String getProcessLabel() {
        return this.processLabel;
    }

    public String[] getArgs() {
        return this.args;
    }

    public ContainerConfig getConfig() {
        return this.config;
    }

    public ContainerState getState() {
        return this.state;
    }

    public String getImageId() {
        return this.imageId;
    }

    public NetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public String getResolvConfPath() {
        return this.resolvConfPath;
    }

    @JsonIgnore
    public VolumeBind[] getVolumes() {
        return this.volumes == null ? null : this.volumes.getBinds();
    }

    @JsonIgnore
    @Deprecated
    @CheckForNull
    public VolumeRW[] getVolumesRW() {
        return this.volumesRW == null ? null : this.volumesRW.getVolumesRW();
    }

    public String getHostnamePath() {
        return this.hostnamePath;
    }

    public String getHostsPath() {
        return this.hostsPath;
    }

    @CheckForNull
    public String getLogPath() {
        return this.logPath;
    }

    public String getName() {
        return this.name;
    }

    public Integer getRestartCount() {
        return this.restartCount;
    }

    public String getDriver() {
        return this.driver;
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public String getExecDriver() {
        return this.execDriver;
    }

    public String getMountLabel() {
        return this.mountLabel;
    }

    @CheckForNull
    public List<Mount> getMounts() {
        return this.mounts;
    }

    public List<String> getExecIds() {
        return this.execIds;
    }

    public Node getNode() {
        return this.node;
    }

    @CheckForNull
    public GraphDriver getGraphDriver() {
        return this.graphDriver;
    }

    @CheckForNull
    public String getPlatform() {
        return this.platform;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class Node {
        @JsonProperty(value="ID")
        private String id;
        @JsonProperty(value="IP")
        private String ip;
        @JsonProperty(value="Addr")
        private String addr;
        @JsonProperty(value="Name")
        private String name;
        @JsonProperty(value="Cpus")
        private Integer cpus;
        @JsonProperty(value="Memory")
        private Long memory;
        @JsonProperty(value="Labels")
        private Map<String, String> labels;

        public String getId() {
            return this.id;
        }

        public String getIp() {
            return this.ip;
        }

        public String getAddr() {
            return this.addr;
        }

        public String getName() {
            return this.name;
        }

        public Integer getCpus() {
            return this.cpus;
        }

        public Long getMemory() {
            return this.memory;
        }

        public Map<String, String> getLabels() {
            return this.labels;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Mount {
        @CheckForNull
        @JsonProperty(value="Name")
        private String name;
        @CheckForNull
        @JsonProperty(value="Source")
        private String source;
        @CheckForNull
        @JsonProperty(value="Destination")
        private Volume destination;
        @CheckForNull
        @JsonProperty(value="Driver")
        private String driver;
        @CheckForNull
        @JsonProperty(value="Mode")
        private String mode;
        @CheckForNull
        @JsonProperty(value="RW")
        private Boolean rw;

        @CheckForNull
        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getSource() {
            return this.source;
        }

        @CheckForNull
        public Volume getDestination() {
            return this.destination;
        }

        @CheckForNull
        public String getDriver() {
            return this.driver;
        }

        @CheckForNull
        public String getMode() {
            return this.mode;
        }

        @CheckForNull
        public Boolean getRW() {
            return this.rw;
        }

        public Mount withDestination(Volume destination) {
            this.destination = destination;
            return this;
        }

        public Mount withDriver(String driver) {
            this.driver = driver;
            return this;
        }

        public Mount withMode(String mode) {
            this.mode = mode;
            return this;
        }

        public Mount withName(String name) {
            this.name = name;
            return this;
        }

        public Mount withRw(Boolean rw) {
            this.rw = rw;
            return this;
        }

        public Mount withSource(String source) {
            this.source = source;
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals(this, o);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode(this);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public class ContainerState {
        @CheckForNull
        @JsonProperty(value="Status")
        private String status;
        @CheckForNull
        @JsonProperty(value="Running")
        private Boolean running;
        @CheckForNull
        @JsonProperty(value="Paused")
        private Boolean paused;
        @CheckForNull
        @JsonProperty(value="Restarting")
        private Boolean restarting;
        @CheckForNull
        @JsonProperty(value="OOMKilled")
        private Boolean oomKilled;
        @CheckForNull
        @JsonProperty(value="Dead")
        private Boolean dead;
        @CheckForNull
        @JsonProperty(value="Pid")
        private Integer pid;
        @CheckForNull
        @JsonProperty(value="ExitCode")
        private Integer exitCode;
        @CheckForNull
        @JsonProperty(value="Error")
        private String error;
        @CheckForNull
        @JsonProperty(value="StartedAt")
        private String startedAt;
        @CheckForNull
        @JsonProperty(value="FinishedAt")
        private String finishedAt;
        @JsonProperty(value="Health")
        private HealthState health;

        @CheckForNull
        public String getStatus() {
            return this.status;
        }

        @CheckForNull
        public Boolean getRunning() {
            return this.running;
        }

        @CheckForNull
        public Boolean getPaused() {
            return this.paused;
        }

        @CheckForNull
        public Boolean getRestarting() {
            return this.restarting;
        }

        @CheckForNull
        public Boolean getOOMKilled() {
            return this.oomKilled;
        }

        @CheckForNull
        public Boolean getDead() {
            return this.dead;
        }

        @CheckForNull
        public Integer getPid() {
            return this.pid;
        }

        @CheckForNull
        public Integer getExitCode() {
            return this.exitCode;
        }

        @CheckForNull
        public String getError() {
            return this.error;
        }

        @CheckForNull
        public String getStartedAt() {
            return this.startedAt;
        }

        @CheckForNull
        public String getFinishedAt() {
            return this.finishedAt;
        }

        public HealthState getHealth() {
            return this.health;
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals(this, o);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode(this);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }
}

