/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.ContainerDNSConfig;
import com.github.dockerjava.api.model.ContainerSpecConfig;
import com.github.dockerjava.api.model.ContainerSpecPrivileges;
import com.github.dockerjava.api.model.ContainerSpecSecret;
import com.github.dockerjava.api.model.HealthCheck;
import com.github.dockerjava.api.model.Mount;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ContainerSpec
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="Command")
    private List<String> command;
    @JsonProperty(value="Args")
    private List<String> args;
    @JsonProperty(value="Env")
    private List<String> env;
    @JsonProperty(value="Dir")
    private String dir;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="Groups")
    private String groups;
    @JsonProperty(value="TTY")
    private Boolean tty;
    @JsonProperty(value="Mounts")
    private List<Mount> mounts;
    @JsonProperty(value="Duration")
    private Long duration;
    @JsonProperty(value="StopGracePeriod")
    private Long stopGracePeriod;
    @JsonProperty(value="DNSConfig")
    private ContainerDNSConfig dnsConfig;
    @JsonProperty(value="OpenStdin")
    private Boolean openStdin;
    @JsonProperty(value="ReadOnly")
    private Boolean readOnly;
    @JsonProperty(value="Hosts")
    private List<String> hosts;
    @JsonProperty(value="Hostname")
    private String hostname;
    @JsonProperty(value="Secrets")
    private List<ContainerSpecSecret> secrets;
    @JsonProperty(value="HealthCheck")
    private HealthCheck healthCheck;
    @JsonProperty(value="StopSignal")
    private String stopSignal;
    @JsonProperty(value="Privileges")
    private ContainerSpecPrivileges privileges;
    @JsonProperty(value="Configs")
    private List<ContainerSpecConfig> configs;

    @CheckForNull
    public String getImage() {
        return this.image;
    }

    public ContainerSpec withImage(String image) {
        this.image = image;
        return this;
    }

    @CheckForNull
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public ContainerSpec withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    @CheckForNull
    public List<String> getCommand() {
        return this.command;
    }

    public ContainerSpec withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    @CheckForNull
    public List<String> getArgs() {
        return this.args;
    }

    public ContainerSpec withArgs(List<String> args) {
        this.args = args;
        return this;
    }

    @CheckForNull
    public List<String> getEnv() {
        return this.env;
    }

    public ContainerSpec withEnv(List<String> env) {
        this.env = env;
        return this;
    }

    @CheckForNull
    public String getDir() {
        return this.dir;
    }

    public ContainerSpec withDir(String dir) {
        this.dir = dir;
        return this;
    }

    @CheckForNull
    public String getUser() {
        return this.user;
    }

    public ContainerSpec withUser(String user) {
        this.user = user;
        return this;
    }

    @CheckForNull
    public String getGroups() {
        return this.groups;
    }

    public ContainerSpec withGroups(String groups) {
        this.groups = groups;
        return this;
    }

    @CheckForNull
    public Boolean getTty() {
        return this.tty;
    }

    public ContainerSpec withTty(Boolean tty) {
        this.tty = tty;
        return this;
    }

    @CheckForNull
    public List<Mount> getMounts() {
        return this.mounts;
    }

    public ContainerSpec withMounts(List<Mount> mounts) {
        this.mounts = mounts;
        return this;
    }

    @CheckForNull
    public Long getDuration() {
        return this.duration;
    }

    public ContainerSpec withDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public ContainerDNSConfig getDnsConfig() {
        return this.dnsConfig;
    }

    public ContainerSpec withDnsConfig(ContainerDNSConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return this;
    }

    public Boolean getOpenStdin() {
        return this.openStdin;
    }

    public ContainerSpec withOpenStdin(Boolean openStdin) {
        this.openStdin = openStdin;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public ContainerSpec withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public ContainerSpec withHosts(List<String> hosts) {
        this.hosts = hosts;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public ContainerSpec withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public List<ContainerSpecSecret> getSecrets() {
        return this.secrets;
    }

    public ContainerSpec withSecrets(List<ContainerSpecSecret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public ContainerSpec withHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
        return this;
    }

    public String getStopSignal() {
        return this.stopSignal;
    }

    public ContainerSpec withStopSignal(String stopSignal) {
        this.stopSignal = stopSignal;
        return this;
    }

    public Long getStopGracePeriod() {
        return this.stopGracePeriod;
    }

    public ContainerSpec withStopGracePeriod(Long stopGracePeriod) {
        this.stopGracePeriod = stopGracePeriod;
        return this;
    }

    public ContainerSpecPrivileges getPrivileges() {
        return this.privileges;
    }

    public ContainerSpec withPrivileges(ContainerSpecPrivileges privileges) {
        this.privileges = privileges;
        return this;
    }

    public List<ContainerSpecConfig> getConfigs() {
        return this.configs;
    }

    public ContainerSpec withConfigs(List<ContainerSpecConfig> configs) {
        this.configs = configs;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}

