/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.ListTasksCmd;
import com.github.dockerjava.api.model.Task;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FiltersEncoder;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import com.google.common.net.UrlEscapers;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTasksCmdExec
extends AbstrSyncDockerCmdExec<ListTasksCmd, List<Task>>
implements ListTasksCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListTasksCmdExec.class);

    public ListTasksCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Task> execute(ListTasksCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/tasks");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters())));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Task> tasks = webTarget.request().accept("application/json").get(new GenericType<List<Task>>(){});
        LOGGER.trace("Response: {}", tasks);
        return tasks;
    }
}

