/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.KnativeArtifactManager;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.knative.KnativeContext;
import org.ballerinax.kubernetes.models.knative.KnativeDataHolder;
import org.ballerinax.kubernetes.processors.KnativeAnnotationProcessorFactory;
import org.ballerinax.kubernetes.utils.DependencyValidator;
import org.ballerinax.kubernetes.utils.KnativeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

@SupportedAnnotationPackages(value={"ballerina/knative"})
public class KnativePlugin
extends AbstractCompilerPlugin {
    private static final Logger pluginLog = LoggerFactory.getLogger(KnativePlugin.class);
    private DiagnosticLog dlog;
    private SourceDirectory sourceDirectory;

    public void setCompilerContext(CompilerContext context) {
        this.sourceDirectory = (SourceDirectory)context.get(SourceDirectory.class);
        if (this.sourceDirectory == null) {
            throw new IllegalArgumentException("source directory has not been initialized");
        }
    }

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(PackageNode packageNode) {
        BLangPackage bPackage = (BLangPackage)packageNode;
        if (this.sourceDirectory == null) {
            throw new IllegalArgumentException("source directory has not been initialized");
        }
        KnativeContext.getInstance().addDataHolder(bPackage.packageID, this.sourceDirectory.getPath());
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        for (AnnotationAttachmentNode attachmentNode : annotations) {
            String annotationKey = attachmentNode.getAnnotationName().getValue();
            try {
                KnativeAnnotationProcessorFactory.getAnnotationProcessorInstance(annotationKey).processAnnotation(serviceNode, attachmentNode);
            }
            catch (KubernetesPluginException e) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)e.getMessage());
            }
        }
    }

    public void process(SimpleVariableNode variableNode, List<AnnotationAttachmentNode> annotations) {
        if (!variableNode.getFlags().contains(Flag.LISTENER)) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, variableNode.getPosition(), (CharSequence)"@kubernetes annotations are only supported with listeners.");
            return;
        }
        for (AnnotationAttachmentNode attachmentNode : annotations) {
            String annotationKey = attachmentNode.getAnnotationName().getValue();
            try {
                KnativeAnnotationProcessorFactory.getAnnotationProcessorInstance(annotationKey).processAnnotation(variableNode, attachmentNode);
            }
            catch (KubernetesPluginException e) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, variableNode.getPosition(), (CharSequence)e.getMessage());
            }
        }
    }

    public void process(FunctionNode functionNode, List<AnnotationAttachmentNode> annotations) {
        for (AnnotationAttachmentNode attachmentNode : annotations) {
            String annotationKey = attachmentNode.getAnnotationName().getValue();
            try {
                KnativeAnnotationProcessorFactory.getAnnotationProcessorInstance(annotationKey).processAnnotation(functionNode, attachmentNode);
            }
            catch (KubernetesPluginException e) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, functionNode.getPosition(), (CharSequence)e.getMessage());
            }
        }
    }

    public void codeGenerated(PackageID moduleID, Path executableJarFile) {
        KnativeContext.getInstance().setCurrentPackage(moduleID);
        KnativeDataHolder dataHolder = KnativeContext.getInstance().getDataHolder();
        if (dataHolder.isCanProcess()) {
            if ((executableJarFile = executableJarFile.toAbsolutePath()) != null && Files.exists(executableJarFile, new LinkOption[0])) {
                Path projectRoot;
                Path dockerOutputPath;
                Path parent = executableJarFile.getParent();
                Path kubernetesOutputPath = parent != null ? parent.resolve("kubernetes") : null;
                Path path = dockerOutputPath = parent != null ? parent.resolve("docker") : null;
                if (Files.exists(executableJarFile, new LinkOption[0]) && Files.exists((projectRoot = executableJarFile).resolve("Ballerina.toml"), new LinkOption[0])) {
                    dataHolder.setProject(true);
                    kubernetesOutputPath = projectRoot.resolve("target").resolve("kubernetes").resolve(DockerGenUtils.extractUberJarName(executableJarFile));
                    dockerOutputPath = projectRoot.resolve("target").resolve("docker").resolve(DockerGenUtils.extractUberJarName(executableJarFile));
                }
                dataHolder.setUberJarPath(executableJarFile);
                dataHolder.setK8sArtifactOutputPath(kubernetesOutputPath);
                dataHolder.setDockerArtifactOutputPath(dockerOutputPath);
                KnativeArtifactManager knativeArtifactManager = new KnativeArtifactManager();
                try {
                    KnativeUtils.deleteDirectory(kubernetesOutputPath);
                    knativeArtifactManager.populateDeploymentModel();
                    this.validateDeploymentDependencies();
                    knativeArtifactManager.createArtifacts();
                }
                catch (KubernetesPluginException e) {
                    String errorMessage = "module [" + moduleID + "] " + e.getMessage();
                    KnativeUtils.printError(errorMessage);
                    pluginLog.error(errorMessage, (Throwable)e);
                    try {
                        KnativeUtils.deleteDirectory(kubernetesOutputPath);
                    }
                    catch (KubernetesPluginException kubernetesPluginException) {}
                }
            } else {
                KnativeUtils.printError("error in resolving docker generation location.");
                pluginLog.error("error in resolving docker generation location.");
            }
        }
    }

    private void validateDeploymentDependencies() throws KubernetesPluginException {
        KnativeContext context = KnativeContext.getInstance();
        Map<PackageID, KnativeDataHolder> packageToDataHolderMap = context.getPackageIDtoDataHolderMap();
        DependencyValidator dependencyValidator = new DependencyValidator();
        for (KnativeDataHolder dataHolder : packageToDataHolderMap.values()) {
            ArrayList<String> dependencies = new ArrayList<String>();
            String currentDeployment = dataHolder.getServiceModel().getName();
            if (currentDeployment == null) {
                return;
            }
            dependencies.add(currentDeployment);
            Set<String> dependsOn = dataHolder.getServiceModel().getDependsOn();
            for (String listenerName : dependsOn) {
                String dependentDeployment = context.getDeploymentNameFromListener(listenerName);
                if (dependentDeployment == null) {
                    return;
                }
                if (!dependentDeployment.equals(currentDeployment)) {
                    dependencies.add(dependentDeployment);
                    continue;
                }
                throw new KubernetesPluginException("@kubernetes:Deployment{} contains cyclic dependencies");
            }
            String[] array = dependencies.toArray(new String[0]);
            if (dependencyValidator.validateDependency(array)) continue;
            throw new KubernetesPluginException("@kubernetes:Deployment{} contains cyclic dependencies");
        }
    }
}

