/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.PackageNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.ArtifactManager;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.KubernetesDataHolder;
import org.ballerinax.kubernetes.processors.AnnotationProcessorFactory;
import org.ballerinax.kubernetes.utils.DependencyValidator;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

@SupportedAnnotationPackages(value={"ballerina/kubernetes", "ballerina/istio", "ballerina/openshift"})
public class KubernetesPlugin
extends AbstractCompilerPlugin {
    private static final Logger pluginLog = LoggerFactory.getLogger(KubernetesPlugin.class);
    private DiagnosticLog dlog;
    private SourceDirectory sourceDirectory;

    public void setCompilerContext(CompilerContext context) {
        this.sourceDirectory = (SourceDirectory)context.get(SourceDirectory.class);
        if (this.sourceDirectory == null) {
            throw new IllegalArgumentException("source directory has not been initialized");
        }
    }

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(PackageNode packageNode) {
        BLangPackage bPackage = (BLangPackage)packageNode;
        KubernetesContext.getInstance().addDataHolder(bPackage.packageID, this.sourceDirectory.getPath());
        List kubernetesImports = bPackage.getImports().stream().filter(i -> i.symbol.toString().equals("ballerina/kubernetes") && i.getAlias().toString().equals("_")).collect(Collectors.toList());
        if (kubernetesImports.size() > 0) {
            for (BLangImportPackage kubernetesImport : kubernetesImports) {
                List topLevelNodes = bPackage.getCompilationUnits().stream().filter(cu -> cu.getName().equals(kubernetesImport.compUnit.getValue())).flatMap(cu -> cu.getTopLevelNodes().stream()).collect(Collectors.toList());
                List<ServiceNode> serviceNodes = topLevelNodes.stream().filter(tln -> tln instanceof ServiceNode).map(tln -> (ServiceNode)tln).collect(Collectors.toList());
                serviceNodes.forEach(sn -> this.process((ServiceNode)sn, Collections.singletonList(KubernetesUtils.createAnnotation("Deployment"))));
                for (ServiceNode serviceNode : serviceNodes) {
                    Optional<ExpressionNode> initListener = serviceNode.getAttachedExprs().stream().filter(aex -> aex instanceof BLangTypeInit).findAny();
                    if (!initListener.isPresent()) continue;
                    serviceNodes.forEach(sn -> this.process((ServiceNode)sn, Collections.singletonList(KubernetesUtils.createAnnotation("Service"))));
                }
                List listenerNamesToExpose = serviceNodes.stream().map(ServiceNode::getAttachedExprs).flatMap(Collection::stream).filter(aex -> aex instanceof BLangSimpleVarRef).map(aex -> (BLangSimpleVarRef)aex).map(BLangSimpleVarRef::toString).collect(Collectors.toList());
                topLevelNodes.stream().filter(tln -> tln instanceof SimpleVariableNode).map(tln -> (SimpleVariableNode)tln).filter(listener -> listenerNamesToExpose.contains(listener.getName().getValue())).forEach(listener -> this.process((SimpleVariableNode)listener, Collections.singletonList(KubernetesUtils.createAnnotation("Service"))));
                topLevelNodes.stream().filter(tln -> tln instanceof FunctionNode).map(tln -> (FunctionNode)tln).filter(fn -> "main".equals(fn.getName().getValue())).forEach(fn -> this.process((FunctionNode)fn, Collections.singletonList(KubernetesUtils.createAnnotation("Job"))));
            }
        }
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        for (AnnotationAttachmentNode attachmentNode : annotations) {
            String annotationKey = attachmentNode.getAnnotationName().getValue();
            try {
                AnnotationProcessorFactory.getAnnotationProcessorInstance(annotationKey).processAnnotation(serviceNode, attachmentNode);
            }
            catch (KubernetesPluginException e) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)e.getMessage());
            }
        }
    }

    public void process(SimpleVariableNode variableNode, List<AnnotationAttachmentNode> annotations) {
        if (!variableNode.getFlags().contains(Flag.LISTENER)) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, variableNode.getPosition(), (CharSequence)"@kubernetes annotations are only supported with listeners.");
            return;
        }
        for (AnnotationAttachmentNode attachmentNode : annotations) {
            String annotationKey = attachmentNode.getAnnotationName().getValue();
            try {
                AnnotationProcessorFactory.getAnnotationProcessorInstance(annotationKey).processAnnotation(variableNode, attachmentNode);
            }
            catch (KubernetesPluginException e) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, variableNode.getPosition(), (CharSequence)e.getMessage());
            }
        }
    }

    public void process(FunctionNode functionNode, List<AnnotationAttachmentNode> annotations) {
        for (AnnotationAttachmentNode attachmentNode : annotations) {
            String annotationKey = attachmentNode.getAnnotationName().getValue();
            try {
                AnnotationProcessorFactory.getAnnotationProcessorInstance(annotationKey).processAnnotation(functionNode, attachmentNode);
            }
            catch (KubernetesPluginException e) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, functionNode.getPosition(), (CharSequence)e.getMessage());
            }
        }
    }

    public void codeGenerated(PackageID moduleID, Path executableJarFile) {
        KubernetesContext.getInstance().setCurrentPackage(moduleID);
        KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();
        if (dataHolder.isCanProcess()) {
            if (null != (executableJarFile = executableJarFile.toAbsolutePath()).getParent() && Files.exists(executableJarFile.getParent(), new LinkOption[0])) {
                Path projectRoot;
                Path kubernetesOutputPath = executableJarFile.getParent().resolve("kubernetes");
                Path dockerOutputPath = executableJarFile.getParent().resolve("docker");
                if (null != executableJarFile.getParent().getParent().getParent() && Files.exists(executableJarFile.getParent().getParent().getParent(), new LinkOption[0]) && Files.exists((projectRoot = executableJarFile.getParent().getParent().getParent()).resolve("Ballerina.toml"), new LinkOption[0])) {
                    dataHolder.setProject(true);
                    kubernetesOutputPath = projectRoot.resolve("target").resolve("kubernetes").resolve(DockerGenUtils.extractUberJarName(executableJarFile));
                    dockerOutputPath = projectRoot.resolve("target").resolve("docker").resolve(DockerGenUtils.extractUberJarName(executableJarFile));
                }
                dataHolder.setUberJarPath(executableJarFile);
                dataHolder.setK8sArtifactOutputPath(kubernetesOutputPath);
                dataHolder.setDockerArtifactOutputPath(dockerOutputPath);
                ArtifactManager artifactManager = new ArtifactManager();
                try {
                    KubernetesUtils.deleteDirectory(kubernetesOutputPath);
                    artifactManager.populateDeploymentModel();
                    this.validateDeploymentDependencies();
                    artifactManager.createArtifacts();
                }
                catch (KubernetesPluginException e) {
                    String errorMessage = "module [" + moduleID + "] " + e.getMessage();
                    KubernetesUtils.printError(errorMessage);
                    pluginLog.error(errorMessage, (Throwable)e);
                    try {
                        KubernetesUtils.deleteDirectory(kubernetesOutputPath);
                    }
                    catch (KubernetesPluginException kubernetesPluginException) {}
                }
            } else {
                KubernetesUtils.printError("error in resolving docker generation location.");
                pluginLog.error("error in resolving docker generation location.");
            }
        }
    }

    private void validateDeploymentDependencies() throws KubernetesPluginException {
        KubernetesContext context = KubernetesContext.getInstance();
        Map<PackageID, KubernetesDataHolder> packageToDataHolderMap = context.getPackageIDtoDataHolderMap();
        DependencyValidator dependencyValidator = new DependencyValidator();
        for (KubernetesDataHolder dataHolder : packageToDataHolderMap.values()) {
            ArrayList<String> dependencies = new ArrayList<String>();
            String currentDeployment = dataHolder.getDeploymentModel().getName();
            if (currentDeployment == null) {
                return;
            }
            dependencies.add(currentDeployment);
            Set<String> dependsOn = dataHolder.getDeploymentModel().getDependsOn();
            for (String listenerName : dependsOn) {
                String dependentDeployment = context.getDeploymentNameFromListener(listenerName);
                if (dependentDeployment == null) {
                    return;
                }
                if (!dependentDeployment.equals(currentDeployment)) {
                    dependencies.add(dependentDeployment);
                    continue;
                }
                throw new KubernetesPluginException("@kubernetes:Deployment{} contains cyclic dependencies");
            }
            String[] array = dependencies.toArray(new String[0]);
            if (dependencyValidator.validateDependency(array)) continue;
            throw new KubernetesPluginException("@kubernetes:Deployment{} contains cyclic dependencies");
        }
    }
}

