/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProjectedVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import io.fabric8.kubernetes.api.model.TCPSocketActionBuilder;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TolerationBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeProjection;
import io.fabric8.kubernetes.api.model.VolumeProjectionFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ballerinax.docker.generator.exceptions.DockerGenException;
import org.ballerinax.docker.generator.models.DockerModel;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.ConfigMapModel;
import org.ballerinax.kubernetes.models.DeploymentModel;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.PersistentVolumeClaimModel;
import org.ballerinax.kubernetes.models.PodTolerationModel;
import org.ballerinax.kubernetes.models.ProbeModel;
import org.ballerinax.kubernetes.models.SecretModel;
import org.ballerinax.kubernetes.models.ServiceAccountTokenModel;
import org.ballerinax.kubernetes.models.openshift.OpenShiftBuildExtensionModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class DeploymentHandler
extends AbstractArtifactHandler {
    private List<ContainerPort> populatePorts(Set<Integer> ports) {
        ArrayList<ContainerPort> containerPorts = new ArrayList<ContainerPort>();
        for (int port : ports) {
            ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withContainerPort(port)).withProtocol("TCP")).build();
            containerPorts.add(containerPort);
        }
        return containerPorts;
    }

    private List<VolumeMount> populateVolumeMounts(DeploymentModel deploymentModel) {
        VolumeMount volumeMount;
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        for (SecretModel secretModel : deploymentModel.getSecretModels()) {
            volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(secretModel.getMountPath())).withName(secretModel.getName() + "-volume")).withReadOnly(secretModel.isReadOnly())).build();
            volumeMounts.add(volumeMount);
        }
        for (ConfigMapModel configMapModel : deploymentModel.getConfigMapModels()) {
            volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(configMapModel.getMountPath())).withName(configMapModel.getName() + "-volume")).withReadOnly(configMapModel.isReadOnly())).build();
            volumeMounts.add(volumeMount);
        }
        for (ServiceAccountTokenModel serviceAccountTokenModel : deploymentModel.getServiceAccountTokenModel()) {
            volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(serviceAccountTokenModel.getMountPath())).withName(serviceAccountTokenModel.getName() + "-volume")).build();
            volumeMounts.add(volumeMount);
        }
        for (PersistentVolumeClaimModel persistentVolumeClaimModel : deploymentModel.getVolumeClaimModels()) {
            volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(persistentVolumeClaimModel.getMountPath())).withName(persistentVolumeClaimModel.getName() + "-volume")).withReadOnly(persistentVolumeClaimModel.isReadOnly())).build();
            volumeMounts.add(volumeMount);
        }
        return volumeMounts;
    }

    private List<Container> generateInitContainer(DeploymentModel deploymentModel) throws KubernetesPluginException {
        ArrayList<Container> initContainers = new ArrayList<Container>();
        for (String dependsOn : deploymentModel.getDependsOn()) {
            String serviceName = KubernetesContext.getInstance().getServiceName(dependsOn);
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("sh");
            commands.add("-c");
            commands.add("until nslookup " + serviceName + "; do echo waiting for " + serviceName + "; sleep 2; done;");
            initContainers.add(((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("wait-for-" + serviceName)).withImage("busybox")).withCommand(commands)).build());
        }
        return initContainers;
    }

    private Container generateContainer(DeploymentModel deploymentModel, List<ContainerPort> containerPorts) throws KubernetesPluginException {
        String dockerRegistry = deploymentModel.getRegistry();
        String deploymentImageName = deploymentModel.getImage();
        if (null != dockerRegistry && !"".equals(dockerRegistry)) {
            deploymentImageName = dockerRegistry + "/" + deploymentImageName;
        }
        if (deploymentModel.getBuildExtension() != null && deploymentModel.getBuildExtension() instanceof OpenShiftBuildExtensionModel) {
            OpenShiftBuildExtensionModel openShiftBC = (OpenShiftBuildExtensionModel)deploymentModel.getBuildExtension();
            openShiftBC.setName(deploymentModel.getName().replace("-deployment", "-openshift-bc"));
            this.dataHolder.setOpenShiftBuildExtensionModel(openShiftBC);
            dockerRegistry = deploymentModel.getRegistry();
            if (dockerRegistry == null || "".equals(dockerRegistry.trim())) {
                throw new KubernetesPluginException("value for 'registry' field in @kubernetes:Deployment{} annotation is required to generate OpenShift Build Configs.");
            }
            String namespace = this.dataHolder.getNamespace();
            if (namespace == null || "".equals(namespace.trim())) {
                throw new KubernetesPluginException("value for 'namespace' field in @kubernetes:Deployment{} annotation is required to generate OpenShift Build Configs. use the value of the OpenShift project name.");
            }
            deploymentImageName = dockerRegistry + "/" + namespace + "/" + deploymentModel.getImage();
        }
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(deploymentModel.getName())).withImage(deploymentImageName)).withImagePullPolicy(deploymentModel.getImagePullPolicy())).withPorts(containerPorts)).withEnv(KubernetesUtils.populateEnvVar(deploymentModel.getEnv()))).withVolumeMounts(this.populateVolumeMounts(deploymentModel))).withLivenessProbe(this.generateProbe(deploymentModel.getLivenessProbe()))).withReadinessProbe(this.generateProbe(deploymentModel.getReadinessProbe()))).build();
    }

    private List<Volume> populateVolume(DeploymentModel deploymentModel) {
        Volume volume;
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        for (SecretModel secretModel : deploymentModel.getSecretModels()) {
            volume = ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeBuilder)new VolumeBuilder().withName(secretModel.getName() + "-volume")).withNewSecret().withSecretName(secretModel.getName())).endSecret()).build();
            if (secretModel.getDefaultMode() > 0) {
                volume.getSecret().setDefaultMode(secretModel.getDefaultMode());
            }
            volumes.add(volume);
        }
        for (ConfigMapModel configMapModel : deploymentModel.getConfigMapModels()) {
            volume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName(configMapModel.getName() + "-volume")).withNewConfigMap().withName(configMapModel.getName())).endConfigMap()).build();
            if (configMapModel.getDefaultMode() > 0) {
                volume.getConfigMap().setDefaultMode(configMapModel.getDefaultMode());
            }
            volumes.add(volume);
        }
        for (PersistentVolumeClaimModel persistentVolumeClaimModel : deploymentModel.getVolumeClaimModels()) {
            volume = ((VolumeBuilder)((VolumeFluent.PersistentVolumeClaimNested)((VolumeBuilder)new VolumeBuilder().withName(persistentVolumeClaimModel.getName() + "-volume")).withNewPersistentVolumeClaim().withClaimName(persistentVolumeClaimModel.getName())).endPersistentVolumeClaim()).build();
            volumes.add(volume);
        }
        for (ServiceAccountTokenModel serviceAccountTokenModel : deploymentModel.getServiceAccountTokenModel()) {
            volume = ((VolumeBuilder)((VolumeFluent.ProjectedNested)((ProjectedVolumeSourceFluent.SourcesNested)((VolumeProjectionFluent.ServiceAccountTokenNested)((VolumeProjectionFluent.ServiceAccountTokenNested)((VolumeProjectionFluent.ServiceAccountTokenNested)((VolumeFluent.ProjectedNested)((VolumeBuilder)new VolumeBuilder().withName(serviceAccountTokenModel.getName() + "-volume")).withNewProjected().withSources(new VolumeProjection[0])).addNewSource().withNewServiceAccountToken().withAudience(serviceAccountTokenModel.getAudience())).withPath(serviceAccountTokenModel.getName() + "-volume")).withExpirationSeconds(Long.valueOf(serviceAccountTokenModel.getExpirationSeconds()))).endServiceAccountToken()).endSource()).endProjected()).build();
            volumes.add(volume);
        }
        return volumes;
    }

    private Probe generateProbe(ProbeModel probeModel) {
        if (null == probeModel) {
            return null;
        }
        TCPSocketAction tcpSocketAction = ((TCPSocketActionBuilder)new TCPSocketActionBuilder().withNewPort(probeModel.getPort())).build();
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withInitialDelaySeconds(probeModel.getInitialDelaySeconds())).withPeriodSeconds(probeModel.getPeriodSeconds())).withTcpSocket(tcpSocketAction)).build();
    }

    private List<Toleration> populatePodTolerations(List<PodTolerationModel> podTolerationModels) {
        LinkedList<Toleration> tolerations = null;
        if (null != podTolerationModels && podTolerationModels.size() > 0) {
            tolerations = new LinkedList<Toleration>();
            for (PodTolerationModel podTolerationModel : podTolerationModels) {
                Toleration toleration = ((TolerationBuilder)((TolerationBuilder)((TolerationBuilder)((TolerationBuilder)((TolerationBuilder)new TolerationBuilder().withKey(podTolerationModel.getKey())).withOperator(podTolerationModel.getOperator())).withValue(podTolerationModel.getValue())).withEffect(podTolerationModel.getEffect())).withTolerationSeconds(Long.valueOf(podTolerationModel.getTolerationSeconds()))).build();
                tolerations.add(toleration);
            }
        }
        return tolerations;
    }

    private List<LocalObjectReference> getImagePullSecrets(DeploymentModel deploymentModel) {
        ArrayList<LocalObjectReference> imagePullSecrets = new ArrayList<LocalObjectReference>();
        for (String imagePullSecret : deploymentModel.getImagePullSecrets()) {
            imagePullSecrets.add(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(imagePullSecret)).build());
        }
        return imagePullSecrets;
    }

    private void generate(DeploymentModel deploymentModel) throws KubernetesPluginException {
        List<ContainerPort> containerPorts = null;
        if (deploymentModel.getPorts() != null) {
            containerPorts = this.populatePorts(deploymentModel.getPorts());
        }
        Container container = this.generateContainer(deploymentModel, containerPorts);
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(deploymentModel.getName())).withLabels(deploymentModel.getLabels())).withAnnotations(deploymentModel.getAnnotations())).withNamespace(this.dataHolder.getNamespace())).endMetadata()).withNewSpec().withNewSelector().withMatchLabels(deploymentModel.getLabels())).endSelector()).withStrategy(deploymentModel.getStrategy())).withReplicas(deploymentModel.getReplicas())).withNewTemplate().withNewMetadata().addToLabels(deploymentModel.getLabels())).addToAnnotations(deploymentModel.getPodAnnotations())).endMetadata()).withNewSpec().withServiceAccountName(deploymentModel.getServiceAccountName())).withContainers(container)).withImagePullSecrets(this.getImagePullSecrets(deploymentModel))).withInitContainers(this.generateInitContainer(deploymentModel))).withVolumes(this.populateVolume(deploymentModel))).withTolerations(this.populatePodTolerations(deploymentModel.getPodTolerations()))).withNodeSelector(deploymentModel.getNodeSelector())).endSpec()).endTemplate()).endSpec()).build();
        try {
            String deploymentContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(deployment);
            KubernetesUtils.writeToFile(deploymentContent, "_deployment.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for deployment: " + deploymentModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        try {
            DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
            deploymentModel.setPodAutoscalerModel(this.dataHolder.getPodAutoscalerModel());
            deploymentModel.setSecretModels(this.dataHolder.getSecretModelSet());
            deploymentModel.setConfigMapModels(this.dataHolder.getConfigMapModelSet());
            deploymentModel.setVolumeClaimModels(this.dataHolder.getVolumeClaimModelSet());
            if (null != deploymentModel.getLivenessProbe() && deploymentModel.getLivenessProbe().getPort() == 0) {
                if (deploymentModel.getPorts().size() == 0) {
                    throw new KubernetesPluginException("unable to detect port for liveness probe.missing @kubernetes:Service annotation on listener.");
                }
                deploymentModel.getLivenessProbe().setPort(deploymentModel.getPorts().iterator().next());
            }
            if (null != deploymentModel.getReadinessProbe() && deploymentModel.getReadinessProbe().getPort() == 0) {
                if (deploymentModel.getPorts().size() == 0) {
                    throw new KubernetesPluginException("unable to detect port for readiness probe. missing @kubernetes:Service annotation on listener.");
                }
                deploymentModel.getReadinessProbe().setPort(deploymentModel.getPorts().iterator().next());
            }
            this.generate(deploymentModel);
            OUT.println();
            OUT.print("\t@kubernetes:Deployment \t\t\t - complete 1/1");
            this.dataHolder.setDockerModel(this.getDockerModel(deploymentModel));
        }
        catch (DockerGenException e) {
            throw new KubernetesPluginException("error occurred creating docker image.", e);
        }
    }

    private DockerModel getDockerModel(DeploymentModel deploymentModel) throws DockerGenException {
        DockerModel dockerModel = new DockerModel();
        String dockerImage = deploymentModel.getImage();
        String imageTag = "latest";
        if (dockerImage.contains(":")) {
            imageTag = dockerImage.substring(dockerImage.lastIndexOf(":") + 1);
            dockerImage = dockerImage.substring(0, dockerImage.lastIndexOf(":"));
        }
        dockerModel.setBaseImage(deploymentModel.getBaseImage());
        dockerModel.setRegistry(deploymentModel.getRegistry());
        dockerModel.setName(dockerImage);
        dockerModel.setTag(imageTag);
        dockerModel.setEnableDebug(false);
        dockerModel.setUsername(deploymentModel.getUsername());
        dockerModel.setPassword(deploymentModel.getPassword());
        dockerModel.setPush(deploymentModel.isPush());
        if (KubernetesUtils.isBlank(deploymentModel.getCmd()) && deploymentModel.isPrometheus()) {
            deploymentModel.setCmd("CMD java -jar ${APP} --b7a.observability.enabled=true --b7a.observability.metrics.prometheus.port=" + deploymentModel.getPrometheusPort());
        }
        dockerModel.setCmd(deploymentModel.getCmd());
        dockerModel.setUberJarFileName(DockerGenUtils.extractUberJarName(this.dataHolder.getUberJarPath()) + ".jar");
        dockerModel.setPorts(deploymentModel.getPorts());
        dockerModel.setService(true);
        dockerModel.setDockerHost(deploymentModel.getDockerHost());
        dockerModel.setDockerCertPath(deploymentModel.getDockerCertPath());
        dockerModel.setBuildImage(deploymentModel.isBuildImage());
        dockerModel.addCommandArg(deploymentModel.getCommandArgs());
        dockerModel.setCopyFiles(deploymentModel.getCopyFiles());
        return dockerModel;
    }
}

