/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers;

import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.DeploymentModel;
import org.ballerinax.kubernetes.models.PodAutoscalerModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class HPAHandler
extends AbstractArtifactHandler {
    private void generate(PodAutoscalerModel podAutoscalerModel) throws KubernetesPluginException {
        HorizontalPodAutoscaler horizontalPodAutoscaler = ((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.MetadataNested)((HorizontalPodAutoscalerFluent.MetadataNested)((HorizontalPodAutoscalerFluent.MetadataNested)new HorizontalPodAutoscalerBuilder().withNewMetadata().withName(podAutoscalerModel.getName())).withNamespace(this.dataHolder.getNamespace())).withLabels(podAutoscalerModel.getLabels())).endMetadata()).withNewSpec().withMaxReplicas(podAutoscalerModel.getMaxReplicas())).withMinReplicas(podAutoscalerModel.getMinReplicas())).withTargetCPUUtilizationPercentage(podAutoscalerModel.getCpuPercentage())).withNewScaleTargetRef("apps/v1", "Deployment", podAutoscalerModel.getDeployment())).endSpec()).build();
        try {
            String serviceContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(horizontalPodAutoscaler);
            KubernetesUtils.writeToFile(serviceContent, "_hpa.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for autoscaler: " + podAutoscalerModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
        PodAutoscalerModel podAutoscalerModel = deploymentModel.getPodAutoscalerModel();
        if (podAutoscalerModel == null) {
            return;
        }
        String balxFileName = DockerGenUtils.extractUberJarName(this.dataHolder.getUberJarPath());
        podAutoscalerModel.addLabel("app", balxFileName);
        podAutoscalerModel.setDeployment(deploymentModel.getName());
        if (podAutoscalerModel.getMaxReplicas() == 0) {
            podAutoscalerModel.setMaxReplicas(deploymentModel.getReplicas() + 1);
        }
        if (podAutoscalerModel.getMinReplicas() == 0) {
            podAutoscalerModel.setMinReplicas(deploymentModel.getReplicas());
        }
        if (podAutoscalerModel.getName() == null || podAutoscalerModel.getName().length() == 0) {
            podAutoscalerModel.setName(KubernetesUtils.getValidName(balxFileName) + "-hpa");
        }
        this.generate(podAutoscalerModel);
        OUT.println();
        OUT.print("\t@kubernetes:HPA \t\t\t - complete 1/1");
    }
}

