/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers;

import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.ResourceQuotaModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class ResourceQuotaHandler
extends AbstractArtifactHandler {
    private void generate(ResourceQuotaModel resourceQuotaModel) throws KubernetesPluginException {
        ResourceQuota resourceQuota = ((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)((ResourceQuotaFluent.MetadataNested)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName(resourceQuotaModel.getName())).withLabels(resourceQuotaModel.getLabels())).withAnnotations(resourceQuotaModel.getAnnotations())).endMetadata()).withNewSpec().withHard(this.getHard(resourceQuotaModel.getHard()))).withScopes(new ArrayList<String>(resourceQuotaModel.getScopes()))).endSpec()).build();
        try {
            String resourceQuotaContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(resourceQuota);
            KubernetesUtils.writeToFile(resourceQuotaContent, "_resource_quota.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for resource quotas: " + resourceQuotaModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    private Map<String, Quantity> getHard(Map<String, String> hard) {
        HashMap<String, Quantity> quantityMap = new HashMap<String, Quantity>();
        hard.forEach((key, value) -> {
            if (key.endsWith("memory")) {
                quantityMap.put((String)key, ((QuantityBuilder)((QuantityBuilder)new QuantityBuilder().withAmount(value.replaceAll("\\D+", ""))).withFormat(value.replaceAll("\\d", ""))).build());
            } else {
                quantityMap.put((String)key, ((QuantityBuilder)new QuantityBuilder().withAmount((String)value)).build());
            }
        });
        return quantityMap;
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        int count = 0;
        Set<ResourceQuotaModel> resourceQuotas = this.dataHolder.getResourceQuotaModels();
        if (resourceQuotas.size() > 0) {
            OUT.println();
        }
        for (ResourceQuotaModel resourceQuotaModel : resourceQuotas) {
            this.generate(resourceQuotaModel);
            OUT.print("\t@kubernetes:ResourceQuota \t\t - complete " + ++count + "/" + resourceQuotas.size() + "\r");
        }
    }
}

