/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.Set;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.DeploymentModel;
import org.ballerinax.kubernetes.models.EnvVarValueModel;
import org.ballerinax.kubernetes.models.SecretModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class SecretHandler
extends AbstractArtifactHandler {
    private void generate(SecretModel secretModel) throws KubernetesPluginException {
        Secret secret = ((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withNamespace(this.dataHolder.getNamespace())).withName(secretModel.getName())).endMetadata()).withData(secretModel.getData())).build();
        try {
            String secretContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(secret);
            KubernetesUtils.writeToFile(secretContent, "_secret.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for secret: " + secretModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        int count = 0;
        Set<SecretModel> secretModels = this.dataHolder.getSecretModelSet();
        if (secretModels.size() > 0) {
            OUT.println();
        }
        for (SecretModel secretModel : secretModels) {
            ++count;
            if (!KubernetesUtils.isBlank(secretModel.getBallerinaConf())) {
                if (secretModel.getData().size() != 1) {
                    throw new KubernetesPluginException("there can be only 1 ballerina config file");
                }
                DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
                deploymentModel.setCommandArgs(" --b7a.config.file=${CONFIG_FILE}");
                EnvVarValueModel envVarValueModel = new EnvVarValueModel(secretModel.getMountPath() + "ballerina.conf");
                deploymentModel.addEnv("CONFIG_FILE", envVarValueModel);
                this.dataHolder.setDeploymentModel(deploymentModel);
            }
            this.generate(secretModel);
            OUT.print("\t@kubernetes:Secret \t\t\t - complete " + count + "/" + secretModels.size() + "\r");
        }
    }
}

