/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers.knative;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.Set;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.knative.KnativeAbstractArtifactHandler;
import org.ballerinax.kubernetes.models.knative.ConfigMapModel;
import org.ballerinax.kubernetes.models.knative.EnvVarValueModel;
import org.ballerinax.kubernetes.models.knative.ServiceModel;
import org.ballerinax.kubernetes.utils.KnativeUtils;

public class KnativeConfigMapHandler
extends KnativeAbstractArtifactHandler {
    private void generate(ConfigMapModel configMapModel) throws KubernetesPluginException {
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapModel.getName())).withNamespace(this.knativeDataHolder.getNamespace())).endMetadata()).withData(configMapModel.getData())).build();
        try {
            String configMapContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(configMap);
            KnativeUtils.writeToFile(configMapContent, "_config_map.yaml");
        }
        catch (IOException e) {
            String errorMessage = "Error while parsing yaml file for config map: " + configMapModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        int count = 0;
        Set<ConfigMapModel> configMapModels = this.knativeDataHolder.getConfigMapModelSet();
        if (configMapModels.size() > 0) {
            OUT.println();
        }
        for (ConfigMapModel configMapModel : configMapModels) {
            ++count;
            if (!KnativeUtils.isBlank(configMapModel.getBallerinaConf())) {
                if (configMapModel.getData().size() != 1) {
                    throw new KubernetesPluginException("there can be only 1 ballerina config file");
                }
                ServiceModel serviceModel = this.knativeDataHolder.getServiceModel();
                serviceModel.setCommandArgs(" --b7a.config.file=${CONFIG_FILE}");
                EnvVarValueModel envVarValueModel = new EnvVarValueModel(configMapModel.getMountPath() + "ballerina.conf");
                serviceModel.addEnv("CONFIG_FILE", envVarValueModel);
                this.knativeDataHolder.setServiceModel(serviceModel);
            }
            this.generate(configMapModel);
            OUT.print("\t@knative:ConfigMap \t\t\t - complete " + count + "/" + configMapModels.size() + "\r");
        }
    }
}

