/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers.knative;

import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.knative.KnativeAbstractArtifactHandler;
import org.ballerinax.kubernetes.models.knative.ResourceQuotaModel;
import org.ballerinax.kubernetes.utils.KnativeUtils;

public class KnativeResourceQuotaHandler
extends KnativeAbstractArtifactHandler {
    private void generate(ResourceQuotaModel resourceQuotaModel) throws KubernetesPluginException {
        ResourceQuota resourceQuota = ((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)((ResourceQuotaFluent.MetadataNested)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName(resourceQuotaModel.getName())).withLabels(resourceQuotaModel.getLabels())).withAnnotations(resourceQuotaModel.getAnnotations())).endMetadata()).withNewSpec().withHard(this.getHard(resourceQuotaModel.getHard()))).withScopes(new ArrayList<String>(resourceQuotaModel.getScopes()))).endSpec()).build();
        try {
            String resourceQuotaContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(resourceQuota);
            KnativeUtils.writeToFile(resourceQuotaContent, "_resource_quota.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for resource quotas: " + resourceQuotaModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    private Map<String, Quantity> getHard(Map<String, String> hard) {
        return hard.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, hardEntry -> ((QuantityBuilder)new QuantityBuilder().withAmount((String)hardEntry.getValue())).build()));
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        int count = 0;
        Set<ResourceQuotaModel> resourceQuotas = this.knativeDataHolder.getResourceQuotaModels();
        if (resourceQuotas.size() > 0) {
            OUT.println();
        }
        for (ResourceQuotaModel resourceQuotaModel : resourceQuotas) {
            this.generate(resourceQuotaModel);
            OUT.print("\t@kubernetes:ResourceQuota \t\t - complete " + ++count + "/" + resourceQuotas.size() + "\r");
        }
    }
}

