/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers.knative;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import io.fabric8.kubernetes.api.model.TCPSocketActionBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ballerinax.docker.generator.exceptions.DockerGenException;
import org.ballerinax.docker.generator.models.DockerModel;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.knative.KnativeAbstractArtifactHandler;
import org.ballerinax.kubernetes.models.knative.ConfigMapModel;
import org.ballerinax.kubernetes.models.knative.KnativeContext;
import org.ballerinax.kubernetes.models.knative.KnativeService;
import org.ballerinax.kubernetes.models.knative.ProbeModel;
import org.ballerinax.kubernetes.models.knative.SecretModel;
import org.ballerinax.kubernetes.models.knative.ServiceModel;
import org.ballerinax.kubernetes.specs.KnativePodSpec;
import org.ballerinax.kubernetes.specs.KnativePodTemplateSpec;
import org.ballerinax.kubernetes.specs.KnativeServiceSpec;
import org.ballerinax.kubernetes.utils.KnativeUtils;

public class KnativeServiceHandler
extends KnativeAbstractArtifactHandler {
    private List<ContainerPort> populatePorts(Set<Integer> ports) {
        ArrayList<ContainerPort> containerPorts = new ArrayList<ContainerPort>();
        for (int port : ports) {
            ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withContainerPort(port)).withProtocol("TCP")).build();
            containerPorts.add(containerPort);
        }
        return containerPorts;
    }

    private List<VolumeMount> populateVolumeMounts(ServiceModel serviceModel) {
        VolumeMount volumeMount;
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        for (SecretModel secretModel : serviceModel.getSecretModels()) {
            volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(secretModel.getMountPath())).withName(secretModel.getName() + "-volume")).withReadOnly(secretModel.isReadOnly())).build();
            volumeMounts.add(volumeMount);
        }
        for (ConfigMapModel configMapModel : serviceModel.getConfigMapModels()) {
            volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(configMapModel.getMountPath())).withName(configMapModel.getName() + "-volume")).withReadOnly(configMapModel.isReadOnly())).build();
            volumeMounts.add(volumeMount);
        }
        return volumeMounts;
    }

    private List<Container> generateInitContainer(ServiceModel serviceModel) throws KubernetesPluginException {
        ArrayList<Container> initContainers = new ArrayList<Container>();
        for (String dependsOn : serviceModel.getDependsOn()) {
            String serviceName = KnativeContext.getInstance().getServiceName(dependsOn);
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("sh");
            commands.add("-c");
            commands.add("until nslookup " + serviceName + "; do echo waiting for " + serviceName + "; sleep 2; done;");
            initContainers.add(((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("wait-for-" + serviceName)).withImage("busybox")).withCommand(commands)).build());
        }
        return initContainers;
    }

    private Container generateContainer(ServiceModel serviceModel, List<ContainerPort> containerPorts) throws KubernetesPluginException {
        String dockerRegistry = serviceModel.getRegistry();
        String deploymentImageName = serviceModel.getImage();
        if (null != dockerRegistry && !"".equals(dockerRegistry)) {
            deploymentImageName = dockerRegistry + "/" + deploymentImageName;
        }
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(serviceModel.getName())).withImage(deploymentImageName)).withPorts(containerPorts)).withEnv(KnativeUtils.populateEnvVar(serviceModel.getEnv()))).withVolumeMounts(this.populateVolumeMounts(serviceModel))).withLivenessProbe(this.generateProbe(serviceModel.getLivenessProbe()))).withReadinessProbe(this.generateProbe(serviceModel.getReadinessProbe()))).build();
    }

    private List<Volume> populateVolume(ServiceModel serviceModel) {
        Volume volume;
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        for (SecretModel secretModel : serviceModel.getSecretModels()) {
            volume = ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeBuilder)new VolumeBuilder().withName(secretModel.getName() + "-volume")).withNewSecret().withSecretName(secretModel.getName())).endSecret()).build();
            volumes.add(volume);
        }
        for (ConfigMapModel configMapModel : serviceModel.getConfigMapModels()) {
            volume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName(configMapModel.getName() + "-volume")).withNewConfigMap().withName(configMapModel.getName())).endConfigMap()).build();
            volumes.add(volume);
        }
        return volumes;
    }

    private Probe generateProbe(ProbeModel probeModel) {
        if (null == probeModel) {
            return null;
        }
        TCPSocketAction tcpSocketAction = ((TCPSocketActionBuilder)new TCPSocketActionBuilder().withNewPort(probeModel.getPort())).build();
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withInitialDelaySeconds(probeModel.getInitialDelaySeconds())).withPeriodSeconds(probeModel.getPeriodSeconds())).withTcpSocket(tcpSocketAction)).build();
    }

    private void generate(ServiceModel serviceModel) throws KubernetesPluginException {
        List<ContainerPort> containerPorts = null;
        if (serviceModel.getPorts() != null) {
            containerPorts = this.populatePorts(serviceModel.getPorts());
        }
        Container container = this.generateContainer(serviceModel, containerPorts);
        ObjectMeta metaData = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(serviceModel.getName())).withNamespace(this.knativeDataHolder.getNamespace())).build();
        KnativeService knativeServiceBuild = new KnativeService();
        knativeServiceBuild.setMetadata(metaData);
        KnativeServiceSpec knativeServiceSpec = new KnativeServiceSpec();
        KnativePodSpec knativePodSpec = new KnativePodSpec();
        knativePodSpec.setContainerConcurrency(serviceModel.getContainerConcurrency());
        knativePodSpec.setContainers(Collections.singletonList(container));
        knativePodSpec.setInitContainers(this.generateInitContainer(serviceModel));
        knativePodSpec.setVolumes(this.populateVolume(serviceModel));
        KnativePodTemplateSpec knativePodTemplateSpec = new KnativePodTemplateSpec();
        knativePodTemplateSpec.setMetadata(null);
        knativePodTemplateSpec.setSpec(knativePodSpec);
        knativeServiceSpec.setTemplate(knativePodTemplateSpec);
        knativeServiceBuild.setSpec(knativeServiceSpec);
        try {
            String deploymentContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(knativeServiceBuild);
            KnativeUtils.writeToFile(deploymentContent, "_deployment.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating yaml file for deployment: " + serviceModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        try {
            ServiceModel serviceModel = this.knativeDataHolder.getServiceModel();
            serviceModel.setPodAutoscalerModel(this.knativeDataHolder.getPodAutoscalerModel());
            serviceModel.setSecretModels(this.knativeDataHolder.getSecretModelSet());
            serviceModel.setConfigMapModels(this.knativeDataHolder.getConfigMapModelSet());
            if (null != serviceModel.getLivenessProbe() && serviceModel.getLivenessProbe().getPort() == 0) {
                serviceModel.getLivenessProbe().setPort(serviceModel.getPorts().iterator().next());
            }
            if (null != serviceModel.getReadinessProbe() && serviceModel.getReadinessProbe().getPort() == 0) {
                serviceModel.getReadinessProbe().setPort(serviceModel.getPorts().iterator().next());
            }
            this.generate(serviceModel);
            OUT.println();
            OUT.print("\t@knative:Service \t\t\t - complete 1/1");
            this.knativeDataHolder.setDockerModel(this.getDockerModel(serviceModel));
        }
        catch (DockerGenException e) {
            throw new KubernetesPluginException("error occurred creating docker image.", e);
        }
    }

    private DockerModel getDockerModel(ServiceModel serviceModel) throws DockerGenException {
        DockerModel dockerModel = new DockerModel();
        String dockerImage = serviceModel.getImage();
        String imageTag = "latest";
        if (dockerImage.contains(":")) {
            imageTag = dockerImage.substring(dockerImage.lastIndexOf(":") + 1);
            dockerImage = dockerImage.substring(0, dockerImage.lastIndexOf(":"));
        }
        dockerModel.setBaseImage(serviceModel.getBaseImage());
        dockerModel.setRegistry(serviceModel.getRegistry());
        dockerModel.setName(dockerImage);
        dockerModel.setTag(imageTag);
        dockerModel.setEnableDebug(false);
        dockerModel.setUsername(serviceModel.getUsername());
        dockerModel.setPassword(serviceModel.getPassword());
        dockerModel.setPush(serviceModel.isPush());
        dockerModel.setUberJarFileName(DockerGenUtils.extractUberJarName(this.knativeDataHolder.getUberJarPath()) + ".jar");
        dockerModel.setPorts(serviceModel.getPorts());
        dockerModel.setService(true);
        dockerModel.setDockerHost(serviceModel.getDockerHost());
        dockerModel.setDockerCertPath(serviceModel.getDockerCertPath());
        dockerModel.setBuildImage(serviceModel.isBuildImage());
        dockerModel.addCommandArg(serviceModel.getCommandArgs());
        dockerModel.setCopyFiles(serviceModel.getCopyFiles());
        return dockerModel;
    }
}

