/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers.openshift;

import io.fabric8.kubernetes.client.internal.SerializationUtils;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.openshift.OpenShiftBuildExtensionModel;
import org.ballerinax.kubernetes.utils.DockerImageName;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class OpenShiftImageStreamHandler
extends AbstractArtifactHandler {
    @Override
    public void createArtifacts() throws KubernetesPluginException {
        OpenShiftBuildExtensionModel buildConfigModel = this.dataHolder.getOpenShiftBuildExtensionModel();
        if (null != buildConfigModel) {
            this.generate(buildConfigModel);
            OUT.println();
            OUT.print("\t@openshift:ImageStream \t\t\t - complete 1/1");
        }
    }

    private void generate(OpenShiftBuildExtensionModel buildConfigModel) throws KubernetesPluginException {
        try {
            buildConfigModel.setLabels(new LinkedHashMap<String, String>());
            if (null != buildConfigModel.getLabels() && !buildConfigModel.getLabels().containsKey("build")) {
                buildConfigModel.getLabels().put("build", buildConfigModel.getName());
            }
            String dockerImageName = new DockerImageName(this.dataHolder.getDockerModel().getName()).getRepository();
            ImageStream is = ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(dockerImageName)).withLabels(buildConfigModel.getLabels())).withAnnotations(buildConfigModel.getAnnotations())).withNamespace(this.dataHolder.getNamespace())).endMetadata()).build();
            String resourceQuotaContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(is);
            KubernetesUtils.writeToFile(this.dataHolder.getK8sArtifactOutputPath().resolve("openshift"), resourceQuotaContent, "_openshift_is.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating OpenShift Image Stream yaml file: " + buildConfigModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }
}

