/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers.openshift;

import io.fabric8.kubernetes.client.internal.SerializationUtils;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.io.IOException;
import java.util.Map;
import org.ballerinax.kubernetes.ArtifactManager;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.ServiceModel;
import org.ballerinax.kubernetes.models.openshift.OpenShiftRouteModel;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class OpenShiftRouteHandler
extends AbstractArtifactHandler {
    @Override
    public void createArtifacts() throws KubernetesPluginException {
        Map<String, OpenShiftRouteModel> routeModels = this.dataHolder.getOpenShiftRouteModels();
        int size = routeModels.size();
        if (size > 0) {
            OUT.println();
            Map<String, String> instructions = ArtifactManager.getInstructions();
            instructions.put("\tRun the following command to deploy the OpenShift artifacts: ", "\toc apply -f " + this.dataHolder.getK8sArtifactOutputPath().resolve("openshift").toAbsolutePath());
            instructions.put("\tRun the following command to deploy the Kubernetes artifacts: ", "\tkubectl apply -f " + this.dataHolder.getK8sArtifactOutputPath());
        }
        int count = 0;
        for (Map.Entry<String, OpenShiftRouteModel> routeModel : routeModels.entrySet()) {
            ServiceModel serviceModel = this.dataHolder.getServiceModel(routeModel.getKey());
            this.generate(routeModel.getValue(), serviceModel);
            OUT.print("\t@openshift:Route \t\t\t - complete " + ++count + "/" + size + "\r");
        }
    }

    private void generate(OpenShiftRouteModel routeModel, ServiceModel serviceModel) throws KubernetesPluginException {
        try {
            String routeHost = routeModel.getHost();
            if (routeModel.getDomain() != null) {
                if (null == this.dataHolder.getNamespace() || "".equals(this.dataHolder.getNamespace().trim())) {
                    throw new KubernetesPluginException("'namespace' field in @kubernetes:Deployment{} is required when using 'domain' field for setting the host of the @openshift:Route{} annotation. use the OpenShift project name as the value for 'namespace' field.");
                }
                routeHost = routeModel.getName() + "-" + this.dataHolder.getNamespace() + "." + routeModel.getDomain();
            }
            Route route = ((RouteBuilder)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)((RouteFluent.SpecNested)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(routeModel.getName())).withLabels(routeModel.getLabels())).withAnnotations(routeModel.getAnnotations())).withNamespace(this.dataHolder.getNamespace())).endMetadata()).withNewSpec().withHost(routeHost)).withNewPort().withNewTargetPort(serviceModel.getTargetPort())).endPort()).withNewTo().withKind("Service")).withName(serviceModel.getName())).withWeight(100)).endTo()).endSpec()).build();
            String resourceQuotaContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(route);
            KubernetesUtils.writeToFile(this.dataHolder.getK8sArtifactOutputPath().resolve("openshift"), resourceQuotaContent, "_openshift_route.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating OpenShift Route yaml file: " + routeModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }
}

