/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.models;

import io.fabric8.kubernetes.api.model.apps.DeploymentStrategy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinax.docker.generator.models.CopyFileModel;
import org.ballerinax.kubernetes.KubernetesConstants;
import org.ballerinax.kubernetes.models.ConfigMapModel;
import org.ballerinax.kubernetes.models.DeploymentBuildExtension;
import org.ballerinax.kubernetes.models.EnvVarValueModel;
import org.ballerinax.kubernetes.models.KubernetesModel;
import org.ballerinax.kubernetes.models.PersistentVolumeClaimModel;
import org.ballerinax.kubernetes.models.PodAutoscalerModel;
import org.ballerinax.kubernetes.models.PodTolerationModel;
import org.ballerinax.kubernetes.models.ProbeModel;
import org.ballerinax.kubernetes.models.SecretModel;
import org.ballerinax.kubernetes.models.ServiceAccountTokenModel;

public class DeploymentModel
extends KubernetesModel {
    private Map<String, String> podAnnotations;
    private int replicas = 1;
    private boolean prometheus = false;
    private int prometheusPort;
    private ProbeModel livenessProbe;
    private ProbeModel readinessProbe;
    private String namespace;
    private String imagePullPolicy;
    private String image;
    private boolean buildImage = true;
    private String baseImage = "ballerina/jre8:v1";
    private Map<String, EnvVarValueModel> env;
    private String username;
    private String password;
    private boolean push = false;
    private String cmd;
    private String dockerHost;
    private String dockerCertPath;
    private Set<Integer> ports;
    private PodAutoscalerModel podAutoscalerModel;
    private Set<SecretModel> secretModels;
    private Set<ConfigMapModel> configMapModels;
    private Set<PersistentVolumeClaimModel> volumeClaimModels;
    private Set<CopyFileModel> copyFiles;
    private Set<String> dependsOn;
    private Set<String> imagePullSecrets;
    private String commandArgs;
    private boolean singleYAML;
    private String registry;
    private DeploymentBuildExtension buildExtension;
    private List<PodTolerationModel> podTolerations;
    private DeploymentStrategy strategy;
    private Map<String, String> nodeSelector;
    private String serviceAccountName;
    private List<ServiceAccountTokenModel> serviceAccountTokenModel;

    public DeploymentModel() {
        this.labels = new LinkedHashMap();
        this.nodeSelector = new LinkedHashMap<String, String>();
        this.env = new LinkedHashMap<String, EnvVarValueModel>();
        this.imagePullPolicy = KubernetesConstants.ImagePullPolicy.IfNotPresent.name();
        this.dependsOn = new HashSet<String>();
        this.ports = new HashSet<Integer>();
        this.secretModels = new HashSet<SecretModel>();
        this.configMapModels = new HashSet<ConfigMapModel>();
        this.volumeClaimModels = new HashSet<PersistentVolumeClaimModel>();
        this.copyFiles = new HashSet<CopyFileModel>();
        this.imagePullSecrets = new HashSet<String>();
        this.singleYAML = true;
        this.commandArgs = "";
        this.registry = "";
        this.serviceAccountTokenModel = new ArrayList<ServiceAccountTokenModel>();
    }

    public Map<String, String> getPodAnnotations() {
        return this.podAnnotations;
    }

    public void setPodAnnotations(Map<String, String> podAnnotations) {
        this.podAnnotations = podAnnotations;
    }

    public void setPrometheusPort(int port) {
        this.prometheusPort = port;
        this.addPort(port);
    }

    public void setLivenessProbe(ProbeModel livenessProbe) {
        this.livenessProbe = livenessProbe;
        if (null != this.livenessProbe) {
            if (this.livenessProbe.getInitialDelaySeconds() == -1) {
                this.livenessProbe.setInitialDelaySeconds(10);
            }
            if (this.livenessProbe.getPeriodSeconds() == -1) {
                this.livenessProbe.setPeriodSeconds(5);
            }
        }
    }

    public void setReadinessProbe(ProbeModel readinessProbe) {
        this.readinessProbe = readinessProbe;
        if (null != this.readinessProbe) {
            if (this.readinessProbe.getInitialDelaySeconds() == -1) {
                this.readinessProbe.setInitialDelaySeconds(3);
            }
            if (this.readinessProbe.getPeriodSeconds() == -1) {
                this.readinessProbe.setPeriodSeconds(1);
            }
        }
    }

    public void addPort(int port) {
        this.ports.add(port);
    }

    public void addLabel(String key, String value) {
        this.labels.put(key, value);
    }

    public void addEnv(String key, EnvVarValueModel value) {
        this.env.put(key, value);
    }

    public String toString() {
        return "DeploymentModel{podAnnotations=" + this.podAnnotations + ", replicas=" + this.replicas + ", livenessProbe=" + this.livenessProbe + ", namespace='" + this.namespace + ", imagePullPolicy='" + this.imagePullPolicy + ", image='" + this.image + ", buildImage=" + this.buildImage + ", baseImage='" + this.baseImage + ", env=" + this.env + ", username='" + this.username + ", push=" + this.push + ", cmd=" + this.cmd + ", dockerHost='" + this.dockerHost + ", dockerCertPath='" + this.dockerCertPath + ", ports=" + this.ports + ", podAutoscalerModel=" + this.podAutoscalerModel + ", secretModels=" + this.secretModels + ", configMapModels=" + this.configMapModels + ", volumeClaimModels=" + this.volumeClaimModels + ", copyFiles=" + this.copyFiles + ", dependsOn=" + this.dependsOn + ", imagePullSecrets=" + this.imagePullSecrets + ", commandArgs='" + this.commandArgs + ", singleYAML=" + this.singleYAML + ", registry='" + this.registry + ", buildExtension=" + this.buildExtension + ", podTolerations=" + this.podTolerations + ", serviceAccountTokenModel=" + this.serviceAccountTokenModel + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeploymentModel)) {
            return false;
        }
        DeploymentModel other = (DeploymentModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$podAnnotations = this.getPodAnnotations();
        Map<String, String> other$podAnnotations = other.getPodAnnotations();
        if (this$podAnnotations == null ? other$podAnnotations != null : !((Object)this$podAnnotations).equals(other$podAnnotations)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        if (this.isPrometheus() != other.isPrometheus()) {
            return false;
        }
        if (this.getPrometheusPort() != other.getPrometheusPort()) {
            return false;
        }
        ProbeModel this$livenessProbe = this.getLivenessProbe();
        ProbeModel other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !this$livenessProbe.equals(other$livenessProbe)) {
            return false;
        }
        ProbeModel this$readinessProbe = this.getReadinessProbe();
        ProbeModel other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !this$readinessProbe.equals(other$readinessProbe)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        if (this.isBuildImage() != other.isBuildImage()) {
            return false;
        }
        String this$baseImage = this.getBaseImage();
        String other$baseImage = other.getBaseImage();
        if (this$baseImage == null ? other$baseImage != null : !this$baseImage.equals(other$baseImage)) {
            return false;
        }
        Map<String, EnvVarValueModel> this$env = this.getEnv();
        Map<String, EnvVarValueModel> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.isPush() != other.isPush()) {
            return false;
        }
        String this$cmd = this.getCmd();
        String other$cmd = other.getCmd();
        if (this$cmd == null ? other$cmd != null : !this$cmd.equals(other$cmd)) {
            return false;
        }
        String this$dockerHost = this.getDockerHost();
        String other$dockerHost = other.getDockerHost();
        if (this$dockerHost == null ? other$dockerHost != null : !this$dockerHost.equals(other$dockerHost)) {
            return false;
        }
        String this$dockerCertPath = this.getDockerCertPath();
        String other$dockerCertPath = other.getDockerCertPath();
        if (this$dockerCertPath == null ? other$dockerCertPath != null : !this$dockerCertPath.equals(other$dockerCertPath)) {
            return false;
        }
        Set<Integer> this$ports = this.getPorts();
        Set<Integer> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        PodAutoscalerModel this$podAutoscalerModel = this.getPodAutoscalerModel();
        PodAutoscalerModel other$podAutoscalerModel = other.getPodAutoscalerModel();
        if (this$podAutoscalerModel == null ? other$podAutoscalerModel != null : !((Object)this$podAutoscalerModel).equals(other$podAutoscalerModel)) {
            return false;
        }
        Set<SecretModel> this$secretModels = this.getSecretModels();
        Set<SecretModel> other$secretModels = other.getSecretModels();
        if (this$secretModels == null ? other$secretModels != null : !((Object)this$secretModels).equals(other$secretModels)) {
            return false;
        }
        Set<ConfigMapModel> this$configMapModels = this.getConfigMapModels();
        Set<ConfigMapModel> other$configMapModels = other.getConfigMapModels();
        if (this$configMapModels == null ? other$configMapModels != null : !((Object)this$configMapModels).equals(other$configMapModels)) {
            return false;
        }
        Set<PersistentVolumeClaimModel> this$volumeClaimModels = this.getVolumeClaimModels();
        Set<PersistentVolumeClaimModel> other$volumeClaimModels = other.getVolumeClaimModels();
        if (this$volumeClaimModels == null ? other$volumeClaimModels != null : !((Object)this$volumeClaimModels).equals(other$volumeClaimModels)) {
            return false;
        }
        Set<CopyFileModel> this$copyFiles = this.getCopyFiles();
        Set<CopyFileModel> other$copyFiles = other.getCopyFiles();
        if (this$copyFiles == null ? other$copyFiles != null : !((Object)this$copyFiles).equals(other$copyFiles)) {
            return false;
        }
        Set<String> this$dependsOn = this.getDependsOn();
        Set<String> other$dependsOn = other.getDependsOn();
        if (this$dependsOn == null ? other$dependsOn != null : !((Object)this$dependsOn).equals(other$dependsOn)) {
            return false;
        }
        Set<String> this$imagePullSecrets = this.getImagePullSecrets();
        Set<String> other$imagePullSecrets = other.getImagePullSecrets();
        if (this$imagePullSecrets == null ? other$imagePullSecrets != null : !((Object)this$imagePullSecrets).equals(other$imagePullSecrets)) {
            return false;
        }
        String this$commandArgs = this.getCommandArgs();
        String other$commandArgs = other.getCommandArgs();
        if (this$commandArgs == null ? other$commandArgs != null : !this$commandArgs.equals(other$commandArgs)) {
            return false;
        }
        if (this.isSingleYAML() != other.isSingleYAML()) {
            return false;
        }
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        DeploymentBuildExtension this$buildExtension = this.getBuildExtension();
        DeploymentBuildExtension other$buildExtension = other.getBuildExtension();
        if (this$buildExtension == null ? other$buildExtension != null : !((Object)this$buildExtension).equals(other$buildExtension)) {
            return false;
        }
        List<PodTolerationModel> this$podTolerations = this.getPodTolerations();
        List<PodTolerationModel> other$podTolerations = other.getPodTolerations();
        if (this$podTolerations == null ? other$podTolerations != null : !((Object)this$podTolerations).equals(other$podTolerations)) {
            return false;
        }
        DeploymentStrategy this$strategy = this.getStrategy();
        DeploymentStrategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)this$strategy).equals(other$strategy)) {
            return false;
        }
        Map<String, String> this$nodeSelector = this.getNodeSelector();
        Map<String, String> other$nodeSelector = other.getNodeSelector();
        if (this$nodeSelector == null ? other$nodeSelector != null : !((Object)this$nodeSelector).equals(other$nodeSelector)) {
            return false;
        }
        String this$serviceAccountName = this.getServiceAccountName();
        String other$serviceAccountName = other.getServiceAccountName();
        if (this$serviceAccountName == null ? other$serviceAccountName != null : !this$serviceAccountName.equals(other$serviceAccountName)) {
            return false;
        }
        List<ServiceAccountTokenModel> this$serviceAccountTokenModel = this.getServiceAccountTokenModel();
        List<ServiceAccountTokenModel> other$serviceAccountTokenModel = other.getServiceAccountTokenModel();
        return !(this$serviceAccountTokenModel == null ? other$serviceAccountTokenModel != null : !((Object)this$serviceAccountTokenModel).equals(other$serviceAccountTokenModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeploymentModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $podAnnotations = this.getPodAnnotations();
        result = result * 59 + ($podAnnotations == null ? 43 : ((Object)$podAnnotations).hashCode());
        result = result * 59 + this.getReplicas();
        result = result * 59 + (this.isPrometheus() ? 79 : 97);
        result = result * 59 + this.getPrometheusPort();
        ProbeModel $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : $livenessProbe.hashCode());
        ProbeModel $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : $readinessProbe.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        result = result * 59 + (this.isBuildImage() ? 79 : 97);
        String $baseImage = this.getBaseImage();
        result = result * 59 + ($baseImage == null ? 43 : $baseImage.hashCode());
        Map<String, EnvVarValueModel> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + (this.isPush() ? 79 : 97);
        String $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : $cmd.hashCode());
        String $dockerHost = this.getDockerHost();
        result = result * 59 + ($dockerHost == null ? 43 : $dockerHost.hashCode());
        String $dockerCertPath = this.getDockerCertPath();
        result = result * 59 + ($dockerCertPath == null ? 43 : $dockerCertPath.hashCode());
        Set<Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        PodAutoscalerModel $podAutoscalerModel = this.getPodAutoscalerModel();
        result = result * 59 + ($podAutoscalerModel == null ? 43 : ((Object)$podAutoscalerModel).hashCode());
        Set<SecretModel> $secretModels = this.getSecretModels();
        result = result * 59 + ($secretModels == null ? 43 : ((Object)$secretModels).hashCode());
        Set<ConfigMapModel> $configMapModels = this.getConfigMapModels();
        result = result * 59 + ($configMapModels == null ? 43 : ((Object)$configMapModels).hashCode());
        Set<PersistentVolumeClaimModel> $volumeClaimModels = this.getVolumeClaimModels();
        result = result * 59 + ($volumeClaimModels == null ? 43 : ((Object)$volumeClaimModels).hashCode());
        Set<CopyFileModel> $copyFiles = this.getCopyFiles();
        result = result * 59 + ($copyFiles == null ? 43 : ((Object)$copyFiles).hashCode());
        Set<String> $dependsOn = this.getDependsOn();
        result = result * 59 + ($dependsOn == null ? 43 : ((Object)$dependsOn).hashCode());
        Set<String> $imagePullSecrets = this.getImagePullSecrets();
        result = result * 59 + ($imagePullSecrets == null ? 43 : ((Object)$imagePullSecrets).hashCode());
        String $commandArgs = this.getCommandArgs();
        result = result * 59 + ($commandArgs == null ? 43 : $commandArgs.hashCode());
        result = result * 59 + (this.isSingleYAML() ? 79 : 97);
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        DeploymentBuildExtension $buildExtension = this.getBuildExtension();
        result = result * 59 + ($buildExtension == null ? 43 : ((Object)$buildExtension).hashCode());
        List<PodTolerationModel> $podTolerations = this.getPodTolerations();
        result = result * 59 + ($podTolerations == null ? 43 : ((Object)$podTolerations).hashCode());
        DeploymentStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)$strategy).hashCode());
        Map<String, String> $nodeSelector = this.getNodeSelector();
        result = result * 59 + ($nodeSelector == null ? 43 : ((Object)$nodeSelector).hashCode());
        String $serviceAccountName = this.getServiceAccountName();
        result = result * 59 + ($serviceAccountName == null ? 43 : $serviceAccountName.hashCode());
        List<ServiceAccountTokenModel> $serviceAccountTokenModel = this.getServiceAccountTokenModel();
        result = result * 59 + ($serviceAccountTokenModel == null ? 43 : ((Object)$serviceAccountTokenModel).hashCode());
        return result;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public boolean isPrometheus() {
        return this.prometheus;
    }

    public int getPrometheusPort() {
        return this.prometheusPort;
    }

    public ProbeModel getLivenessProbe() {
        return this.livenessProbe;
    }

    public ProbeModel getReadinessProbe() {
        return this.readinessProbe;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getImage() {
        return this.image;
    }

    public boolean isBuildImage() {
        return this.buildImage;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public Map<String, EnvVarValueModel> getEnv() {
        return this.env;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isPush() {
        return this.push;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    public Set<Integer> getPorts() {
        return this.ports;
    }

    public PodAutoscalerModel getPodAutoscalerModel() {
        return this.podAutoscalerModel;
    }

    public Set<SecretModel> getSecretModels() {
        return this.secretModels;
    }

    public Set<ConfigMapModel> getConfigMapModels() {
        return this.configMapModels;
    }

    public Set<PersistentVolumeClaimModel> getVolumeClaimModels() {
        return this.volumeClaimModels;
    }

    public Set<CopyFileModel> getCopyFiles() {
        return this.copyFiles;
    }

    public Set<String> getDependsOn() {
        return this.dependsOn;
    }

    public Set<String> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public String getCommandArgs() {
        return this.commandArgs;
    }

    public boolean isSingleYAML() {
        return this.singleYAML;
    }

    public String getRegistry() {
        return this.registry;
    }

    public DeploymentBuildExtension getBuildExtension() {
        return this.buildExtension;
    }

    public List<PodTolerationModel> getPodTolerations() {
        return this.podTolerations;
    }

    public DeploymentStrategy getStrategy() {
        return this.strategy;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public List<ServiceAccountTokenModel> getServiceAccountTokenModel() {
        return this.serviceAccountTokenModel;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    public void setPrometheus(boolean prometheus) {
        this.prometheus = prometheus;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setBuildImage(boolean buildImage) {
        this.buildImage = buildImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public void setEnv(Map<String, EnvVarValueModel> env) {
        this.env = env;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPush(boolean push) {
        this.push = push;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public void setDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    public void setDockerCertPath(String dockerCertPath) {
        this.dockerCertPath = dockerCertPath;
    }

    public void setPorts(Set<Integer> ports) {
        this.ports = ports;
    }

    public void setPodAutoscalerModel(PodAutoscalerModel podAutoscalerModel) {
        this.podAutoscalerModel = podAutoscalerModel;
    }

    public void setSecretModels(Set<SecretModel> secretModels) {
        this.secretModels = secretModels;
    }

    public void setConfigMapModels(Set<ConfigMapModel> configMapModels) {
        this.configMapModels = configMapModels;
    }

    public void setVolumeClaimModels(Set<PersistentVolumeClaimModel> volumeClaimModels) {
        this.volumeClaimModels = volumeClaimModels;
    }

    public void setCopyFiles(Set<CopyFileModel> copyFiles) {
        this.copyFiles = copyFiles;
    }

    public void setDependsOn(Set<String> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public void setImagePullSecrets(Set<String> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public void setCommandArgs(String commandArgs) {
        this.commandArgs = commandArgs;
    }

    public void setSingleYAML(boolean singleYAML) {
        this.singleYAML = singleYAML;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public void setBuildExtension(DeploymentBuildExtension buildExtension) {
        this.buildExtension = buildExtension;
    }

    public void setPodTolerations(List<PodTolerationModel> podTolerations) {
        this.podTolerations = podTolerations;
    }

    public void setStrategy(DeploymentStrategy strategy) {
        this.strategy = strategy;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    public void setServiceAccountTokenModel(List<ServiceAccountTokenModel> serviceAccountTokenModel) {
        this.serviceAccountTokenModel = serviceAccountTokenModel;
    }
}

