/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.models;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesDataHolder;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.util.Names;

public class KubernetesContext {
    private static KubernetesContext instance;
    private final Map<PackageID, KubernetesDataHolder> packageIDtoDataHolderMap = new HashMap<PackageID, KubernetesDataHolder>();
    private PackageID currentPackage;

    private KubernetesContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KubernetesContext getInstance() {
        Class<KubernetesDataHolder> clazz = KubernetesDataHolder.class;
        synchronized (KubernetesDataHolder.class) {
            if (instance == null) {
                instance = new KubernetesContext();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addDataHolder(PackageID packageID, Path sourcePath) {
        this.currentPackage = packageID;
        this.packageIDtoDataHolderMap.put(packageID, new KubernetesDataHolder(sourcePath));
    }

    public void setCurrentPackage(PackageID packageID) {
        this.currentPackage = packageID;
    }

    public KubernetesDataHolder getDataHolder() {
        return this.packageIDtoDataHolderMap.get(this.currentPackage);
    }

    public KubernetesDataHolder getDataHolder(PackageID packageID) {
        return this.packageIDtoDataHolderMap.get(packageID);
    }

    public Map<PackageID, KubernetesDataHolder> getPackageIDtoDataHolderMap() {
        return this.packageIDtoDataHolderMap;
    }

    public String getServiceName(String dependsOn) throws KubernetesPluginException {
        String packageName = dependsOn.substring(0, dependsOn.indexOf(Names.VERSION_SEPARATOR.value));
        String listener = dependsOn.substring(dependsOn.indexOf(Names.VERSION_SEPARATOR.value) + 1);
        for (PackageID packageID : this.packageIDtoDataHolderMap.keySet()) {
            if (!packageName.equals(packageID.name.value)) continue;
            return this.getDataHolder(packageID).getbListenerToK8sServiceMap().get(listener).getName();
        }
        throw new KubernetesPluginException("dependent listener " + dependsOn + " is not annotated with @kubernetes:Service{}");
    }

    public String getDeploymentNameFromListener(String dependsOn) throws KubernetesPluginException {
        if (KubernetesUtils.isBlank(dependsOn) || !dependsOn.contains(Names.VERSION_SEPARATOR.value) || dependsOn.indexOf(Names.VERSION_SEPARATOR.value) <= 1) {
            throw new KubernetesPluginException("@kubernetes:Deployment{} invalid dependsOn format specified " + dependsOn);
        }
        String packageName = dependsOn.substring(0, dependsOn.indexOf(Names.VERSION_SEPARATOR.value));
        for (PackageID packageID : this.packageIDtoDataHolderMap.keySet()) {
            if (!packageName.equals(packageID.name.value)) continue;
            return this.getDataHolder(packageID).getDeploymentModel().getName();
        }
        throw new KubernetesPluginException("dependent listener " + dependsOn + " not found.");
    }
}

