/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.models.knative;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.ApiGroup;
import io.fabric8.kubernetes.model.annotation.ApiVersion;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.ballerinax.kubernetes.specs.KnativeServiceSpec;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@JsonDeserialize(using=JsonDeserializer.None.class)
@ApiVersion(value="v1")
@ApiGroup(value="apps")
public class KnativeService
extends CustomResource {
    private static final long serialVersionUID = 6106269076155338045L;
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "serving.knative.dev/v1alpha1";
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "Service";
    @JsonProperty(value="metadata")
    private ObjectMeta metadata;
    @JsonProperty(value="spec")
    @Valid
    private KnativeServiceSpec spec;

    public KnativeService() {
    }

    public KnativeService(String apiVersion, String kind, ObjectMeta metadata, KnativeServiceSpec spec, DeploymentStatus status) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.metadata = metadata;
        this.spec = spec;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="spec")
    public KnativeServiceSpec getSpec() {
        return this.spec;
    }

    @JsonProperty(value="spec")
    public void setSpec(KnativeServiceSpec spec) {
        this.spec = spec;
    }

    @Override
    public String toString() {
        return "Deployment(apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", spec=" + this.getSpec() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnativeService)) {
            return false;
        }
        KnativeService other = (KnativeService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String apiVersion = this.getApiVersion();
        String otherApiVersion = other.getApiVersion();
        if (apiVersion == null ? otherApiVersion != null : !apiVersion.equals(otherApiVersion)) {
            return false;
        }
        String kind = this.getKind();
        String otherKind = other.getKind();
        if (kind == null ? otherKind != null : !kind.equals(otherKind)) {
            return false;
        }
        ObjectMeta metadata = this.getMetadata();
        ObjectMeta otherMetadata = other.getMetadata();
        return !(metadata == null ? otherMetadata != null : !((Object)metadata).equals(otherMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KnativeService;
    }

    public int hashCode() {
        boolean prime = true;
        int result = 1;
        String apiVersion = this.getApiVersion();
        result = result * 59 + (apiVersion == null ? 43 : apiVersion.hashCode());
        String kind = this.getKind();
        result = result * 59 + (kind == null ? 43 : kind.hashCode());
        ObjectMeta metadata = this.getMetadata();
        result = result * 59 + (metadata == null ? 43 : ((Object)metadata).hashCode());
        KnativeServiceSpec spec = this.getSpec();
        result = result * 59 + (spec == null ? 43 : spec.hashCode());
        return result;
    }
}

