/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.models.knative;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinax.docker.generator.models.CopyFileModel;
import org.ballerinax.kubernetes.KubernetesConstants;
import org.ballerinax.kubernetes.models.knative.ConfigMapModel;
import org.ballerinax.kubernetes.models.knative.EnvVarValueModel;
import org.ballerinax.kubernetes.models.knative.KnativeModel;
import org.ballerinax.kubernetes.models.knative.PodAutoscalerModel;
import org.ballerinax.kubernetes.models.knative.PodTolerationModel;
import org.ballerinax.kubernetes.models.knative.ProbeModel;
import org.ballerinax.kubernetes.models.knative.SecretModel;

public class ServiceModel
extends KnativeModel {
    private Map<String, String> podAnnotations;
    private int replicas = 1;
    private ProbeModel livenessProbe;
    private ProbeModel readinessProbe;
    private String namespace;
    private String imagePullPolicy;
    private String image;
    private boolean buildImage = true;
    private String baseImage = "ballerina/jre8:v1";
    private Map<String, EnvVarValueModel> env;
    private String username;
    private String password;
    private boolean push = false;
    private String cmd;
    private String dockerHost;
    private String dockerCertPath;
    private Set<Integer> ports;
    private int port = 8080;
    private PodAutoscalerModel podAutoscalerModel;
    private Set<SecretModel> secretModels;
    private Set<ConfigMapModel> configMapModels;
    private Set<CopyFileModel> copyFiles;
    private Set<String> dependsOn;
    private Set<String> imagePullSecrets;
    private String commandArgs;
    private boolean singleYAML;
    private String registry;
    private List<PodTolerationModel> podTolerations;
    private int containerConcurrency;
    private int timeoutSeconds;

    public ServiceModel() {
        this.labels = new LinkedHashMap();
        this.env = new LinkedHashMap<String, EnvVarValueModel>();
        this.imagePullPolicy = KubernetesConstants.ImagePullPolicy.IfNotPresent.name();
        this.dependsOn = new HashSet<String>();
        this.ports = new HashSet<Integer>();
        this.secretModels = new HashSet<SecretModel>();
        this.configMapModels = new HashSet<ConfigMapModel>();
        this.copyFiles = new HashSet<CopyFileModel>();
        this.imagePullSecrets = new HashSet<String>();
        this.singleYAML = true;
        this.commandArgs = "";
        this.registry = "";
        this.containerConcurrency = 100;
        this.timeoutSeconds = 60;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Map<String, String> getPodAnnotations() {
        return this.podAnnotations;
    }

    public void setPodAnnotations(Map<String, String> podAnnotations) {
        this.podAnnotations = podAnnotations;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    public ProbeModel getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(ProbeModel livenessProbe) {
        this.livenessProbe = livenessProbe;
        if (null != this.livenessProbe) {
            if (this.livenessProbe.getInitialDelaySeconds() == -1) {
                this.livenessProbe.setInitialDelaySeconds(10);
            }
            if (this.livenessProbe.getPeriodSeconds() == -1) {
                this.livenessProbe.setPeriodSeconds(5);
            }
        }
    }

    public ProbeModel getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(ProbeModel readinessProbe) {
        this.readinessProbe = readinessProbe;
        if (null != this.readinessProbe) {
            if (this.readinessProbe.getInitialDelaySeconds() == -1) {
                this.readinessProbe.setInitialDelaySeconds(3);
            }
            if (this.readinessProbe.getPeriodSeconds() == -1) {
                this.readinessProbe.setPeriodSeconds(1);
            }
        }
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Set<Integer> getPorts() {
        return this.ports;
    }

    public void addPort(int port) {
        this.ports.add(port);
    }

    public Map<String, EnvVarValueModel> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, EnvVarValueModel> env) {
        this.env = env;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isPush() {
        return this.push;
    }

    public void setPush(boolean push) {
        this.push = push;
    }

    public boolean isBuildImage() {
        return this.buildImage;
    }

    public void setBuildImage(boolean buildImage) {
        this.buildImage = buildImage;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public void addLabel(String key, String value) {
        this.labels.put(key, value);
    }

    public void addEnv(String key, EnvVarValueModel value) {
        this.env.put(key, value);
    }

    public PodAutoscalerModel getPodAutoscalerModel() {
        return this.podAutoscalerModel;
    }

    public void setPodAutoscalerModel(PodAutoscalerModel podAutoscalerModel) {
        this.podAutoscalerModel = podAutoscalerModel;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public void setDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    public Set<SecretModel> getSecretModels() {
        return this.secretModels;
    }

    public void setSecretModels(Set<SecretModel> secretModels) {
        this.secretModels = secretModels;
    }

    public Set<ConfigMapModel> getConfigMapModels() {
        return this.configMapModels;
    }

    public void setConfigMapModels(Set<ConfigMapModel> configMapModels) {
        this.configMapModels = configMapModels;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    public void setDockerCertPath(String dockerCertPath) {
        this.dockerCertPath = dockerCertPath;
    }

    public String getCommandArgs() {
        return this.commandArgs;
    }

    public void setCommandArgs(String commandArg) {
        this.commandArgs = commandArg;
    }

    public Set<CopyFileModel> getCopyFiles() {
        return this.copyFiles;
    }

    public void setCopyFiles(Set<CopyFileModel> copyFiles) {
        this.copyFiles = copyFiles;
    }

    public boolean isSingleYAML() {
        return this.singleYAML;
    }

    public void setSingleYAML(boolean singleYAML) {
        this.singleYAML = singleYAML;
    }

    public Set<String> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(Set<String> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public Set<String> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(Set<String> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setPorts(Set<Integer> ports) {
        this.ports = ports;
    }

    public List<PodTolerationModel> getPodTolerations() {
        return this.podTolerations;
    }

    public void setPodTolerations(List<PodTolerationModel> podTolerations) {
        this.podTolerations = podTolerations;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public int getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public void setContainerConcurrency(int containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public String toString() {
        return "DeploymentModel{podAnnotations=" + this.podAnnotations + ", replicas=" + this.replicas + ", livenessProbe=" + this.livenessProbe + ", namespace='" + this.namespace + ", imagePullPolicy='" + this.imagePullPolicy + ", image='" + this.image + ", buildImage=" + this.buildImage + ", baseImage='" + this.baseImage + ", env=" + this.env + ", username='" + this.username + ", push=" + this.push + ", cmd=" + this.cmd + ", dockerHost='" + this.dockerHost + ", dockerCertPath='" + this.dockerCertPath + ", ports=" + this.ports + ", podAutoscalerModel=" + this.podAutoscalerModel + ", secretModels=" + this.secretModels + ", configMapModels=" + this.configMapModels + ", copyFiles=" + this.copyFiles + ", dependsOn=" + this.dependsOn + ", imagePullSecrets=" + this.imagePullSecrets + ", commandArgs='" + this.commandArgs + ", singleYAML=" + this.singleYAML + ", registry='" + this.registry + ", podTolerations=" + this.podTolerations + ", containerConcurrency" + this.containerConcurrency + '}';
    }
}

