/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.apps.DeploymentStrategy;
import io.fabric8.kubernetes.api.model.apps.RollingUpdateDeployment;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.DeploymentModel;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.PodTolerationModel;
import org.ballerinax.kubernetes.models.ProbeModel;
import org.ballerinax.kubernetes.models.ServiceAccountTokenModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;

public class DeploymentAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode entityName, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processDeployment(attachmentNode);
    }

    @Override
    public void processAnnotation(SimpleVariableNode variableNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processDeployment(attachmentNode);
    }

    @Override
    public void processAnnotation(FunctionNode functionNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        if (!"main".equals(functionNode.getName().getValue())) {
            throw new KubernetesPluginException("@kubernetes:Deployment{} annotation must attached to amain function.");
        }
        this.processDeployment(attachmentNode);
    }

    private void processDeployment(AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        String dockerCertPath;
        DeploymentModel deploymentModel = new DeploymentModel();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            DeploymentConfiguration deploymentConfiguration = DeploymentConfiguration.valueOf(keyValue.getKey().toString());
            switch (deploymentConfiguration) {
                case name: {
                    deploymentModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(keyValue.getValue())));
                    break;
                }
                case labels: {
                    deploymentModel.setLabels(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case annotations: {
                    deploymentModel.setAnnotations(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case dockerHost: {
                    deploymentModel.setDockerHost(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case dockerCertPath: {
                    deploymentModel.setDockerCertPath(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case registry: {
                    deploymentModel.setRegistry(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case username: {
                    deploymentModel.setUsername(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case password: {
                    deploymentModel.setPassword(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case baseImage: {
                    deploymentModel.setBaseImage(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case image: {
                    deploymentModel.setImage(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case buildImage: {
                    deploymentModel.setBuildImage(KubernetesUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
                case push: {
                    deploymentModel.setPush(KubernetesUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
                case cmd: {
                    deploymentModel.setCmd(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case copyFiles: {
                    deploymentModel.setCopyFiles(KubernetesUtils.getExternalFileMap(keyValue));
                    break;
                }
                case singleYAML: {
                    deploymentModel.setSingleYAML(KubernetesUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
                case namespace: {
                    KubernetesContext.getInstance().getDataHolder().setNamespace(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case replicas: {
                    deploymentModel.setReplicas(KubernetesUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case livenessProbe: {
                    deploymentModel.setLivenessProbe(this.parseProbeConfiguration(keyValue.getValue()));
                    break;
                }
                case readinessProbe: {
                    deploymentModel.setReadinessProbe(this.parseProbeConfiguration(keyValue.getValue()));
                    break;
                }
                case imagePullPolicy: {
                    deploymentModel.setImagePullPolicy(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case env: {
                    deploymentModel.setEnv(KubernetesUtils.getEnvVarMap(keyValue.getValue()));
                    break;
                }
                case podAnnotations: {
                    deploymentModel.setPodAnnotations(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case podTolerations: {
                    deploymentModel.setPodTolerations(this.parsePodTolerationConfiguration(keyValue.getValue()));
                    break;
                }
                case buildExtension: {
                    deploymentModel.setBuildExtension(KubernetesUtils.parseBuildExtension(keyValue.getValue()));
                    break;
                }
                case dependsOn: {
                    deploymentModel.setDependsOn(this.getDependsOn(keyValue));
                    break;
                }
                case imagePullSecrets: {
                    deploymentModel.setImagePullSecrets(KubernetesUtils.getImagePullSecrets(keyValue));
                    break;
                }
                case updateStrategy: {
                    deploymentModel.setStrategy(this.getStrategy(keyValue));
                    break;
                }
                case nodeSelector: {
                    deploymentModel.setNodeSelector(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case serviceAccountName: {
                    deploymentModel.setServiceAccountName(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case projectedVolumeMount: {
                    deploymentModel.setServiceAccountTokenModel(this.parseProjectedVolumeConfiguration(keyValue.getValue()));
                    break;
                }
                case prometheus: {
                    deploymentModel.setPrometheus(KubernetesUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
            }
        }
        String dockerHost = System.getenv("DOCKER_HOST");
        if (!KubernetesUtils.isBlank(dockerHost)) {
            deploymentModel.setDockerHost(dockerHost);
        }
        if (!KubernetesUtils.isBlank(dockerCertPath = System.getenv("DOCKER_CERT_PATH"))) {
            deploymentModel.setDockerCertPath(dockerCertPath);
        }
        KubernetesContext.getInstance().getDataHolder().setDeploymentModel(deploymentModel);
    }

    private List<ServiceAccountTokenModel> parseProjectedVolumeConfiguration(BLangExpression projectedVolumeSources) throws KubernetesPluginException {
        LinkedList<ServiceAccountTokenModel> serviceAccountTokenModels = new LinkedList<ServiceAccountTokenModel>();
        List sources = ((BLangListConstructorExpr)((BLangRecordLiteral.BLangRecordKeyValueField)((BLangRecordLiteral)projectedVolumeSources).getFields().get((int)0)).valueExpr).getExpressions();
        for (BLangExpression projectionMountFieldsAsExpression : sources) {
            List<BLangRecordLiteral.BLangRecordKeyValueField> fields = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)projectionMountFieldsAsExpression).getFields());
            ServiceAccountTokenModel serviceAccountTokenModel = new ServiceAccountTokenModel();
            block7: for (BLangRecordLiteral.BLangRecordKeyValueField projectionMountField : fields) {
                ServiceAccountConfig fieldName = ServiceAccountConfig.valueOf(projectionMountField.getKey().toString());
                switch (fieldName) {
                    case name: {
                        serviceAccountTokenModel.setName(KubernetesUtils.getStringValue(projectionMountField.getValue()));
                        continue block7;
                    }
                    case mountPath: {
                        serviceAccountTokenModel.setMountPath(KubernetesUtils.getStringValue(projectionMountField.getValue()));
                        continue block7;
                    }
                    case expirationSeconds: {
                        serviceAccountTokenModel.setExpirationSeconds(KubernetesUtils.getIntValue(projectionMountField.getValue()));
                        continue block7;
                    }
                    case audience: {
                        serviceAccountTokenModel.setAudience(KubernetesUtils.getStringValue(projectionMountField.getValue()));
                        continue block7;
                    }
                }
                throw new KubernetesPluginException("unknown pod toleration field found: " + projectionMountField.getKey().toString());
            }
            serviceAccountTokenModels.add(serviceAccountTokenModel);
        }
        return serviceAccountTokenModels;
    }

    private List<PodTolerationModel> parsePodTolerationConfiguration(BLangExpression podTolerationValues) throws KubernetesPluginException {
        LinkedList<PodTolerationModel> podTolerationModels = new LinkedList<PodTolerationModel>();
        List podTolerations = ((BLangListConstructorExpr)podTolerationValues).exprs;
        for (BLangExpression podTolerationFieldsAsExpression : podTolerations) {
            List<BLangRecordLiteral.BLangRecordKeyValueField> podTolerationFields = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)podTolerationFieldsAsExpression).getFields());
            PodTolerationModel podTolerationModel = new PodTolerationModel();
            block8: for (BLangRecordLiteral.BLangRecordKeyValueField podTolerationField : podTolerationFields) {
                PodTolerationConfiguration podTolerationFieldName = PodTolerationConfiguration.valueOf(podTolerationField.getKey().toString());
                switch (podTolerationFieldName) {
                    case key: {
                        podTolerationModel.setKey(KubernetesUtils.getStringValue(podTolerationField.getValue()));
                        continue block8;
                    }
                    case operator: {
                        podTolerationModel.setOperator(KubernetesUtils.getStringValue(podTolerationField.getValue()));
                        continue block8;
                    }
                    case value: {
                        podTolerationModel.setValue(KubernetesUtils.getStringValue(podTolerationField.getValue()));
                        continue block8;
                    }
                    case effect: {
                        podTolerationModel.setEffect(KubernetesUtils.getStringValue(podTolerationField.getValue()));
                        continue block8;
                    }
                    case tolerationSeconds: {
                        podTolerationModel.setTolerationSeconds(KubernetesUtils.getIntValue(podTolerationField.getValue()));
                        continue block8;
                    }
                }
                throw new KubernetesPluginException("unknown pod toleration field found: " + podTolerationField.getKey().toString());
            }
            podTolerationModels.add(podTolerationModel);
        }
        return podTolerationModels;
    }

    private ProbeModel parseProbeConfiguration(BLangExpression probeValue) throws KubernetesPluginException {
        if ((probeValue instanceof BLangSimpleVarRef || probeValue instanceof BLangLiteral) && KubernetesUtils.getBooleanValue(probeValue)) {
            return new ProbeModel();
        }
        if (probeValue instanceof BLangRecordLiteral) {
            List<BLangRecordLiteral.BLangRecordKeyValueField> buildExtensionRecord = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)probeValue).getFields());
            ProbeModel probeModel = new ProbeModel();
            block5: for (BLangRecordLiteral.BLangRecordKeyValueField probeField : buildExtensionRecord) {
                ProbeConfiguration probeConfiguration = ProbeConfiguration.valueOf(probeField.getKey().toString());
                switch (probeConfiguration) {
                    case port: {
                        probeModel.setPort(KubernetesUtils.getIntValue(probeField.getValue()));
                        continue block5;
                    }
                    case initialDelaySeconds: {
                        probeModel.setInitialDelaySeconds(KubernetesUtils.getIntValue(probeField.getValue()));
                        continue block5;
                    }
                    case periodSeconds: {
                        probeModel.setPeriodSeconds(KubernetesUtils.getIntValue(probeField.getValue()));
                        continue block5;
                    }
                }
                throw new KubernetesPluginException("unknown probe field found: " + probeField.getKey().toString());
            }
            return probeModel;
        }
        return null;
    }

    private DeploymentStrategy getStrategy(BLangRecordLiteral.BLangRecordKeyValueField keyValue) throws KubernetesPluginException {
        DeploymentStrategy strategy = new DeploymentStrategy();
        if (keyValue.getValue().type.getKind() == TypeKind.STRING) {
            strategy.setType(KubernetesUtils.getStringValue(keyValue.getValue()));
            return strategy;
        }
        RollingUpdateDeployment rollingParams = new RollingUpdateDeployment();
        strategy.setType("RollingUpdate");
        for (RecordLiteralNode.RecordField strategyField : ((BLangRecordLiteral)keyValue.valueExpr).fields) {
            BLangRecordLiteral.BLangRecordKeyValueField strategyKeyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)strategyField;
            switch (strategyKeyValueField.getKey().toString()) {
                case "maxUnavailable": {
                    if (strategyKeyValueField.getValue().type.getKind() == TypeKind.INT) {
                        rollingParams.setMaxUnavailable(new IntOrString(KubernetesUtils.getIntValue(strategyKeyValueField.getValue())));
                        break;
                    }
                    rollingParams.setMaxUnavailable(new IntOrString(KubernetesUtils.getStringValue(strategyKeyValueField.getValue())));
                    break;
                }
                case "maxSurge": {
                    if (strategyKeyValueField.getValue().type.getKind() == TypeKind.INT) {
                        rollingParams.setMaxSurge(new IntOrString(KubernetesUtils.getIntValue(strategyKeyValueField.getValue())));
                        break;
                    }
                    rollingParams.setMaxSurge(new IntOrString(KubernetesUtils.getStringValue(strategyKeyValueField.getValue())));
                    break;
                }
            }
        }
        strategy.setRollingUpdate(rollingParams);
        return strategy;
    }

    private Set<String> getDependsOn(BLangRecordLiteral.BLangRecordKeyValueField keyValue) {
        HashSet<String> dependsOnList = new HashSet<String>();
        List configAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
        for (BLangExpression bLangExpression : configAnnotation) {
            dependsOnList.add(bLangExpression.toString());
        }
        return dependsOnList;
    }

    private static enum ServiceAccountConfig {
        name,
        mountPath,
        expirationSeconds,
        audience;

    }

    private static enum PodTolerationConfiguration {
        key,
        operator,
        value,
        effect,
        tolerationSeconds;

    }

    private static enum ProbeConfiguration {
        port,
        initialDelaySeconds,
        periodSeconds;

    }

    private static enum DeploymentConfiguration {
        name,
        labels,
        annotations,
        dockerHost,
        dockerCertPath,
        registry,
        username,
        password,
        baseImage,
        image,
        buildImage,
        push,
        cmd,
        copyFiles,
        singleYAML,
        namespace,
        replicas,
        livenessProbe,
        readinessProbe,
        imagePullPolicy,
        env,
        podAnnotations,
        podTolerations,
        buildExtension,
        dependsOn,
        imagePullSecrets,
        updateStrategy,
        nodeSelector,
        serviceAccountName,
        projectedVolumeMount,
        prometheus;

    }
}

