/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.IngressModel;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.SecretModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

public class IngressAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(SimpleVariableNode variableNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        IngressModel ingressModel = this.getIngressModelFromAnnotation(attachmentNode);
        String listenerName = variableNode.getName().getValue();
        if (KubernetesUtils.isBlank(ingressModel.getName())) {
            ingressModel.setName(KubernetesUtils.getValidName(listenerName) + "-ingress");
        }
        if (KubernetesUtils.isBlank(ingressModel.getHostname())) {
            ingressModel.setHostname(KubernetesUtils.getValidName(listenerName) + ".com");
        }
        ingressModel.setListenerName(listenerName);
        BLangTypeInit bListener = (BLangTypeInit)((BLangSimpleVariable)variableNode).expr;
        if (bListener.argsExpr.size() == 2) {
            if (bListener.argsExpr.get(1) instanceof BLangRecordLiteral) {
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)bListener.argsExpr.get(1);
                List<BLangRecordLiteral.BLangRecordKeyValueField> listenerConfig = KubernetesUtils.convertRecordFields(recordLiteral.getFields());
                this.processListener(listenerName, listenerConfig);
            } else if (bListener.argsExpr.get(1) instanceof BLangNamedArgsExpression) {
                BLangRecordLiteral recordFields = (BLangRecordLiteral)((BLangNamedArgsExpression)bListener.argsExpr.get((int)1)).expr;
                List<BLangRecordLiteral.BLangRecordKeyValueField> listenerConfig = KubernetesUtils.convertRecordFields(recordFields.getFields());
                this.processListener(listenerName, listenerConfig);
            }
        }
        KubernetesContext.getInstance().getDataHolder().addIngressModel(ingressModel);
    }

    private Set<SecretModel> processSecureSocketAnnotation(String listenerName, List<BLangRecordLiteral.BLangRecordKeyValueField> secureSocketKeyValues) throws KubernetesPluginException {
        HashMap<String, String> dataMap;
        SecretModel secretModel;
        String keyStoreContent;
        HashSet<SecretModel> secrets = new HashSet<SecretModel>();
        String keyStoreFile = null;
        String trustStoreFile = null;
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : secureSocketKeyValues) {
            String key = keyValue.getKey().toString();
            if ("keyStore".equals(key)) {
                keyStoreFile = this.extractFilePath(keyValue);
                continue;
            }
            if (!"trustStore".equals(key)) continue;
            trustStoreFile = this.extractFilePath(keyValue);
        }
        if (keyStoreFile != null && trustStoreFile != null && this.getMountPath(keyStoreFile).equals(this.getMountPath(trustStoreFile))) {
            keyStoreContent = this.readSecretFile(keyStoreFile);
            String trustStoreContent = this.readSecretFile(trustStoreFile);
            SecretModel secretModel2 = new SecretModel();
            secretModel2.setName(KubernetesUtils.getValidName(listenerName) + "-secure-socket");
            secretModel2.setMountPath(this.getMountPath(keyStoreFile));
            HashMap<String, String> dataMap2 = new HashMap<String, String>();
            dataMap2.put(String.valueOf(Paths.get(keyStoreFile, new String[0]).getFileName()), keyStoreContent);
            dataMap2.put(String.valueOf(Paths.get(trustStoreFile, new String[0]).getFileName()), trustStoreContent);
            secretModel2.setData(dataMap2);
            secrets.add(secretModel2);
            return secrets;
        }
        if (keyStoreFile != null) {
            keyStoreContent = this.readSecretFile(keyStoreFile);
            secretModel = new SecretModel();
            secretModel.setName(KubernetesUtils.getValidName(listenerName) + "-keystore");
            secretModel.setMountPath(this.getMountPath(keyStoreFile));
            dataMap = new HashMap<String, String>();
            dataMap.put(String.valueOf(Paths.get(keyStoreFile, new String[0]).getFileName()), keyStoreContent);
            secretModel.setData(dataMap);
            secrets.add(secretModel);
        }
        if (trustStoreFile != null) {
            String trustStoreContent = this.readSecretFile(trustStoreFile);
            secretModel = new SecretModel();
            secretModel.setName(KubernetesUtils.getValidName(listenerName) + "-truststore");
            secretModel.setMountPath(this.getMountPath(trustStoreFile));
            dataMap = new HashMap();
            dataMap.put(String.valueOf(Paths.get(trustStoreFile, new String[0]).getFileName()), trustStoreContent);
            secretModel.setData(dataMap);
            secrets.add(secretModel);
        }
        return secrets;
    }

    private String readSecretFile(String filePath) throws KubernetesPluginException {
        if (filePath.contains("${ballerina.home}")) {
            String ballerinaHome = System.getProperty("ballerina.home");
            filePath = filePath.replace("${ballerina.home}", ballerinaHome);
        }
        Path dataFilePath = Paths.get(filePath, new String[0]);
        return Base64.encodeBase64String(KubernetesUtils.readFileContent(dataFilePath));
    }

    private String getMountPath(String mountPath) throws KubernetesPluginException {
        Path parentPath = Paths.get(mountPath, new String[0]).getParent();
        if (parentPath != null && ".".equals(parentPath.toString())) {
            throw new KubernetesPluginException("Invalid path: " + mountPath + ". Providing relative path in the same level as source file is not supported with @kubernetes:Ingress annotations. Please create a sub folder and provide the relative path. eg: './security/ballerinaKeystore.p12'");
        }
        if (!Paths.get(mountPath, new String[0]).isAbsolute()) {
            mountPath = "/home/ballerina" + File.separator + mountPath;
        }
        return String.valueOf(Paths.get(mountPath, new String[0]).getParent());
    }

    private String extractFilePath(BLangRecordLiteral.BLangRecordKeyValueField keyValue) {
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyStoreConfigs = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)keyValue.valueExpr).getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyStoreConfig : keyStoreConfigs) {
            String configKey = keyStoreConfig.getKey().toString();
            if (!"path".equals(configKey)) continue;
            return keyStoreConfig.getValue().toString();
        }
        return null;
    }

    private IngressModel getIngressModelFromAnnotation(AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        IngressModel ingressModel = new IngressModel();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            IngressConfiguration ingressConfiguration = IngressConfiguration.valueOf(keyValue.getKey().toString());
            switch (ingressConfiguration) {
                case name: {
                    ingressModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(keyValue.getValue())));
                    break;
                }
                case labels: {
                    ingressModel.setLabels(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case annotations: {
                    ingressModel.setAnnotations(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case hostname: {
                    ingressModel.setHostname(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case path: {
                    ingressModel.setPath(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case targetPath: {
                    ingressModel.setTargetPath(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case ingressClass: {
                    ingressModel.setIngressClass(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case enableTLS: {
                    ingressModel.setEnableTLS(KubernetesUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
            }
        }
        return ingressModel;
    }

    private void processListener(String listenerName, List<BLangRecordLiteral.BLangRecordKeyValueField> listenerConfig) throws KubernetesPluginException {
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : listenerConfig) {
            String key = keyValue.getKey().toString();
            if (!"secureSocket".equals(key)) continue;
            List<BLangRecordLiteral.BLangRecordKeyValueField> sslKeyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)keyValue.valueExpr).getFields());
            Set<SecretModel> secretModels = this.processSecureSocketAnnotation(listenerName, sslKeyValues);
            KubernetesContext.getInstance().getDataHolder().addListenerSecret(listenerName, secretModels);
            KubernetesContext.getInstance().getDataHolder().addSecrets(secretModels);
        }
    }

    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        BLangService bService = (BLangService)serviceNode;
        for (BLangExpression attachedExpr : bService.getAttachedExprs()) {
            if (!(attachedExpr instanceof BLangTypeInit)) continue;
            throw new KubernetesPluginException("@kubernetes:Ingress{} annotation must be attached to the listener");
        }
        IngressModel ingressModel = this.getIngressModelFromAnnotation(attachmentNode);
        String listenerName = serviceNode.getName().getValue();
        if (KubernetesUtils.isBlank(ingressModel.getName())) {
            ingressModel.setName(KubernetesUtils.getValidName(listenerName) + "-anonymous" + "-ingress");
        }
        if (KubernetesUtils.isBlank(ingressModel.getHostname())) {
            ingressModel.setHostname(KubernetesUtils.getValidName(listenerName) + ".com");
        }
        ingressModel.setListenerName(listenerName);
        for (BLangExpression attachedExpr : bService.getAttachedExprs()) {
            if (!(attachedExpr instanceof BLangTypeInit)) continue;
            BLangTypeInit bListener = (BLangTypeInit)attachedExpr;
            if (bListener.argsExpr.size() != 2 || !(bListener.argsExpr.get(1) instanceof BLangRecordLiteral)) continue;
            BLangRecordLiteral bConfigRecordLiteral = (BLangRecordLiteral)bListener.argsExpr.get(1);
            List<BLangRecordLiteral.BLangRecordKeyValueField> listenerConfig = KubernetesUtils.convertRecordFields(bConfigRecordLiteral.getFields());
            this.processListener(listenerName, listenerConfig);
        }
        KubernetesContext.getInstance().getDataHolder().addIngressModel(ingressModel);
    }

    private static enum IngressConfiguration {
        name,
        labels,
        annotations,
        hostname,
        path,
        targetPath,
        ingressClass,
        enableTLS;

    }
}

