/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinax.kubernetes.KubernetesConstants;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.JobModel;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class JobAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(FunctionNode functionNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        String dockerCertPath;
        JobModel jobModel = new JobModel();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            JobConfiguration jobConfiguration = JobConfiguration.valueOf(keyValue.getKey().toString());
            switch (jobConfiguration) {
                case name: {
                    jobModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(keyValue.getValue())));
                    break;
                }
                case namespace: {
                    KubernetesContext.getInstance().getDataHolder().setNamespace(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case labels: {
                    jobModel.setLabels(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case annotations: {
                    jobModel.setAnnotations(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case restartPolicy: {
                    jobModel.setRestartPolicy(KubernetesConstants.RestartPolicy.valueOf(KubernetesUtils.getStringValue(keyValue.getValue())).name());
                    break;
                }
                case backoffLimit: {
                    jobModel.setBackoffLimit(KubernetesUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case activeDeadlineSeconds: {
                    jobModel.setActiveDeadlineSeconds(KubernetesUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case schedule: {
                    jobModel.setSchedule(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case username: {
                    jobModel.setUsername(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case env: {
                    jobModel.setEnv(KubernetesUtils.getEnvVarMap(keyValue.getValue()));
                    break;
                }
                case password: {
                    jobModel.setPassword(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case baseImage: {
                    jobModel.setBaseImage(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case push: {
                    jobModel.setPush(KubernetesUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
                case cmd: {
                    jobModel.setCmd(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case buildImage: {
                    jobModel.setBuildImage(KubernetesUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
                case image: {
                    jobModel.setImage(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case dockerHost: {
                    jobModel.setDockerHost(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case dockerCertPath: {
                    jobModel.setDockerCertPath(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case imagePullPolicy: {
                    jobModel.setImagePullPolicy(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case copyFiles: {
                    jobModel.setCopyFiles(KubernetesUtils.getExternalFileMap(keyValue));
                    break;
                }
                case singleYAML: {
                    jobModel.setSingleYAML(KubernetesUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
                case imagePullSecrets: {
                    jobModel.setImagePullSecrets(KubernetesUtils.getImagePullSecrets(keyValue));
                    break;
                }
                case registry: {
                    jobModel.setRegistry(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case nodeSelector: {
                    jobModel.setNodeSelector(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
            }
        }
        String dockerHost = System.getenv("DOCKER_HOST");
        if (!KubernetesUtils.isBlank(dockerHost)) {
            jobModel.setDockerHost(dockerHost);
        }
        if (!KubernetesUtils.isBlank(dockerCertPath = System.getenv("DOCKER_CERT_PATH"))) {
            jobModel.setDockerCertPath(dockerCertPath);
        }
        KubernetesContext.getInstance().getDataHolder().setJobModel(jobModel);
    }

    private static enum JobConfiguration {
        name,
        namespace,
        labels,
        annotations,
        restartPolicy,
        backoffLimit,
        activeDeadlineSeconds,
        schedule,
        env,
        buildImage,
        dockerHost,
        username,
        password,
        baseImage,
        image,
        imagePullPolicy,
        push,
        cmd,
        dockerCertPath,
        copyFiles,
        singleYAML,
        dependsOn,
        imagePullSecrets,
        registry,
        nodeSelector;

    }
}

