/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import java.util.HashSet;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.ResourceQuotaModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class ResourceQuotaAnnotationPreprocessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processResourceQuotaAnnotation((BLangAnnotationAttachment)attachmentNode);
    }

    @Override
    public void processAnnotation(SimpleVariableNode variableNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processResourceQuotaAnnotation((BLangAnnotationAttachment)attachmentNode);
    }

    @Override
    public void processAnnotation(FunctionNode functionNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        if (!"main".equals(functionNode.getName().getValue())) {
            throw new KubernetesPluginException("@kubernetes:ResourceQuota{} annotation must be attached to a main function.");
        }
        this.processResourceQuotaAnnotation((BLangAnnotationAttachment)attachmentNode);
    }

    private void processResourceQuotaAnnotation(BLangAnnotationAttachment attachmentNode) throws KubernetesPluginException {
        HashSet<ResourceQuotaModel> resourceQuotaModels = new HashSet<ResourceQuotaModel>();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)attachmentNode.expr).getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            List secretAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
            for (BLangExpression bLangExpression : secretAnnotation) {
                ResourceQuotaModel resourceQuotaModel = new ResourceQuotaModel();
                List<BLangRecordLiteral.BLangRecordKeyValueField> annotationValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)bLangExpression).getFields());
                for (BLangRecordLiteral.BLangRecordKeyValueField annotation : annotationValues) {
                    ResourceQuotaConfig resourceQuotaConfig = ResourceQuotaConfig.valueOf(annotation.getKey().toString());
                    switch (resourceQuotaConfig) {
                        case name: {
                            resourceQuotaModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(annotation.getValue())));
                            break;
                        }
                        case labels: {
                            resourceQuotaModel.setLabels(KubernetesUtils.getMap(annotation.getValue()));
                            break;
                        }
                        case annotations: {
                            resourceQuotaModel.setAnnotations(KubernetesUtils.getMap(annotation.getValue()));
                            break;
                        }
                        case hard: {
                            resourceQuotaModel.setHard(KubernetesUtils.getMap(annotation.getValue()));
                            break;
                        }
                        case scopes: {
                            resourceQuotaModel.setScopes(new HashSet<String>(KubernetesUtils.getList(annotation.getValue())));
                            break;
                        }
                    }
                }
                resourceQuotaModels.add(resourceQuotaModel);
            }
        }
        KubernetesContext.getInstance().getDataHolder().setResourceQuotaModels(resourceQuotaModels);
    }

    private static enum ResourceQuotaConfig {
        name,
        labels,
        annotations,
        hard,
        scopes;

    }
}

