/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.SecretModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class SecretAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processSecret(serviceNode.getName(), attachmentNode);
    }

    @Override
    public void processAnnotation(FunctionNode functionNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        if (!"main".equals(functionNode.getName().getValue())) {
            throw new KubernetesPluginException("@kubernetes:Secret{} annotation must be attached to a main function.");
        }
        this.processSecret(functionNode.getName(), attachmentNode);
    }

    private void processSecret(IdentifierNode nodeID, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        HashSet<SecretModel> secrets = new HashSet<SecretModel>();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        block17: for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            String key;
            switch (key = keyValue.getKey().toString()) {
                case "secrets": {
                    List configAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
                    for (BLangExpression bLangExpression : configAnnotation) {
                        SecretModel secretModel = new SecretModel();
                        List<BLangRecordLiteral.BLangRecordKeyValueField> annotationValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)bLangExpression).getFields());
                        for (BLangRecordLiteral.BLangRecordKeyValueField annotation : annotationValues) {
                            SecretMountConfig volumeMountConfig = SecretMountConfig.valueOf(annotation.getKey().toString());
                            switch (volumeMountConfig) {
                                case name: {
                                    secretModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(annotation.getValue())));
                                    break;
                                }
                                case labels: {
                                    secretModel.setLabels(KubernetesUtils.getMap(keyValue.getValue()));
                                    break;
                                }
                                case annotations: {
                                    secretModel.setAnnotations(KubernetesUtils.getMap(keyValue.getValue()));
                                    break;
                                }
                                case mountPath: {
                                    Path mountPath = Paths.get(KubernetesUtils.getStringValue(annotation.getValue()), new String[0]);
                                    Path homePath = Paths.get("/home/ballerina", new String[0]);
                                    Path runtimePath = Paths.get("/ballerina/runtime", new String[0]);
                                    Path confPath = Paths.get("/home/ballerina/conf/", new String[0]);
                                    if (mountPath.equals(homePath)) {
                                        throw new KubernetesPluginException("@kubernetes:Secret{} mount path cannot be ballerina home: /home/ballerina");
                                    }
                                    if (mountPath.equals(runtimePath)) {
                                        throw new KubernetesPluginException("@kubernetes:Secret{} mount path cannot be ballerina runtime: /ballerina/runtime");
                                    }
                                    if (mountPath.equals(confPath)) {
                                        throw new KubernetesPluginException("@kubernetes:Secret{} mount path cannot be ballerina conf file mount path: /home/ballerina/conf/");
                                    }
                                    secretModel.setMountPath(KubernetesUtils.getStringValue(annotation.getValue()));
                                    break;
                                }
                                case data: {
                                    List data = ((BLangListConstructorExpr)annotation.valueExpr).exprs;
                                    secretModel.setData(this.getDataForSecret(data));
                                    break;
                                }
                                case readOnly: {
                                    secretModel.setReadOnly(KubernetesUtils.getBooleanValue(annotation.getValue()));
                                    break;
                                }
                                case defaultMode: {
                                    secretModel.setDefaultMode(KubernetesUtils.getIntValue(annotation.getValue()));
                                    break;
                                }
                            }
                        }
                        if (KubernetesUtils.isBlank(secretModel.getName())) {
                            secretModel.setName(KubernetesUtils.getValidName(nodeID.getValue()) + "-secret");
                        }
                        if (secretModel.getData() == null || secretModel.getData().size() <= 0) continue;
                        secrets.add(secretModel);
                    }
                    continue block17;
                }
                case "conf": {
                    secrets.add(this.getBallerinaConfSecret(keyValue.getValue().toString(), nodeID.getValue()));
                    break;
                }
            }
        }
        KubernetesContext.getInstance().getDataHolder().addSecrets(secrets);
    }

    private SecretModel getBallerinaConfSecret(String configFilePath, String serviceName) throws KubernetesPluginException {
        SecretModel secretModel = new SecretModel();
        secretModel.setName(KubernetesUtils.getValidName(serviceName) + "-ballerina-conf" + "-secret");
        secretModel.setMountPath("/home/ballerina/conf/");
        Path dataFilePath = Paths.get(configFilePath, new String[0]);
        if (!dataFilePath.isAbsolute()) {
            dataFilePath = KubernetesContext.getInstance().getDataHolder().getSourceRoot().resolve(dataFilePath).normalize();
        }
        String content = Base64.encodeBase64String(KubernetesUtils.readFileContent(dataFilePath));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("ballerina.conf", content);
        secretModel.setData(dataMap);
        secretModel.setBallerinaConf(configFilePath);
        secretModel.setReadOnly(false);
        return secretModel;
    }

    private Map<String, String> getDataForSecret(List<BLangExpression> data) throws KubernetesPluginException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (BLangExpression bLangExpression : data) {
            Path dataFilePath = Paths.get(KubernetesUtils.getStringValue(bLangExpression), new String[0]);
            String key = String.valueOf(dataFilePath.getFileName());
            String content = Base64.encodeBase64String(KubernetesUtils.readFileContent(dataFilePath));
            dataMap.put(key, content);
        }
        return dataMap;
    }

    private static enum SecretMountConfig {
        name,
        labels,
        annotations,
        mountPath,
        readOnly,
        data,
        conf,
        defaultMode;

    }
}

