/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinax.kubernetes.KubernetesConstants;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.PrometheusModel;
import org.ballerinax.kubernetes.models.ServiceModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;

public class ServiceAnnotationProcessor
extends AbstractAnnotationProcessor {
    private PrometheusModel getPrometheusConfig(BLangRecordLiteral.BLangRecordKeyValueField keyValue) throws KubernetesPluginException {
        PrometheusModel prometheusModel = new PrometheusModel();
        for (RecordLiteralNode.RecordField prometheusConfig : ((BLangRecordLiteral)keyValue.valueExpr).fields) {
            BLangRecordLiteral.BLangRecordKeyValueField prometheusConfigKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)prometheusConfig;
            switch (prometheusConfigKeyValue.getKey().toString()) {
                case "port": {
                    prometheusModel.setPort(KubernetesUtils.getIntValue(((BLangRecordLiteral.BLangRecordKeyValueField)prometheusConfig).getValue()));
                    break;
                }
                case "serviceType": {
                    prometheusModel.setServiceType(KubernetesUtils.getStringValue(((BLangRecordLiteral.BLangRecordKeyValueField)prometheusConfig).getValue()));
                    break;
                }
                case "nodePort": {
                    prometheusModel.setNodePort(KubernetesUtils.getIntValue(((BLangRecordLiteral.BLangRecordKeyValueField)prometheusConfig).getValue()));
                    break;
                }
            }
        }
        return prometheusModel;
    }

    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        BLangService bService = (BLangService)serviceNode;
        for (BLangExpression attachedExpr : bService.getAttachedExprs()) {
            if (!(attachedExpr instanceof BLangSimpleVarRef)) continue;
            throw new KubernetesPluginException("@kubernetes:Service{} annotation must be attached to the listener");
        }
        ServiceModel serviceModel = this.getServiceModelFromAnnotation(attachmentNode);
        if (KubernetesUtils.isBlank(serviceModel.getName())) {
            serviceModel.setName(KubernetesUtils.getValidName(serviceNode.getName().getValue()) + "-svc");
        }
        BLangTypeInit bListener = (BLangTypeInit)bService.getAttachedExprs().get(0);
        this.validatePorts(serviceModel, bListener);
        KubernetesContext.getInstance().getDataHolder().addBListenerToK8sServiceMap(serviceNode.getName().getValue(), serviceModel);
    }

    private void validatePorts(ServiceModel serviceModel, BLangTypeInit bListener) throws KubernetesPluginException {
        if (serviceModel.getPort() == -1) {
            serviceModel.setPort(this.extractPort(bListener));
        }
        if (serviceModel.getTargetPort() == -1) {
            serviceModel.setTargetPort(this.extractPort(bListener));
        }
        this.setServiceProtocol(serviceModel, bListener);
        if (serviceModel.getNodePort() != -1 && !"NodePort".equals(serviceModel.getServiceType())) {
            throw new KubernetesPluginException("NodePort [" + serviceModel.getNodePort() + "] defined without setting the service type to NodePort. Found [" + serviceModel.getServiceType() + "]");
        }
    }

    @Override
    public void processAnnotation(SimpleVariableNode variableNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        ServiceModel serviceModel = this.getServiceModelFromAnnotation(attachmentNode);
        if (KubernetesUtils.isBlank(serviceModel.getName())) {
            serviceModel.setName(KubernetesUtils.getValidName(variableNode.getName().getValue()) + "-svc");
        }
        BLangTypeInit bListener = (BLangTypeInit)((BLangSimpleVariable)variableNode).expr;
        this.validatePorts(serviceModel, bListener);
        KubernetesContext.getInstance().getDataHolder().addBListenerToK8sServiceMap(variableNode.getName().getValue(), serviceModel);
    }

    private int extractPort(BLangTypeInit bListener) throws KubernetesPluginException {
        try {
            if ("int".equals(((BLangExpression)bListener.argsExpr.get((int)0)).expectedType.toString())) {
                return Integer.parseInt(((BLangExpression)bListener.argsExpr.get(0)).toString());
            }
            for (BLangRecordLiteral.BLangRecordKeyValueField arg : KubernetesUtils.convertRecordFields(((BLangRecordLiteral)bListener.argsExpr.get(0)).getFields())) {
                if (!"port".equals(arg.getKey().toString())) continue;
                return Integer.parseInt(arg.getValue().toString());
            }
            throw new KubernetesPluginException("unable extract port from the listener " + ((BLangExpression)bListener.argsExpr.get(0)).toString());
        }
        catch (NumberFormatException e) {
            throw new KubernetesPluginException("unable to parse port/targetPort for the service: " + ((BLangExpression)bListener.argsExpr.get(0)).toString());
        }
    }

    private void setServiceProtocol(ServiceModel serviceModel, BLangTypeInit bListener) {
        if (null != bListener.userDefinedType) {
            BLangUserDefinedType userDefinedType = (BLangUserDefinedType)bListener.userDefinedType;
            serviceModel.setProtocol(userDefinedType.getPackageAlias().getValue());
        } else {
            BLangIdentifier packageAlias = ((BLangUserDefinedType)((BLangSimpleVariable)bListener.parent).typeNode).getPackageAlias();
            serviceModel.setProtocol(packageAlias.getValue());
        }
        if ("http".equals(serviceModel.getProtocol()) && bListener.argsExpr.size() == 2 && bListener.argsExpr.get(1) instanceof BLangRecordLiteral) {
            BLangRecordLiteral bConfigRecordLiteral = (BLangRecordLiteral)bListener.argsExpr.get(1);
            List<BLangRecordLiteral.BLangRecordKeyValueField> listenerConfig = KubernetesUtils.convertRecordFields(bConfigRecordLiteral.getFields());
            serviceModel.setProtocol(this.isHTTPS(listenerConfig) ? "https" : "http");
        }
    }

    private boolean isHTTPS(List<BLangRecordLiteral.BLangRecordKeyValueField> listenerConfig) {
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : listenerConfig) {
            String key = keyValue.getKey().toString();
            if (!"secureSocket".equals(key)) continue;
            return true;
        }
        return false;
    }

    private ServiceModel getServiceModelFromAnnotation(AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        ServiceModel serviceModel = new ServiceModel();
        BLangRecordLiteral recordLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr;
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(recordLiteral.getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            ServiceConfiguration serviceConfiguration = ServiceConfiguration.valueOf(keyValue.getKey().toString());
            switch (serviceConfiguration) {
                case name: {
                    serviceModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(keyValue.getValue())));
                    break;
                }
                case labels: {
                    serviceModel.setLabels(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case annotations: {
                    serviceModel.setAnnotations(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case serviceType: {
                    serviceModel.setServiceType(KubernetesConstants.ServiceType.valueOf(KubernetesUtils.getStringValue(keyValue.getValue())).name());
                    break;
                }
                case portName: {
                    serviceModel.setPortName(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case port: {
                    serviceModel.setPort(KubernetesUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case targetPort: {
                    serviceModel.setTargetPort(KubernetesUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case nodePort: {
                    serviceModel.setNodePort(KubernetesUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case sessionAffinity: {
                    serviceModel.setSessionAffinity(KubernetesUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case prometheus: {
                    serviceModel.setPrometheusModel(this.getPrometheusConfig(keyValue));
                    break;
                }
            }
        }
        return serviceModel;
    }

    private static enum ServiceConfiguration {
        name,
        labels,
        annotations,
        serviceType,
        portName,
        port,
        targetPort,
        nodePort,
        sessionAffinity,
        prometheus;

    }
}

