/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors.knative;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.knative.KnativeContext;
import org.ballerinax.kubernetes.models.knative.SecretModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KnativeUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class KnativeSecretAnnotationProcesser
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processSecret(serviceNode.getName(), attachmentNode);
    }

    @Override
    public void processAnnotation(FunctionNode functionNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        if (!"main".equals(functionNode.getName().getValue())) {
            throw new KubernetesPluginException("@kubernetes:Secret{} annotation cannot be attached to a non main function.");
        }
        this.processSecret(functionNode.getName(), attachmentNode);
    }

    private void processSecret(IdentifierNode nodeID, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        HashSet<SecretModel> secrets = new HashSet<SecretModel>();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KnativeUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            List secretAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
            for (BLangExpression bLangExpression : secretAnnotation) {
                SecretModel secretModel = new SecretModel();
                List<BLangRecordLiteral.BLangRecordKeyValueField> annotationValues = KnativeUtils.convertRecordFields(((BLangRecordLiteral)bLangExpression).getFields());
                for (BLangRecordLiteral.BLangRecordKeyValueField annotation : annotationValues) {
                    SecretMountConfig secretMountConfig = SecretMountConfig.valueOf(annotation.getKey().toString());
                    switch (secretMountConfig) {
                        case name: {
                            secretModel.setName(KnativeUtils.getValidName(KnativeUtils.getStringValue(annotation.getValue())));
                            break;
                        }
                        case labels: {
                            secretModel.setLabels(KnativeUtils.getMap(keyValue.getValue()));
                            break;
                        }
                        case annotations: {
                            secretModel.setAnnotations(KnativeUtils.getMap(keyValue.getValue()));
                            break;
                        }
                        case mountPath: {
                            secretModel.setMountPath(KnativeUtils.getStringValue(annotation.getValue()));
                            break;
                        }
                        case data: {
                            List data = ((BLangListConstructorExpr)annotation.valueExpr).exprs;
                            secretModel.setData(this.getDataForSecret(data));
                            break;
                        }
                        case readOnly: {
                            secretModel.setReadOnly(KnativeUtils.getBooleanValue(annotation.getValue()));
                            break;
                        }
                    }
                }
                if (KnativeUtils.isBlank(secretModel.getName())) {
                    secretModel.setName(KnativeUtils.getValidName(nodeID.getValue()) + "-secret");
                }
                secrets.add(secretModel);
            }
        }
        KnativeContext.getInstance().getDataHolder().addSecrets(secrets);
    }

    private Map<String, String> getDataForSecret(List<BLangExpression> data) throws KubernetesPluginException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (BLangExpression bLangExpression : data) {
            Path dataFilePath = Paths.get(KnativeUtils.getStringValue(bLangExpression), new String[0]);
            String key = String.valueOf(dataFilePath.getFileName());
            String content = Base64.encodeBase64String(KnativeUtils.readFileContent(dataFilePath));
            dataMap.put(key, content);
        }
        return dataMap;
    }

    private static enum SecretMountConfig {
        name,
        labels,
        annotations,
        mountPath,
        readOnly,
        data;

    }
}

