/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors.knative;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.knative.KnativeContext;
import org.ballerinax.kubernetes.models.knative.PodTolerationModel;
import org.ballerinax.kubernetes.models.knative.ProbeModel;
import org.ballerinax.kubernetes.models.knative.ServiceModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KnativeUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

public class KnativeServiceAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(FunctionNode functionNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        if (!"main".equals(functionNode.getName().getValue())) {
            throw new KubernetesPluginException("@kubernetes:Deployment{} annotation cannot be attached to a non main function.");
        }
        this.processService(attachmentNode);
    }

    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        BLangService bService = (BLangService)serviceNode;
        for (BLangExpression attachedExpr : bService.getAttachedExprs()) {
            if (!(attachedExpr instanceof BLangSimpleVarRef)) continue;
            ServiceModel serviceModelAttched = this.processService(attachmentNode);
            serviceModelAttched.addPort(serviceModelAttched.getPort());
            if (KnativeUtils.isBlank(serviceModelAttched.getName())) {
                serviceModelAttched.setName(KnativeUtils.getValidName(serviceNode.getName().getValue()) + "-svc");
            }
            return;
        }
        ServiceModel serviceModel = this.processService(attachmentNode);
        if (KnativeUtils.isBlank(serviceModel.getName())) {
            serviceModel.setName(KnativeUtils.getValidName(serviceNode.getName().getValue()) + "-svc");
        }
        BLangTypeInit bListener = (BLangTypeInit)bService.getAttachedExprs().get(0);
        if (serviceModel.getPort() == 8080) {
            if (this.extractPort(bListener) == 9090 || this.extractPort(bListener) == 9091 || this.extractPort(bListener) == 8013 || this.extractPort(bListener) == 8012) {
                throw new KubernetesPluginException("listner port is conflicts with knative port");
            }
            serviceModel.addPort(this.extractPort(bListener));
        }
    }

    @Override
    public void processAnnotation(SimpleVariableNode variableNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        ServiceModel serviceModel = this.processService(attachmentNode);
        if (KnativeUtils.isBlank(serviceModel.getName())) {
            serviceModel.setName(KnativeUtils.getValidName(variableNode.getName().getValue()) + "-svc");
        }
        BLangTypeInit bListener = (BLangTypeInit)((BLangSimpleVariable)variableNode).expr;
        if (serviceModel.getPort() == 8080) {
            serviceModel.addPort(this.extractPort(bListener));
        }
    }

    private ServiceModel processService(AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        String dockerCertPath;
        ServiceModel serviceModel = new ServiceModel();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KnativeUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            ServiceConfiguration serviceConfiguration = ServiceConfiguration.valueOf(keyValue.getKey().toString());
            switch (serviceConfiguration) {
                case name: {
                    serviceModel.setName(KnativeUtils.getValidName(KnativeUtils.getStringValue(keyValue.getValue())));
                    break;
                }
                case labels: {
                    serviceModel.setLabels(KnativeUtils.getMap(keyValue.getValue()));
                    break;
                }
                case annotations: {
                    serviceModel.setAnnotations(KnativeUtils.getMap(keyValue.getValue()));
                    break;
                }
                case dockerHost: {
                    serviceModel.setDockerHost(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case dockerCertPath: {
                    serviceModel.setDockerCertPath(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case registry: {
                    serviceModel.setRegistry(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case username: {
                    serviceModel.setUsername(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case password: {
                    serviceModel.setPassword(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case baseImage: {
                    serviceModel.setBaseImage(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case image: {
                    serviceModel.setImage(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case buildImage: {
                    serviceModel.setBuildImage(KnativeUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
                case push: {
                    serviceModel.setPush(KnativeUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
                case cmd: {
                    serviceModel.setCmd(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case copyFiles: {
                    serviceModel.setCopyFiles(KnativeUtils.getExternalFileMap(keyValue));
                    break;
                }
                case singleYAML: {
                    serviceModel.setSingleYAML(KnativeUtils.getBooleanValue(keyValue.getValue()));
                    break;
                }
                case namespace: {
                    KnativeContext.getInstance().getDataHolder().setNamespace(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case replicas: {
                    serviceModel.setReplicas(KnativeUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case livenessProbe: {
                    serviceModel.setLivenessProbe(this.parseProbeConfiguration(keyValue.getValue()));
                    break;
                }
                case readinessProbe: {
                    serviceModel.setReadinessProbe(this.parseProbeConfiguration(keyValue.getValue()));
                    break;
                }
                case imagePullPolicy: {
                    serviceModel.setImagePullPolicy(KnativeUtils.getStringValue(keyValue.getValue()));
                    break;
                }
                case env: {
                    serviceModel.setEnv(KnativeUtils.getEnvVarMap(keyValue.getValue()));
                    break;
                }
                case podAnnotations: {
                    serviceModel.setPodAnnotations(KnativeUtils.getMap(keyValue.getValue()));
                    break;
                }
                case podTolerations: {
                    serviceModel.setPodTolerations(this.parsePodTolerationConfiguration(keyValue.getValue()));
                    break;
                }
                case dependsOn: {
                    serviceModel.setDependsOn(this.getDependsOn(keyValue));
                    break;
                }
                case imagePullSecrets: {
                    serviceModel.setImagePullSecrets(KnativeUtils.getImagePullSecrets(keyValue));
                    break;
                }
                case containerConcurrency: {
                    serviceModel.setContainerConcurrency(KnativeUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case timeoutSeconds: {
                    serviceModel.setTimeoutSeconds(KnativeUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case port: {
                    serviceModel.setPort(KnativeUtils.getIntValue(keyValue.getValue()));
                    break;
                }
            }
        }
        String dockerHost = System.getenv("DOCKER_HOST");
        if (!KnativeUtils.isBlank(dockerHost)) {
            serviceModel.setDockerHost(dockerHost);
        }
        if (!KnativeUtils.isBlank(dockerCertPath = System.getenv("DOCKER_CERT_PATH"))) {
            serviceModel.setDockerCertPath(dockerCertPath);
        }
        KnativeContext.getInstance().getDataHolder().setServiceModel(serviceModel);
        return serviceModel;
    }

    private List<PodTolerationModel> parsePodTolerationConfiguration(BLangExpression podTolerationValues) throws KubernetesPluginException {
        LinkedList<PodTolerationModel> podTolerationModels = new LinkedList<PodTolerationModel>();
        List podTolerations = ((BLangListConstructorExpr)podTolerationValues).exprs;
        for (BLangExpression podTolerationFieldsAsExpression : podTolerations) {
            List<BLangRecordLiteral.BLangRecordKeyValueField> podTolerationFields = KnativeUtils.convertRecordFields(((BLangRecordLiteral)podTolerationFieldsAsExpression).getFields());
            PodTolerationModel podTolerationModel = new PodTolerationModel();
            block8: for (BLangRecordLiteral.BLangRecordKeyValueField podTolerationField : podTolerationFields) {
                PodTolerationConfiguration podTolerationFieldName = PodTolerationConfiguration.valueOf(podTolerationField.getKey().toString());
                switch (podTolerationFieldName) {
                    case key: {
                        podTolerationModel.setKey(KnativeUtils.getStringValue(podTolerationField.getValue()));
                        continue block8;
                    }
                    case operator: {
                        podTolerationModel.setOperator(KnativeUtils.getStringValue(podTolerationField.getValue()));
                        continue block8;
                    }
                    case value: {
                        podTolerationModel.setValue(KnativeUtils.getStringValue(podTolerationField.getValue()));
                        continue block8;
                    }
                    case effect: {
                        podTolerationModel.setEffect(KnativeUtils.getStringValue(podTolerationField.getValue()));
                        continue block8;
                    }
                    case tolerationSeconds: {
                        podTolerationModel.setTolerationSeconds(KnativeUtils.getIntValue(podTolerationField.getValue()));
                        continue block8;
                    }
                }
                throw new KubernetesPluginException("unknown pod toleration field found: " + podTolerationField.getKey().toString());
            }
            podTolerationModels.add(podTolerationModel);
        }
        return podTolerationModels;
    }

    private ProbeModel parseProbeConfiguration(BLangExpression probeValue) throws KubernetesPluginException {
        if ((probeValue instanceof BLangSimpleVarRef || probeValue instanceof BLangLiteral) && KnativeUtils.getBooleanValue(probeValue)) {
            return new ProbeModel();
        }
        if (probeValue instanceof BLangRecordLiteral) {
            List<BLangRecordLiteral.BLangRecordKeyValueField> buildExtensionRecord = KnativeUtils.convertRecordFields(((BLangRecordLiteral)probeValue).getFields());
            ProbeModel probeModel = new ProbeModel();
            block5: for (BLangRecordLiteral.BLangRecordKeyValueField probeField : buildExtensionRecord) {
                ProbeConfiguration probeConfiguration = ProbeConfiguration.valueOf(probeField.getKey().toString());
                switch (probeConfiguration) {
                    case port: {
                        probeModel.setPort(KnativeUtils.getIntValue(probeField.getValue()));
                        continue block5;
                    }
                    case initialDelaySeconds: {
                        probeModel.setInitialDelaySeconds(KnativeUtils.getIntValue(probeField.getValue()));
                        continue block5;
                    }
                    case periodSeconds: {
                        probeModel.setPeriodSeconds(KnativeUtils.getIntValue(probeField.getValue()));
                        continue block5;
                    }
                }
                throw new KubernetesPluginException("unknown probe field found: " + probeField.getKey().toString());
            }
            return probeModel;
        }
        return null;
    }

    private Set<String> getDependsOn(BLangRecordLiteral.BLangRecordKeyValueField keyValue) {
        HashSet<String> dependsOnList = new HashSet<String>();
        List configAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
        for (BLangExpression bLangExpression : configAnnotation) {
            dependsOnList.add(bLangExpression.toString());
        }
        return dependsOnList;
    }

    private int extractPort(BLangTypeInit bListener) throws KubernetesPluginException {
        try {
            return Integer.parseInt(((BLangExpression)bListener.argsExpr.get(0)).toString());
        }
        catch (NumberFormatException e) {
            throw new KubernetesPluginException("unable to parse port/targetPort for the service: " + ((BLangExpression)bListener.argsExpr.get(0)).toString());
        }
    }

    private static enum PodTolerationConfiguration {
        key,
        operator,
        value,
        effect,
        tolerationSeconds;

    }

    private static enum ProbeConfiguration {
        port,
        initialDelaySeconds,
        periodSeconds;

    }

    private static enum ServiceConfiguration {
        name,
        labels,
        annotations,
        dockerHost,
        dockerCertPath,
        registry,
        username,
        password,
        baseImage,
        image,
        buildImage,
        port,
        push,
        cmd,
        copyFiles,
        singleYAML,
        namespace,
        replicas,
        livenessProbe,
        readinessProbe,
        imagePullPolicy,
        env,
        podAnnotations,
        podTolerations,
        buildExtension,
        dependsOn,
        imagePullSecrets,
        containerConcurrency,
        timeoutSeconds;

    }
}

