/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors.openshift;

import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.openshift.OpenShiftRouteModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class OpenShiftRouteProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processRouteAnnotation(serviceNode.getName(), attachmentNode);
    }

    @Override
    public void processAnnotation(SimpleVariableNode variableNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processRouteAnnotation(variableNode.getName(), attachmentNode);
    }

    private void processRouteAnnotation(IdentifierNode identifierNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        List<BLangRecordLiteral.BLangRecordKeyValueField> bcFields = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        OpenShiftRouteModel openShiftRoute = new OpenShiftRouteModel();
        block6: for (BLangRecordLiteral.BLangRecordKeyValueField bcField : bcFields) {
            switch (OpenShiftRouteFields.valueOf(bcField.getKey().toString())) {
                case name: {
                    openShiftRoute.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(bcField.getValue())));
                    continue block6;
                }
                case labels: {
                    openShiftRoute.setLabels(KubernetesUtils.getMap(bcField.getValue()));
                    continue block6;
                }
                case annotations: {
                    openShiftRoute.setAnnotations(KubernetesUtils.getMap(bcField.getValue()));
                    continue block6;
                }
                case host: {
                    if (bcField.getValue().getKind() == NodeKind.RECORD_LITERAL_EXPR) {
                        BLangRecordLiteral hostRecord = (BLangRecordLiteral)bcField.getValue();
                        openShiftRoute.setDomain(KubernetesUtils.getStringValue(KubernetesUtils.convertRecordFields(hostRecord.getFields()).get(0).getValue()));
                        continue block6;
                    }
                    openShiftRoute.setHost(KubernetesUtils.getStringValue(bcField.getValue()));
                    continue block6;
                }
            }
            throw new KubernetesPluginException("unknown field found for OpenShiftRoute annotation.");
        }
        if (KubernetesUtils.isBlank(openShiftRoute.getName())) {
            openShiftRoute.setName(KubernetesUtils.getValidName(identifierNode.getValue()) + "-openshift-route");
        }
        KubernetesContext.getInstance().getDataHolder().addOpenShiftRouteModel(identifierNode.getValue(), openShiftRoute);
    }

    private static enum OpenShiftRouteFields {
        name,
        namespace,
        labels,
        annotations,
        host,
        domain;

    }
}

