/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.utils;

import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.ObjectFieldSelector;
import io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilder;
import io.fabric8.kubernetes.api.model.ResourceFieldSelector;
import io.fabric8.kubernetes.api.model.ResourceFieldSelectorBuilder;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.SecretKeySelectorBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinax.docker.generator.models.CopyFileModel;
import org.ballerinax.docker.generator.utils.DockerGenUtils;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.knative.EnvVarValueModel;
import org.ballerinax.kubernetes.models.knative.KnativeContext;
import org.ballerinax.kubernetes.models.knative.KnativeDataHolder;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;

public class KnativeUtils {
    private static final boolean DEBUG_ENABLED = "true".equals(System.getenv("BAL_KUBERNETES_DEBUG"));
    private static final PrintStream ERR = System.err;
    private static final PrintStream OUT = System.out;

    public static void writeToFile(String context, String outputFileName) throws IOException {
        KnativeDataHolder dataHolder = KnativeContext.getInstance().getDataHolder();
        KnativeUtils.writeToFile(dataHolder.getK8sArtifactOutputPath(), context, outputFileName);
    }

    public static void writeToFile(Path outputDir, String context, String fileSuffix) throws IOException {
        KnativeDataHolder dataHolder = KnativeContext.getInstance().getDataHolder();
        Path artifactFileName = outputDir.resolve(DockerGenUtils.extractUberJarName(dataHolder.getUberJarPath()) + ".yaml");
        File newFile = artifactFileName.toFile();
        if (newFile.exists()) {
            Files.write(artifactFileName, context.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            return;
        }
        if (newFile.getParentFile().mkdirs()) {
            Files.write(artifactFileName, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return;
        }
        Files.write(artifactFileName, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static byte[] readFileContent(Path targetFilePath) throws KubernetesPluginException {
        File file = targetFilePath.toFile();
        if (file.exists() && !file.isDirectory()) {
            try {
                return Files.readAllBytes(targetFilePath);
            }
            catch (IOException e) {
                throw new KubernetesPluginException("unable to read contents of the file " + targetFilePath);
            }
        }
        throw new KubernetesPluginException("unable to read contents of the file " + targetFilePath);
    }

    public static void copyFileOrDirectory(String source, String destination) throws KubernetesPluginException {
        File src = new File(source);
        File dst = new File(destination);
        try {
            if (Files.isRegularFile(Paths.get(source, new String[0]), new LinkOption[0])) {
                if (Files.isDirectory(dst.toPath(), new LinkOption[0])) {
                    FileUtils.copyFileToDirectory(src, dst);
                } else {
                    FileUtils.copyFile(src, dst);
                }
            } else if (Files.isDirectory(Paths.get(source, new String[0]), new LinkOption[0])) {
                FileUtils.copyDirectory(src, dst);
            }
        }
        catch (IOException e) {
            throw new KubernetesPluginException("error while copying file", e);
        }
    }

    public static void printInfo(String msg) {
        OUT.println(msg);
    }

    public static void printError(String msg) {
        ERR.println("error [k8s plugin]: " + msg);
    }

    public static void printDebug(String msg) {
        if (DEBUG_ENABLED) {
            OUT.println("debug [k8s plugin]: " + msg);
        }
    }

    public static void printWarning(String message) {
        OUT.println("warning [k8s plugin]: " + message);
    }

    public static void printInstruction(String msg) {
        OUT.println(msg);
    }

    public static void deleteDirectory(Path path) throws KubernetesPluginException {
        Path pathToBeDeleted = path.toAbsolutePath();
        if (!Files.exists(pathToBeDeleted, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(pathToBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new KubernetesPluginException("unable to delete directory: " + path, e);
        }
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static String resolveValue(String value) throws KubernetesPluginException {
        int endIndex;
        int startIndex = value.indexOf("$env{");
        if (startIndex >= 0 && (endIndex = value.indexOf("}", startIndex)) > 0) {
            String varName = value.substring(startIndex + 5, endIndex).trim();
            String resolvedVar = Optional.ofNullable(System.getenv(varName)).orElseThrow(() -> new KubernetesPluginException("error resolving value: " + varName + " is not set in the environment."));
            String rest = value.length() > endIndex + 1 ? KnativeUtils.resolveValue(value.substring(endIndex + 1)) : "";
            return value.substring(0, startIndex) + resolvedVar + rest;
        }
        return value;
    }

    public static List<String> getList(BLangExpression expr) throws KubernetesPluginException {
        if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_EXPR) {
            throw new KubernetesPluginException("unable to parse value: " + expr.toString());
        }
        LinkedList<String> scopeSet = new LinkedList<String>();
        if (expr instanceof BLangListConstructorExpr) {
            BLangListConstructorExpr array = (BLangListConstructorExpr)expr;
            for (ExpressionNode bLangExpression : array.getExpressions()) {
                scopeSet.add(KnativeUtils.getStringValue((BLangExpression)bLangExpression));
            }
        }
        return scopeSet;
    }

    public static Map<String, String> getMap(BLangExpression expr) throws KubernetesPluginException {
        if (expr.getKind() != NodeKind.RECORD_LITERAL_EXPR) {
            throw new KubernetesPluginException("unable to parse value: " + expr.toString());
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (expr instanceof BLangRecordLiteral) {
            BLangRecordLiteral fields = (BLangRecordLiteral)expr;
            for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : KnativeUtils.convertRecordFields(fields.getFields())) {
                map.put(keyValue.getKey().toString(), KnativeUtils.getStringValue(keyValue.getValue()));
            }
        }
        return map;
    }

    public static boolean getBooleanValue(BLangExpression expr) throws KubernetesPluginException {
        return Boolean.parseBoolean(KnativeUtils.getStringValue(expr));
    }

    public static long getLongValue(BLangExpression expr) throws KubernetesPluginException {
        return Long.parseLong(KnativeUtils.getStringValue(expr));
    }

    public static int getIntValue(BLangExpression expr) throws KubernetesPluginException {
        return Integer.parseInt(KnativeUtils.getStringValue(expr));
    }

    public static String getStringValue(BLangExpression expr) throws KubernetesPluginException {
        if (expr instanceof BLangSimpleVarRef) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)expr;
            BSymbol symbol = varRef.symbol;
            if (symbol instanceof BConstantSymbol) {
                BFiniteType compileConst;
                BConstantSymbol constantSymbol = (BConstantSymbol)symbol;
                if (constantSymbol.type instanceof BFiniteType && (compileConst = (BFiniteType)constantSymbol.type).getValueSpace().size() > 0) {
                    return KnativeUtils.resolveValue(((BLangExpression)compileConst.getValueSpace().iterator().next()).toString());
                }
            }
        } else if (expr instanceof BLangLiteral) {
            return KnativeUtils.resolveValue(expr.toString());
        }
        throw new KubernetesPluginException("unable to parse value: " + expr.toString());
    }

    public static String getValidName(String name) {
        return name.toLowerCase(Locale.getDefault()).replace("_", "-").replace(".", "-");
    }

    public static Map<String, EnvVarValueModel> getEnvVarMap(BLangExpression envVarValues) throws KubernetesPluginException {
        LinkedHashMap<String, EnvVarValueModel> envVarMap = new LinkedHashMap<String, EnvVarValueModel>();
        if (envVarValues.getKind() == NodeKind.RECORD_LITERAL_EXPR && envVarValues instanceof BLangRecordLiteral) {
            for (BLangRecordLiteral.BLangRecordKeyValueField envVar : KnativeUtils.convertRecordFields(((BLangRecordLiteral)envVarValues).getFields())) {
                String envVarName = envVar.getKey().toString();
                EnvVarValueModel envVarValue = null;
                if (envVar.getValue().getKind() == NodeKind.LITERAL) {
                    envVarValue = new EnvVarValueModel(KnativeUtils.getStringValue(envVar.getValue()));
                } else if (envVar.getValue().getKind() == NodeKind.RECORD_LITERAL_EXPR) {
                    BLangRecordLiteral valueFrom = (BLangRecordLiteral)envVar.getValue();
                    BLangRecordLiteral.BLangRecordKeyValueField bRefType = KnativeUtils.convertRecordFields(valueFrom.getFields()).get(0);
                    BLangSimpleVarRef refType = (BLangSimpleVarRef)bRefType.getKey();
                    switch (refType.variableName.toString()) {
                        case "fieldRef": {
                            BLangRecordLiteral.BLangRecordKeyValueField fieldRefValue = KnativeUtils.convertRecordFields(((BLangRecordLiteral)bRefType.getValue()).getFields()).get(0);
                            EnvVarValueModel.FieldRef fieldRefModel = new EnvVarValueModel.FieldRef();
                            fieldRefModel.setFieldPath(KnativeUtils.getStringValue(fieldRefValue.getValue()));
                            envVarValue = new EnvVarValueModel(fieldRefModel);
                            break;
                        }
                        case "secretKeyRef": {
                            EnvVarValueModel.SecretKeyRef secretKeyRefModel = new EnvVarValueModel.SecretKeyRef();
                            for (BLangRecordLiteral.BLangRecordKeyValueField secretKeyRefFields : KnativeUtils.convertRecordFields(((BLangRecordLiteral)bRefType.getValue()).getFields())) {
                                if (secretKeyRefFields.getKey().toString().equals("key")) {
                                    secretKeyRefModel.setKey(KnativeUtils.getStringValue(secretKeyRefFields.getValue()));
                                    continue;
                                }
                                if (!secretKeyRefFields.getKey().toString().equals("name")) continue;
                                secretKeyRefModel.setName(KnativeUtils.getStringValue(secretKeyRefFields.getValue()));
                            }
                            envVarValue = new EnvVarValueModel(secretKeyRefModel);
                            break;
                        }
                        case "resourceFieldRef": {
                            BLangRecordLiteral.BLangRecordKeyValueField secretKeyRefFields;
                            EnvVarValueModel.ResourceFieldRef resourceFieldRefModel = new EnvVarValueModel.ResourceFieldRef();
                            secretKeyRefFields = KnativeUtils.convertRecordFields(((BLangRecordLiteral)bRefType.getValue()).getFields()).iterator();
                            while (secretKeyRefFields.hasNext()) {
                                BLangRecordLiteral.BLangRecordKeyValueField resourceFieldRefFields = secretKeyRefFields.next();
                                if (resourceFieldRefFields.getKey().toString().equals("containerName")) {
                                    resourceFieldRefModel.setContainerName(KnativeUtils.getStringValue(resourceFieldRefFields.getValue()));
                                    continue;
                                }
                                if (!resourceFieldRefFields.getKey().toString().equals("resource")) continue;
                                resourceFieldRefModel.setResource(KnativeUtils.getStringValue(resourceFieldRefFields.getValue()));
                            }
                            envVarValue = new EnvVarValueModel(resourceFieldRefModel);
                            break;
                        }
                        case "configMapKeyRef": {
                            EnvVarValueModel.ConfigMapKeyValue configMapKeyRefModel = new EnvVarValueModel.ConfigMapKeyValue();
                            for (BLangRecordLiteral.BLangRecordKeyValueField configMapKeyRefFields : KnativeUtils.convertRecordFields(((BLangRecordLiteral)bRefType.getValue()).getFields())) {
                                if (configMapKeyRefFields.getKey().toString().equals("key")) {
                                    configMapKeyRefModel.setKey(KnativeUtils.getStringValue(configMapKeyRefFields.getValue()));
                                    continue;
                                }
                                if (!configMapKeyRefFields.getKey().toString().equals("name")) continue;
                                configMapKeyRefModel.setName(KnativeUtils.getStringValue(configMapKeyRefFields.getValue()));
                            }
                            envVarValue = new EnvVarValueModel(configMapKeyRefModel);
                            break;
                        }
                    }
                }
                envVarMap.put(envVarName, envVarValue);
            }
        }
        return envVarMap;
    }

    public static Set<String> getImagePullSecrets(BLangRecordLiteral.BLangRecordKeyValueField keyValue) throws KubernetesPluginException {
        HashSet<String> imagePullSecrets = new HashSet<String>();
        List configAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
        for (BLangExpression bLangExpression : configAnnotation) {
            imagePullSecrets.add(KnativeUtils.getStringValue(bLangExpression));
        }
        return imagePullSecrets;
    }

    public static Set<CopyFileModel> getExternalFileMap(BLangRecordLiteral.BLangRecordKeyValueField keyValue) throws KubernetesPluginException {
        HashSet<CopyFileModel> externalFiles = new HashSet<CopyFileModel>();
        List configAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
        for (BLangExpression bLangExpression : configAnnotation) {
            List<BLangRecordLiteral.BLangRecordKeyValueField> annotationValues = KnativeUtils.convertRecordFields(((BLangRecordLiteral)bLangExpression).getFields());
            CopyFileModel externalFileModel = new CopyFileModel();
            for (BLangRecordLiteral.BLangRecordKeyValueField annotation : annotationValues) {
                switch (annotation.getKey().toString()) {
                    case "sourceFile": {
                        externalFileModel.setSource(KnativeUtils.getStringValue(annotation.getValue()));
                        break;
                    }
                    case "target": {
                        externalFileModel.setTarget(KnativeUtils.getStringValue(annotation.getValue()));
                        break;
                    }
                }
            }
            if (KnativeUtils.isBlank(externalFileModel.getSource())) {
                throw new KubernetesPluginException("@kubernetes:Deployment copyFiles source cannot be empty.");
            }
            if (KnativeUtils.isBlank(externalFileModel.getTarget())) {
                throw new KubernetesPluginException("@kubernetes:Deployment copyFiles target cannot be empty.");
            }
            externalFiles.add(externalFileModel);
        }
        return externalFiles;
    }

    public static List<EnvVar> populateEnvVar(Map<String, EnvVarValueModel> envMap) {
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        if (envMap == null) {
            return envVars;
        }
        envMap.forEach((k, v) -> {
            EnvVar envVar = null;
            if (v.getValue() != null) {
                envVar = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)k)).withValue(v.getValue())).build();
            } else if (v.getValueFrom() instanceof EnvVarValueModel.FieldRef) {
                EnvVarValueModel.FieldRef fieldRefModel = (EnvVarValueModel.FieldRef)v.getValueFrom();
                ObjectFieldSelector fieldRef = ((ObjectFieldSelectorBuilder)new ObjectFieldSelectorBuilder().withFieldPath(fieldRefModel.getFieldPath())).build();
                EnvVarSource envVarSource = ((EnvVarSourceBuilder)new EnvVarSourceBuilder().withFieldRef(fieldRef)).build();
                envVar = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)k)).withValueFrom(envVarSource)).build();
            } else if (v.getValueFrom() instanceof EnvVarValueModel.SecretKeyRef) {
                EnvVarValueModel.SecretKeyRef secretKeyRefModel = (EnvVarValueModel.SecretKeyRef)v.getValueFrom();
                SecretKeySelector secretRef = ((SecretKeySelectorBuilder)((SecretKeySelectorBuilder)new SecretKeySelectorBuilder().withName(secretKeyRefModel.getName())).withKey(secretKeyRefModel.getKey())).build();
                EnvVarSource envVarSource = ((EnvVarSourceBuilder)new EnvVarSourceBuilder().withSecretKeyRef(secretRef)).build();
                envVar = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)k)).withValueFrom(envVarSource)).build();
            } else if (v.getValueFrom() instanceof EnvVarValueModel.ResourceFieldRef) {
                EnvVarValueModel.ResourceFieldRef resourceFieldRefModel = (EnvVarValueModel.ResourceFieldRef)v.getValueFrom();
                ResourceFieldSelector resourceFieldRef = ((ResourceFieldSelectorBuilder)((ResourceFieldSelectorBuilder)new ResourceFieldSelectorBuilder().withContainerName(resourceFieldRefModel.getContainerName())).withResource(resourceFieldRefModel.getResource())).build();
                EnvVarSource envVarSource = ((EnvVarSourceBuilder)new EnvVarSourceBuilder().withResourceFieldRef(resourceFieldRef)).build();
                envVar = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)k)).withValueFrom(envVarSource)).build();
            } else if (v.getValueFrom() instanceof EnvVarValueModel.ConfigMapKeyValue) {
                EnvVarValueModel.ConfigMapKeyValue configMapKeyValue = (EnvVarValueModel.ConfigMapKeyValue)v.getValueFrom();
                ConfigMapKeySelector configMapKey = ((ConfigMapKeySelectorBuilder)((ConfigMapKeySelectorBuilder)new ConfigMapKeySelectorBuilder().withKey(configMapKeyValue.getKey())).withName(configMapKeyValue.getName())).build();
                EnvVarSource envVarSource = ((EnvVarSourceBuilder)new EnvVarSourceBuilder().withConfigMapKeyRef(configMapKey)).build();
                envVar = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)k)).withValueFrom(envVarSource)).build();
            }
            if (envVar != null) {
                envVars.add(envVar);
            }
        });
        return envVars;
    }

    public static List<BLangRecordLiteral.BLangRecordKeyValueField> convertRecordFields(List<RecordLiteralNode.RecordField> fields) {
        return fields.stream().map(f -> (BLangRecordLiteral.BLangRecordKeyValueField)f).collect(Collectors.toList());
    }
}

