/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.ballerinalang.test.runtime.entity.ModuleCoverage;
import org.ballerinalang.test.runtime.util.CodeCoverageUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.tools.ExecFileLoader;

public class CoverageReport {
    private final String title;
    private Path executionDataFile;
    private Path classesDirectory;
    private final Path projectDir;
    private ExecFileLoader execFileLoader;
    private Path sourceJarPath;
    private String orgName;
    private String moduleName;

    public CoverageReport(Path sourceJarPath, Path targetDirPath, String orgName, String moduleName) {
        this.sourceJarPath = sourceJarPath;
        this.orgName = orgName;
        this.moduleName = moduleName;
        this.projectDir = targetDirPath.resolve("coverage");
        this.title = this.projectDir.toFile().getName();
        this.classesDirectory = this.projectDir.resolve("bin");
        this.executionDataFile = this.projectDir.resolve("ballerina.exec");
        this.execFileLoader = new ExecFileLoader();
    }

    public void generateReport() throws IOException {
        CodeCoverageUtils.unzipCompiledSource(this.sourceJarPath, this.projectDir, this.orgName, this.moduleName);
        this.execFileLoader.load(this.executionDataFile.toFile());
        IBundleCoverage bundleCoverage = this.analyzeStructure();
        this.createReport(bundleCoverage);
    }

    private IBundleCoverage analyzeStructure() throws IOException {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.execFileLoader.getExecutionDataStore(), coverageBuilder);
        analyzer.analyzeAll(this.classesDirectory.toFile());
        return coverageBuilder.getBundle(this.title);
    }

    private void createReport(IBundleCoverage bundleCoverage) {
        for (IPackageCoverage packageCoverage : bundleCoverage.getPackages()) {
            boolean containsSourceFiles = ".".equals(this.moduleName) ? packageCoverage.getName().isEmpty() : packageCoverage.getName().contains(this.orgName + "/" + this.moduleName);
            if (!containsSourceFiles) continue;
            for (ISourceFileCoverage sourceFileCoverage : packageCoverage.getSourceFiles()) {
                if (!sourceFileCoverage.getName().contains(".bal") || sourceFileCoverage.getName().contains("tests/")) continue;
                ArrayList<Integer> coveredLines = new ArrayList<Integer>();
                ArrayList<Integer> missedLines = new ArrayList<Integer>();
                for (int i = sourceFileCoverage.getFirstLine(); i <= sourceFileCoverage.getLastLine(); ++i) {
                    ILine line = sourceFileCoverage.getLine(i);
                    if (line.getInstructionCounter().getTotalCount() == 0 && line.getBranchCounter().getTotalCount() == 0) continue;
                    if (line.getBranchCounter().getCoveredCount() == 0 && line.getBranchCounter().getMissedCount() > 0 || line.getStatus() == 1) {
                        missedLines.add(i);
                        continue;
                    }
                    if (line.getStatus() != 3 && line.getStatus() != 2) continue;
                    coveredLines.add(i);
                }
                ModuleCoverage.getInstance().addSourceFileCoverage(this.moduleName, sourceFileCoverage.getName(), coveredLines, missedLines);
            }
        }
    }
}

