/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class ModuleCoverage {
    private String name;
    private int coveredLines;
    private int missedLines;
    private float coveragePercentage;
    private List<SourceFile> sourceFiles = new ArrayList<SourceFile>();
    private static PrintStream errStream = System.err;
    private static ModuleCoverage instance = new ModuleCoverage();

    public static ModuleCoverage getInstance() {
        return instance;
    }

    public void addSourceFileCoverage(String moduleName, String fileName, List<Integer> coveredLines, List<Integer> missedLines) {
        SourceFile sourceFile = new SourceFile(moduleName, fileName, coveredLines, missedLines);
        this.sourceFiles.add(sourceFile);
        this.coveredLines += coveredLines.size();
        this.missedLines += missedLines.size();
        this.setCoveragePercentage();
    }

    private void setCoveragePercentage() {
        float coverageVal = (float)this.coveredLines / (float)(this.coveredLines + this.missedLines) * 100.0f;
        this.coveragePercentage = (float)((double)Math.round((double)coverageVal * 100.0) / 100.0);
    }

    public float getCoveragePercentage() {
        return this.coveragePercentage;
    }

    public int getCoveredLines() {
        return this.coveredLines;
    }

    public int getMissedLines() {
        return this.missedLines;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private static class SourceFile {
        private String name;
        private List<Integer> coveredLines;
        private List<Integer> missedLines;
        private float coveragePercentage;
        private String sourceCode;

        private SourceFile(String moduleName, String fileName, List<Integer> coveredLines, List<Integer> missedLines) {
            this.name = fileName;
            this.coveredLines = coveredLines;
            this.missedLines = missedLines;
            this.setCoveragePercentage(coveredLines, missedLines);
            this.setSourceCode(moduleName, fileName);
        }

        private void setCoveragePercentage(List<Integer> coveredLines, List<Integer> missedLines) {
            float coverageVal = (float)coveredLines.size() / (float)(coveredLines.size() + missedLines.size()) * 100.0f;
            this.coveragePercentage = (float)((double)Math.round((double)coverageVal * 100.0) / 100.0);
        }

        private void setSourceCode(String moduleName, String fileName) {
            Path sourceFile = ".".equals(moduleName) ? Paths.get(fileName, new String[0]) : Paths.get("src", new String[0]).resolve(moduleName).resolve(fileName);
            StringBuilder contentBuilder = new StringBuilder();
            try (Stream<String> stream = Files.lines(sourceFile, StandardCharsets.UTF_8);){
                stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
            }
            catch (IOException e) {
                errStream.println("error while analyzing code coverage" + e);
                Runtime.getRuntime().exit(1);
            }
            this.sourceCode = contentBuilder.toString();
        }

        public float getCoveragePercentage() {
            return this.coveragePercentage;
        }

        public String getSourceCode() {
            return this.sourceCode;
        }

        public List<Integer> getCoveredLines() {
            return this.coveredLines;
        }

        public List<Integer> getMissedLines() {
            return this.missedLines;
        }

        public String getName() {
            return this.name;
        }
    }
}

