/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.test.runtime.entity.ModuleStatus;
import org.ballerinalang.test.runtime.entity.TesterinaResult;
import org.ballerinalang.test.runtime.util.TesterinaUtils;

public class TesterinaReport {
    private PrintStream outStream;
    private Map<String, TestSummary> testReportOfPackage = new HashMap<String, TestSummary>();
    private boolean failure;
    private boolean isReportRequired;

    public TesterinaReport() {
        this(System.out);
    }

    public TesterinaReport(PrintStream outStream) {
        this.outStream = outStream;
    }

    public void printTestSuiteSummary(String packageName) {
        TestSummary testSummary = this.testReportOfPackage.get(packageName);
        if (testSummary == null) {
            this.printTestSuiteResult(0, 0, 0);
            return;
        }
        this.outStream.println();
        if (!testSummary.failedTests.isEmpty()) {
            for (TesterinaResult failedResult : testSummary.failedTests) {
                this.outStream.println("\t[fail] " + failedResult.getTestFunctionName() + ":");
                this.outStream.println("\t    " + TesterinaUtils.formatError(failedResult.getAssertFailureMessage()));
            }
        }
        if (!testSummary.passedTests.isEmpty()) {
            for (TesterinaResult passedResult : testSummary.passedTests) {
                this.outStream.println("\t[pass] " + passedResult.getTestFunctionName());
            }
        }
        this.printTestSuiteResult(testSummary.passedTests.size(), testSummary.failedTests.size(), testSummary.skippedTests.size());
    }

    private void printTestSuiteResult(int passed, int failed, int skipped) {
        this.outStream.println();
        this.outStream.println("\t" + passed + " passing");
        this.outStream.println("\t" + failed + " failing");
        this.outStream.println("\t" + skipped + " skipped");
        this.outStream.println();
    }

    public void addPackageReport(String packageName) {
        this.testReportOfPackage.computeIfAbsent(packageName, summary -> new TestSummary());
    }

    public void addFunctionResult(String packageName, TesterinaResult result) {
        ModuleStatus.Status status;
        this.testReportOfPackage.computeIfAbsent(packageName, summary -> new TestSummary());
        TestSummary testSummary = this.testReportOfPackage.get(packageName);
        if (result.isSkipped()) {
            this.failure = true;
            status = ModuleStatus.Status.SKIPPED;
            testSummary.skippedTests.add(result);
        } else if (result.isPassed()) {
            status = ModuleStatus.Status.PASSED;
            testSummary.passedTests.add(result);
        } else {
            this.failure = true;
            status = ModuleStatus.Status.FAILURE;
            testSummary.failedTests.add(result);
        }
        if (this.isReportRequired) {
            ModuleStatus.getInstance().addTestSummary(result.getTestFunctionName(), status, result.getAssertFailureMessage());
        }
    }

    public boolean isFailure() {
        return this.failure;
    }

    public void setReportRequired(boolean reportRequired) {
        this.isReportRequired = reportRequired;
    }

    private static class TestSummary {
        List<TesterinaResult> passedTests = new ArrayList<TesterinaResult>();
        List<TesterinaResult> failedTests = new ArrayList<TesterinaResult>();
        List<TesterinaResult> skippedTests = new ArrayList<TesterinaResult>();

        private TestSummary() {
        }

        public List<TesterinaResult> getPassedTests() {
            return this.passedTests;
        }

        public List<TesterinaResult> getFailedTests() {
            return this.failedTests;
        }

        public List<TesterinaResult> getSkippedTests() {
            return this.skippedTests;
        }
    }
}

