/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CodeCoverageUtils {
    public static void unzipCompiledSource(Path source, Path destination, String orgName, String moduleName) {
        String destJarDir = destination.resolve(source.getFileName()).toString();
        try (JarFile jarFile = new JarFile(source.toFile());){
            Enumeration<JarEntry> enu = jarFile.entries();
            while (enu.hasMoreElements()) {
                JarEntry entry = enu.nextElement();
                File file = new File(destJarDir, entry.getName());
                if (!CodeCoverageUtils.isRequiredFile(entry.getName(), orgName, moduleName)) continue;
                if (!file.exists()) {
                    Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                }
                if (entry.isDirectory()) continue;
                InputStream is = jarFile.getInputStream(entry);
                Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            CodeCoverageUtils.copyClassFilesToBinPath(destination, destJarDir, orgName, moduleName);
            CodeCoverageUtils.deleteDirectory(new File(destJarDir));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyClassFilesToBinPath(Path destination, String destJarDir, String orgName, String moduleName) throws IOException {
        Path binClassDirPath;
        Path extractedPath;
        if (".".equals(moduleName)) {
            extractedPath = Paths.get(destJarDir, new String[0]);
            binClassDirPath = destination.resolve("bin");
        } else {
            extractedPath = Paths.get(destJarDir, new String[0]).resolve(orgName).resolve(moduleName);
            binClassDirPath = destination.resolve("bin").resolve(moduleName);
        }
        if (binClassDirPath.toFile().exists()) {
            CodeCoverageUtils.deleteDirectory(binClassDirPath.toFile());
        }
        Files.createDirectories(binClassDirPath, new FileAttribute[0]);
        Files.move(extractedPath, binClassDirPath, StandardCopyOption.REPLACE_EXISTING);
    }

    private static boolean isRequiredFile(String path, String orgName, String moduleName) {
        if (path.contains("___init") || path.contains("META-INF") || path.contains("tests/")) {
            return false;
        }
        if (path.contains("Frame") && path.contains("module")) {
            return false;
        }
        if (path.contains("Frame") && path.contains(orgName)) {
            return false;
        }
        return !path.contains(orgName + "/" + moduleName + "/" + moduleName + ".class");
    }

    public static void deleteDirectory(File dir) throws IOException {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                CodeCoverageUtils.deleteDirectory(f);
            }
        }
        Files.deleteIfExists(dir.toPath());
    }

    public static void unzipReportResources(InputStream source, File target) throws IOException {
        ZipEntry nextEntry;
        ZipInputStream zipStream = new ZipInputStream(source);
        while ((nextEntry = zipStream.getNextEntry()) != null) {
            String name = nextEntry.getName();
            if (name.endsWith("/")) continue;
            File nextFile = new File(target, name);
            File parent = nextFile.getParentFile();
            if (parent != null) {
                Files.createDirectories(parent.toPath(), new FileAttribute[0]);
            }
            FileOutputStream targetStream = new FileOutputStream(nextFile);
            Throwable throwable = null;
            try {
                int nextCount;
                int bufferSize = 4096;
                byte[] buffer = new byte[4096];
                while ((nextCount = zipStream.read(buffer)) >= 0) {
                    ((OutputStream)targetStream).write(buffer, 0, nextCount);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (targetStream == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)targetStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((OutputStream)targetStream).close();
            }
        }
    }
}

