/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.time.util;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.zone.ZoneRulesException;
import java.util.Date;
import java.util.TimeZone;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.time.util.Constants;

public class TimeUtils {
    public static MapValue<String, Object> createTimeZone(MapValue<String, Object> timeZoneRecord, String zoneIdValue) {
        ZoneId zoneId = TimeUtils.getTimeZone(zoneIdValue);
        TimeZone tz = TimeZone.getTimeZone(zoneId);
        int offsetInMills = tz.getOffset(new Date().getTime());
        long offset = offsetInMills / 1000;
        return BallerinaValues.createRecord(timeZoneRecord, (Object[])new Object[]{zoneIdValue, offset});
    }

    public static MapValue<String, Object> createDateTime(int year, int month, int day, int hour, int minute, int second, int milliSecond, String zoneIDStr) {
        ZoneId zoneId;
        int nanoSecond = milliSecond * 1000000;
        if (zoneIDStr.isEmpty()) {
            zoneId = ZoneId.systemDefault();
            zoneIDStr = zoneId.toString();
        } else {
            zoneId = TimeUtils.getTimeZone(zoneIDStr);
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.of(year, month, day, hour, minute, second, nanoSecond, zoneId);
        long timeValue = zonedDateTime.toInstant().toEpochMilli();
        return TimeUtils.createTimeRecord(TimeUtils.getTimeZoneRecord(), TimeUtils.getTimeRecord(), timeValue, zoneIDStr);
    }

    public static ZoneId getTimeZone(String zoneIdValue) {
        try {
            return ZoneId.of(zoneIdValue);
        }
        catch (ZoneRulesException e) {
            throw TimeUtils.getTimeError("invalid timezone id: " + zoneIdValue);
        }
    }

    public static MapValue<String, Object> createTimeRecord(MapValue<String, Object> timeZoneRecord, MapValue<String, Object> timeRecord, long millis, String zoneIdName) {
        MapValue<String, Object> timezone = TimeUtils.createTimeZone(timeZoneRecord, zoneIdName);
        return BallerinaValues.createRecord(timeRecord, (Object[])new Object[]{millis, timezone});
    }

    public static MapValue<String, Object> getTimeZoneRecord() {
        return BallerinaValues.createRecordValue((BPackage)Constants.TIME_PACKAGE_ID, (String)"TimeZone");
    }

    public static MapValue<String, Object> getTimeRecord() {
        return BallerinaValues.createRecordValue((BPackage)Constants.TIME_PACKAGE_ID, (String)"Time");
    }

    public static ErrorValue getTimeError(String message) {
        return BallerinaErrors.createError((String)"{ballerina/time}TimeError", (String)message);
    }

    public static MapValue<String, Object> getTimeRecord(TemporalAccessor dateTime, String dateString, String pattern) {
        String zoneId;
        MapValue<String, Object> timeZoneRecord = TimeUtils.getTimeZoneRecord();
        MapValue<String, Object> timeRecord = TimeUtils.getTimeRecord();
        long epochTime = -1L;
        try {
            epochTime = Instant.from(dateTime).toEpochMilli();
            zoneId = String.valueOf(ZoneId.from(dateTime));
        }
        catch (DateTimeException e) {
            if (epochTime < 0L) {
                throw TimeUtils.getTimeError("failed to parse \"" + dateString + "\" to the " + pattern + " format");
            }
            zoneId = ZoneId.systemDefault().toString();
        }
        return TimeUtils.createTimeRecord(timeZoneRecord, timeRecord, epochTime, zoneId);
    }

    public static String getFormattedString(MapValue<String, Object> timeRecord, String pattern) throws IllegalArgumentException {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTime.format(dateTimeFormatter);
    }

    public static String getDefaultString(MapValue<String, Object> timeRecord) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        return dateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static MapValue<String, Object> parseTime(String dateValue, String pattern) {
        try {
            ZoneId zoneId;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            TemporalAccessor temporalAccessor = formatter.parse(dateValue);
            int year = 1970;
            int month = 1;
            int day = 1;
            int hour = 0;
            int minute = 0;
            int second = 0;
            int nanoSecond = 0;
            if (temporalAccessor.isSupported(ChronoField.YEAR)) {
                year = temporalAccessor.get(ChronoField.YEAR);
            }
            if (temporalAccessor.isSupported(ChronoField.MONTH_OF_YEAR)) {
                month = temporalAccessor.get(ChronoField.MONTH_OF_YEAR);
            }
            if (temporalAccessor.isSupported(ChronoField.DAY_OF_MONTH)) {
                day = temporalAccessor.get(ChronoField.DAY_OF_MONTH);
            }
            if (temporalAccessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                hour = temporalAccessor.get(ChronoField.HOUR_OF_DAY);
            }
            if (temporalAccessor.isSupported(ChronoField.MINUTE_OF_HOUR)) {
                minute = temporalAccessor.get(ChronoField.MINUTE_OF_HOUR);
            }
            if (temporalAccessor.isSupported(ChronoField.SECOND_OF_MINUTE)) {
                second = temporalAccessor.get(ChronoField.SECOND_OF_MINUTE);
            }
            if (temporalAccessor.isSupported(ChronoField.NANO_OF_SECOND)) {
                nanoSecond = temporalAccessor.get(ChronoField.NANO_OF_SECOND);
            }
            try {
                zoneId = ZoneId.from(temporalAccessor);
            }
            catch (DateTimeException e) {
                zoneId = ZoneId.systemDefault();
            }
            ZonedDateTime zonedDateTime = ZonedDateTime.of(year, month, day, hour, minute, second, nanoSecond, zoneId);
            long timeValue = zonedDateTime.toInstant().toEpochMilli();
            return TimeUtils.createTimeRecord(TimeUtils.getTimeZoneRecord(), TimeUtils.getTimeRecord(), timeValue, zoneId.toString());
        }
        catch (DateTimeParseException e) {
            throw TimeUtils.getTimeError("parse date \"" + dateValue + "\" for the format \"" + pattern + "\" failed:" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw TimeUtils.getTimeError("invalid pattern: " + pattern);
        }
    }

    public static ZonedDateTime getZonedDateTime(MapValue<String, Object> timeRecord) {
        String zoneIdName;
        ZonedDateTime dateTime = (ZonedDateTime)timeRecord.getNativeData("ZonedDateTime");
        if (dateTime != null) {
            return dateTime;
        }
        long timeData = (Long)timeRecord.get((Object)"time");
        MapValue zoneData = (MapValue)timeRecord.get((Object)"zone");
        ZoneId zoneId = zoneData != null ? ((zoneIdName = zoneData.get((Object)"id").toString()).isEmpty() ? ZoneId.systemDefault() : TimeUtils.getTimeZone(zoneIdName)) : ZoneId.systemDefault();
        dateTime = Instant.ofEpochMilli(timeData).atZone(zoneId);
        timeRecord.addNativeData("ZonedDateTime", (Object)dateTime);
        return dateTime;
    }

    public static MapValue<String, Object> changeTimezone(MapValue<String, Object> timeRecord, String zoneId) {
        MapValue<String, Object> timezone = TimeUtils.createTimeZone(TimeUtils.getTimeZoneRecord(), zoneId);
        timeRecord.put((Object)"zone", timezone);
        TimeUtils.clearRecordCache(timeRecord);
        return timeRecord;
    }

    private static void clearRecordCache(MapValue<String, Object> timeRecord) {
        timeRecord.addNativeData("ZonedDateTime", null);
    }

    public static String getZoneId(MapValue<String, Object> timeRecord) {
        MapValue zoneData = (MapValue)timeRecord.get((Object)"zone");
        return zoneData.get((Object)"id").toString();
    }
}

