/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.log;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.LogManager;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.logging.BLogManager;
import org.ballerinalang.logging.util.BLogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogFunction {
    protected static final BLogManager LOG_MANAGER = (BLogManager)LogManager.getLogManager();
    private static final Logger ballerinaRootLogger = LoggerFactory.getLogger((String)"ballerina");

    protected static Logger getLogger(String pkg) {
        if (".".equals(pkg) || pkg == null) {
            return ballerinaRootLogger;
        }
        return LoggerFactory.getLogger((String)(ballerinaRootLogger.getName() + "." + pkg));
    }

    static void logMessage(final Strand strand, final Object message, BLogLevel logLevel, String pckg, BiConsumer<String, String> consumer) {
        Supplier<String> logMessage = new Supplier<String>(){
            private String msg = null;

            @Override
            public String get() {
                if (this.msg == null) {
                    Object arg = message;
                    arg = arg instanceof FPValue ? ((FPValue)arg).getFunction().apply(new Object[]{strand}) : arg;
                    this.msg = arg.toString();
                }
                return this.msg;
            }
        };
        if (LOG_MANAGER.getPackageLogLevel(pckg).value() <= logLevel.value()) {
            consumer.accept(pckg, (String)logMessage.get());
            ObserveUtils.logMessageToActiveSpan((Strand)strand, (String)logLevel.name(), (Supplier)logMessage, (logLevel == BLogLevel.ERROR ? 1 : 0) != 0);
        }
    }

    static String getPackagePath() {
        String className = Thread.currentThread().getStackTrace()[4].getClassName();
        int lastIndex = className.lastIndexOf(".");
        if (lastIndex != -1) {
            return className.substring(0, lastIndex).replace(".", "/");
        }
        return ".";
    }
}

