/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.compiler.backend.jvm;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;

@BallerinaFunction(orgName="ballerina", packageName="compiler_backend_jvm", functionName="writeExecutableJarToFile", args={@Argument(name="jarFile", type=TypeKind.RECORD), @Argument(name="targetPath", type=TypeKind.STRING)})
public class WriteExecutableJarFile {
    private static final String PKG_ENTRIES = "pkgEntries";
    private static final String MANIFEST_ENTRIES = "manifestEntries";

    public static void writeExecutableJarToFile(Strand strand, MapValue oJarFile, String targetPath) {
        try {
            WriteExecutableJarFile.writeJarContent((MapValue<String, MapValue>)oJarFile, new FileOutputStream(targetPath));
        }
        catch (IOException e) {
            throw new BLangCompilerException("jar file generation failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void writeJarContent(MapValue<String, MapValue> entries, OutputStream out) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (entries.containsKey((Object)MANIFEST_ENTRIES)) {
            MapValue manifestEntries = (MapValue)entries.get((Object)MANIFEST_ENTRIES);
            manifestEntries.entrySet().forEach(entry -> manifest.getMainAttributes().put(new Attributes.Name((String)entry.getKey()), entry.getValue()));
        }
        try (JarOutputStream target = new JarOutputStream(out, manifest);){
            if (!entries.containsKey((Object)PKG_ENTRIES)) {
                throw new BLangCompilerException("no class file entries found in the record");
            }
            MapValue jarEntries = (MapValue)entries.get((Object)PKG_ENTRIES);
            for (Map.Entry keyVal : jarEntries.entrySet()) {
                byte[] entryContent = ((ArrayValue)keyVal.getValue()).getBytes();
                JarEntry entry2 = new JarEntry((String)keyVal.getKey());
                target.putNextEntry(entry2);
                target.write(entryContent);
                target.closeEntry();
            }
        }
    }
}

