/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jdbc;

import java.util.Locale;
import java.util.Properties;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.sql.datasource.SQLDatasource;
import org.ballerinalang.sql.utils.ClientUtils;
import org.ballerinalang.sql.utils.ErrorGenerator;

public class NativeImpl {
    public static Object createClient(ObjectValue client, MapValue<String, Object> clientConfig, MapValue<String, Object> globalPool) {
        MapValue<String, Object> connectionPool;
        String url = clientConfig.getStringValue("url");
        if (!NativeImpl.isJdbcUrlValid(url)) {
            return ErrorGenerator.getSQLApplicationError((String)("Invalid JDBC URL: " + url));
        }
        String user = clientConfig.getStringValue("user");
        String password = clientConfig.getStringValue("password");
        MapValue options = clientConfig.getMapValue("options");
        MapValue properties = null;
        String datasourceName = null;
        Properties poolProperties = null;
        if (options != null) {
            properties = options.getMapValue("properties");
            datasourceName = options.getStringValue("datasourceName");
            if (properties != null) {
                for (Object propKey : properties.getKeys()) {
                    if (!propKey.toString().toLowerCase(Locale.ENGLISH).matches(".*(connect).*(timeout).*")) continue;
                    poolProperties = new Properties();
                    poolProperties.setProperty("ConnectionTimeout", properties.getStringValue(propKey.toString()));
                }
            }
        }
        if ((connectionPool = clientConfig.getMapValue("connectionPool")) == null) {
            connectionPool = globalPool;
        }
        SQLDatasource.SQLDatasourceParams sqlDatasourceParams = new SQLDatasource.SQLDatasourceParams().setUrl(url).setUser(user).setPassword(password).setDatasourceName(datasourceName).setOptions(properties).setPoolProperties(poolProperties).setConnectionPool(connectionPool);
        return ClientUtils.createClient((ObjectValue)client, (SQLDatasource.SQLDatasourceParams)sqlDatasourceParams);
    }

    private static boolean isJdbcUrlValid(String jdbcUrl) {
        return !jdbcUrl.isEmpty() && jdbcUrl.trim().startsWith("jdbc:");
    }

    public static Object close(ObjectValue client) {
        return ClientUtils.close((ObjectValue)client);
    }
}

